/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.DayTimeBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.SingleColorBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.SingleImageBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TimeBlockBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.UiColorBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.UiTimeBlockBackgroundStyle;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.ui.CaretPositionCorrector;
import util.ui.ExtensionFileFilter;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class ProgramTableSettingsTab
implements SettingsTab,
ActionListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramTableSettingsTab.class);
    private JPanel mSettingsPn;
    private JComboBox mProgramArrangementCB;
    private JComboBox mBackgroundStyleCB;
    private JButton mConfigBackgroundStyleBt;
    private JButton mDefaultBtn;
    private JSpinner mColWidth;
    private JSpinner mStartOfDayTimeSp;
    private JSpinner mEndOfDayTimeSp;
    private JCheckBox mMouseOverCb;
    private ColorLabel mMouseOverColorLb;
    private ColorLabel mForegroundColorLb;
    private short mLastSelectedLayoutIndex;
    private JCheckBox mCutLongTitlesCB;
    private JSpinner mCutLongTitlesSelection;
    private JCheckBox mAutoScrollCb;
    private JSpinner mDescriptionLines;
    private JLabel mCutLongTitlesLabel;
    private JCheckBox mShortProgramsCB;
    private JSpinner mShortProgramsMinutes;
    private JLabel mShortProgramsLabel;
    private ColorButton mProgramPanelForegroundColorChangeBtn;
    private JComponent mForegroundSeparator;
    private JLabel mForegroundLabel;
    private JCheckBox mTypeAsYouFind;
    private JCheckBox mAutoChangeDate;
    private ColorLabel mLightColorLb;
    private ColorLabel mDarkColorLb;
    private ColorButton mLight;
    private ColorButton mDark;
    private JCheckBox mShowScrollHighlight;

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mDefaultBtn) {
            this.mColWidth.setValue(Settings.propColumnWidth.getDefault());
        }
    }

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu", "");
        this.mSettingsPn = new JPanel(layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        int currentRow = 1;
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("layout", "Layout")), cc.xyw(1, currentRow, 8));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("programArrangement", "Program arrangement")), cc.xy(2, currentRow += 2));
        String[] arrangementArr = new String[]{mLocalizer.msg("timeSynchronous", "Time synchronous"), mLocalizer.msg("realSynchronous", "Real time synchronous"), mLocalizer.msg("compact", "Compact"), mLocalizer.msg("realCompact", "Real compact"), mLocalizer.msg("timeBlock", "Time block"), mLocalizer.msg("compactTimeBlock", "Compact time block"), mLocalizer.msg("optimizedCompactTimeBlock", "Optimized compact time block")};
        this.mProgramArrangementCB = new JComboBox<String>(arrangementArr);
        if (Settings.propTableLayout.getString().equals("compact")) {
            this.mProgramArrangementCB.setSelectedIndex(2);
        } else if (Settings.propTableLayout.getString().equals("realCompact")) {
            this.mProgramArrangementCB.setSelectedIndex(3);
        } else if (Settings.propTableLayout.getString().equals("timeSynchronous")) {
            this.mProgramArrangementCB.setSelectedIndex(0);
        } else if (Settings.propTableLayout.getString().equals("timeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(4);
        } else if (Settings.propTableLayout.getString().equals("compactTimeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(5);
        } else if (Settings.propTableLayout.getString().equals("optimizedCompactTimeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(6);
        } else {
            this.mProgramArrangementCB.setSelectedIndex(1);
        }
        this.mLastSelectedLayoutIndex = (short)this.mProgramArrangementCB.getSelectedIndex();
        this.mSettingsPn.add((Component)this.mProgramArrangementCB, cc.xy(4, currentRow));
        this.mCutLongTitlesCB = new JCheckBox(mLocalizer.msg("cutTitle", "Cut long titles"), Settings.propProgramTableCutTitle.getBoolean());
        this.mSettingsPn.add((Component)this.mCutLongTitlesCB, cc.xyw(2, currentRow += 2, 2));
        this.mCutLongTitlesSelection = new JSpinner(new SpinnerNumberModel(Settings.propProgramTableCutTitleLines.getInt(), 1, 3, 1));
        this.mSettingsPn.add((Component)this.mCutLongTitlesSelection, cc.xy(4, currentRow));
        this.mCutLongTitlesLabel = new JLabel(mLocalizer.msg("lines", "Lines"));
        this.mSettingsPn.add((Component)this.mCutLongTitlesLabel, cc.xy(6, currentRow));
        this.mCutLongTitlesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramTableSettingsTab.this.mCutLongTitlesSelection.setEnabled(ProgramTableSettingsTab.this.mCutLongTitlesCB.isSelected());
                ProgramTableSettingsTab.this.mCutLongTitlesLabel.setEnabled(ProgramTableSettingsTab.this.mCutLongTitlesCB.isSelected());
            }
        });
        this.mCutLongTitlesCB.getActionListeners()[0].actionPerformed(null);
        this.mDescriptionLines = new JSpinner(new SpinnerNumberModel(Settings.propProgramPanelMaxLines.getInt(), 1, 5, 1));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("shortDescription", "Short description")), cc.xyw(2, currentRow += 2, 2));
        this.mSettingsPn.add((Component)this.mDescriptionLines, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("lines", "Lines")), cc.xy(6, currentRow));
        this.mShortProgramsCB = new JCheckBox(mLocalizer.msg("shortPrograms", "If duration less than"), Settings.propProgramPanelShortDurationActive.getBoolean());
        this.mSettingsPn.add((Component)this.mShortProgramsCB, cc.xyw(2, currentRow += 2, 2));
        this.mShortProgramsMinutes = new JSpinner(new SpinnerNumberModel(Settings.propProgramPanelShortDurationMinutes.getInt(), 1, 30, 1));
        this.mSettingsPn.add((Component)this.mShortProgramsMinutes, cc.xy(4, currentRow));
        this.mShortProgramsLabel = new JLabel(mLocalizer.msg("shortPrograms2", "minutes, then hide description"));
        this.mSettingsPn.add((Component)this.mShortProgramsLabel, cc.xy(6, currentRow));
        this.mShortProgramsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramTableSettingsTab.this.mShortProgramsMinutes.setEnabled(ProgramTableSettingsTab.this.mShortProgramsCB.isSelected());
                ProgramTableSettingsTab.this.mShortProgramsLabel.setEnabled(ProgramTableSettingsTab.this.mShortProgramsCB.isSelected());
            }
        });
        this.mShortProgramsCB.getActionListeners()[0].actionPerformed(null);
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("columnwidth", "column width")), cc.xyw(1, currentRow += 2, 8));
        int width = Settings.propColumnWidth.getInt();
        if (width > 600) {
            width = 600;
        }
        if (width < 120) {
            width = 120;
        }
        this.mColWidth = new JSpinner(new SpinnerNumberModel(width, 120, 600, 1));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("widthInPixels", "Width in Pixels")), cc.xy(2, currentRow += 2));
        this.mSettingsPn.add((Component)this.mColWidth, cc.xy(4, currentRow));
        this.mDefaultBtn = new JButton(Localizer.getLocalization("i18n_default"));
        this.mDefaultBtn.addActionListener(this);
        this.mSettingsPn.add((Component)this.mDefaultBtn, cc.xy(6, currentRow));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("range", "Range")), cc.xyw(1, currentRow += 2, 8));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("startOfDay", "Start of day")), cc.xy(2, currentRow += 2));
        TwoSpinnerDateModel startModel = new TwoSpinnerDateModel();
        this.mStartOfDayTimeSp = new JSpinner(startModel);
        startModel.setMe(this.mStartOfDayTimeSp);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.mStartOfDayTimeSp, Settings.getTimePattern());
        this.mStartOfDayTimeSp.setEditor(dateEditor);
        this.mSettingsPn.add((Component)this.mStartOfDayTimeSp, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)new JLabel("(" + Localizer.getLocalization("i18n_today") + ")"), cc.xy(6, currentRow));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("endOfDay", "End of day")), cc.xy(2, currentRow += 2));
        TwoSpinnerDateModel endModel = new TwoSpinnerDateModel();
        this.mEndOfDayTimeSp = new JSpinner(endModel);
        endModel.setMe(this.mEndOfDayTimeSp);
        dateEditor = new JSpinner.DateEditor(this.mEndOfDayTimeSp, Settings.getTimePattern());
        this.mEndOfDayTimeSp.setEditor(dateEditor);
        this.mSettingsPn.add((Component)this.mEndOfDayTimeSp, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)new JLabel("(" + mLocalizer.msg("nextDay", "next day") + ")"), cc.xy(6, currentRow));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        Calendar cal = Calendar.getInstance();
        int minutes = Settings.propProgramTableStartOfDay.getInt();
        cal.set(11, minutes / 60);
        cal.set(12, minutes % 60);
        this.mStartOfDayTimeSp.setValue(cal.getTime());
        minutes = Settings.propProgramTableEndOfDay.getInt();
        cal.set(11, minutes / 60);
        cal.set(12, minutes % 60);
        this.mEndOfDayTimeSp.setValue(cal.getTime());
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("tableBackground", "Table background")), cc.xyw(1, currentRow += 2, 8));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("tableBackgroundStyle", "Table background style")), cc.xy(2, currentRow += 2));
        TableBackgroundStyle[] styles = this.getTableBackgroundStyles();
        this.mBackgroundStyleCB = new JComboBox<TableBackgroundStyle>(styles);
        String style = Settings.propTableBackgroundStyle.getString();
        for (int i = 0; i < styles.length; ++i) {
            if (!styles[i].getSettingsString().equals(style)) continue;
            this.mBackgroundStyleCB.setSelectedIndex(i);
            break;
        }
        this.mBackgroundStyleCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProgramTableSettingsTab.this.updateBackgroundStyleConfigureButton();
            }
        });
        this.mSettingsPn.add((Component)this.mBackgroundStyleCB, cc.xy(4, currentRow));
        this.mConfigBackgroundStyleBt = new JButton(mLocalizer.ellipsisMsg("configure", "Configure"));
        this.mConfigBackgroundStyleBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureBackgroundStyleDialog dlg = new ConfigureBackgroundStyleDialog(ProgramTableSettingsTab.this.mBackgroundStyleCB, (TableBackgroundStyle)ProgramTableSettingsTab.this.mBackgroundStyleCB.getSelectedItem());
                dlg.show();
            }
        });
        this.mSettingsPn.add((Component)this.mConfigBackgroundStyleBt, cc.xy(6, currentRow));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        this.mForegroundColorLb = new ColorLabel(Settings.propProgramPanelForegroundColor.getColor());
        this.mForegroundColorLb.setStandardColor(Settings.propProgramPanelForegroundColor.getDefaultColor());
        this.mProgramPanelForegroundColorChangeBtn = new ColorButton(this.mForegroundColorLb);
        this.mForegroundSeparator = DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("foreground", "Foreground"));
        this.mForegroundLabel = new JLabel(mLocalizer.msg("fontColor", "Font color"));
        this.mSettingsPn.add((Component)this.mForegroundSeparator, cc.xyw(1, currentRow += 2, 8));
        this.mSettingsPn.add((Component)this.mForegroundLabel, cc.xy(2, currentRow += 2));
        this.mSettingsPn.add((Component)this.mForegroundColorLb, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)this.mProgramPanelForegroundColorChangeBtn, cc.xy(6, currentRow));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("10dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("mouse", "Mouse")), cc.xyw(1, currentRow += 2, 8));
        this.mMouseOverCb = new JCheckBox(mLocalizer.msg("MouseOver", "Mouse-Over-Effect"));
        this.mMouseOverCb.setSelected(Settings.propProgramTableMouseOver.getBoolean());
        this.mSettingsPn.add((Component)this.mMouseOverCb, cc.xy(2, currentRow += 2));
        this.mMouseOverColorLb = new ColorLabel(Settings.propProgramTableMouseOverColor.getColor());
        this.mMouseOverColorLb.setStandardColor(Settings.propProgramTableMouseOverColor.getDefaultColor());
        final ColorButton mouseOverColorChangeBtn = new ColorButton(this.mMouseOverColorLb);
        this.mMouseOverCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = ProgramTableSettingsTab.this.mMouseOverCb.isSelected();
                ProgramTableSettingsTab.this.mMouseOverColorLb.setEnabled(enabled);
                mouseOverColorChangeBtn.setEnabled(enabled);
            }
        });
        this.mMouseOverCb.getActionListeners()[0].actionPerformed(null);
        this.mTypeAsYouFind = new JCheckBox(mLocalizer.msg("typeAsYouFind", "Type-As-You-Find enabled"), Settings.propTypeAsYouFindEnabled.getBoolean());
        this.mSettingsPn.add((Component)this.mMouseOverColorLb, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)mouseOverColorChangeBtn, cc.xy(6, currentRow));
        this.mAutoScrollCb = new JCheckBox(mLocalizer.msg("mouseAutoScroll", "Throw'n scroll"));
        this.mAutoScrollCb.setSelected(Settings.propProgramTableMouseAutoScroll.getBoolean());
        this.mSettingsPn.add((Component)this.mAutoScrollCb, cc.xyw(2, currentRow += 2, 6));
        this.mAutoChangeDate = new JCheckBox(mLocalizer.msg("mouseAutoChangeDate", "Automatically change date when scrolling with mouse wheel against top and bottom"));
        this.mAutoChangeDate.setSelected(Settings.propProgramTableAutoChangeDate.getBoolean());
        this.mSettingsPn.add((Component)this.mAutoChangeDate, cc.xyw(2, currentRow += 2, 6));
        this.mShowScrollHighlight = new JCheckBox(mLocalizer.msg("activated", "Activated"), Settings.propScrollToTimeMarkingActivated.getBoolean());
        this.mLightColorLb = new ColorLabel(Settings.propScrollToTimeProgramsLightBackground.getColor());
        this.mLightColorLb.setStandardColor(Settings.propScrollToTimeProgramsLightBackground.getDefaultColor());
        this.mLightColorLb.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mDarkColorLb = new ColorLabel(Settings.propScrollToTimeProgramsDarkBackground.getColor());
        this.mDarkColorLb.setStandardColor(Settings.propScrollToTimeProgramsDarkBackground.getDefaultColor());
        this.mDarkColorLb.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mLight = new ColorButton(this.mLightColorLb);
        this.mLight.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mDark = new ColorButton(this.mDarkColorLb);
        this.mDark.setEnabled(this.mShowScrollHighlight.isSelected());
        final JLabel mLightDesc = new JLabel(TrayBaseSettingsTab.mLocalizer.msg("progressLight", "Background color"));
        final JLabel mDarkDesc = new JLabel(TrayBaseSettingsTab.mLocalizer.msg("progressDark", "Progress color"));
        this.mShowScrollHighlight.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProgramTableSettingsTab.this.mLightColorLb.setEnabled(e.getStateChange() == 1);
                ProgramTableSettingsTab.this.mDarkColorLb.setEnabled(ProgramTableSettingsTab.this.mLightColorLb.isEnabled());
                ProgramTableSettingsTab.this.mLight.setEnabled(ProgramTableSettingsTab.this.mLightColorLb.isEnabled());
                ProgramTableSettingsTab.this.mDark.setEnabled(ProgramTableSettingsTab.this.mLightColorLb.isEnabled());
                mLightDesc.setEnabled(ProgramTableSettingsTab.this.mLightColorLb.isEnabled());
                mDarkDesc.setEnabled(ProgramTableSettingsTab.this.mLightColorLb.isEnabled());
            }
        });
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("scrollToTimeTitle", "Highlight programs running at jump time")), cc.xyw(1, currentRow += 2, 8));
        this.mSettingsPn.add((Component)this.mShowScrollHighlight, cc.xyw(2, currentRow += 2, 2));
        this.mSettingsPn.add((Component)mLightDesc, cc.xy(2, currentRow += 2));
        this.mSettingsPn.add((Component)this.mLightColorLb, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)this.mLight, cc.xy(6, currentRow));
        this.mSettingsPn.add((Component)mDarkDesc, cc.xy(2, currentRow += 2));
        this.mSettingsPn.add((Component)this.mDarkColorLb, cc.xy(4, currentRow));
        this.mSettingsPn.add((Component)this.mDark, cc.xy(6, currentRow));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("misc", "Misc")), cc.xyw(1, currentRow += 2, 8));
        this.mSettingsPn.add((Component)this.mTypeAsYouFind, cc.xyw(2, currentRow += 2, 6));
        this.updateBackgroundStyleConfigureButton();
        return this.mSettingsPn;
    }

    private void updateBackgroundStyleConfigureButton() {
        TableBackgroundStyle style = (TableBackgroundStyle)this.mBackgroundStyleCB.getSelectedItem();
        this.mForegroundColorLb.setEnabled(!style.getSettingsString().equals("uiTimeBlock") && !style.getSettingsString().equals("uiColor"));
        this.mProgramPanelForegroundColorChangeBtn.setEnabled(this.mForegroundColorLb.isEnabled());
        this.mForegroundLabel.setEnabled(this.mForegroundColorLb.isEnabled());
        this.mForegroundSeparator.getComponent(0).setEnabled(this.mForegroundColorLb.isEnabled());
        this.mConfigBackgroundStyleBt.setEnabled(style.hasContent());
    }

    public static JButton createBrowseButton(final Component parent, final JTextField tf) {
        JButton bt = new JButton(mLocalizer.msg("change", "Change"));
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File selection;
                File file = new File(tf.getText());
                JFileChooser fileChooser = new JFileChooser(file.getParent());
                String[] extArr = new String[]{".jpg", ".jpeg", ".gif", ".png"};
                fileChooser.setFileFilter(new ExtensionFileFilter(extArr, ".jpg, .gif, png"));
                if (fileChooser.showOpenDialog(parent) == 0 && (selection = fileChooser.getSelectedFile()) != null) {
                    tf.setText(selection.getAbsolutePath());
                }
            }
        });
        Dimension size = bt.getPreferredSize();
        if (tf.getPreferredSize().height > size.height) {
            size.height = tf.getPreferredSize().height;
            bt.setPreferredSize(size);
        }
        return bt;
    }

    private void setBackgroundStyleForTimeBlockLayout() {
        if (!Settings.propTableLayout.getString().equals("timeBlock") && !Settings.propTableLayout.getString().equals("compactTimeBlock")) {
            Settings.propTableBackgroundStyle.setString("uiTimeBlock");
            Settings.propTimeBlockShowWest.setBoolean(true);
        }
    }

    private void resetBackgroundStyle() {
        if (Settings.propTableLayout.getString().equals("timeBlock") || Settings.propTableLayout.getString().equals("compactTimeBlock") || Settings.propTableLayout.getString().equals("optimizedCompactTimeBlock")) {
            Settings.propTableBackgroundStyle.setString("uiColor");
            Settings.propTimeBlockShowWest.setBoolean(false);
        }
    }

    @Override
    public void saveSettings() {
        String backgroundStyle = ((TableBackgroundStyle)this.mBackgroundStyleCB.getSelectedItem()).getSettingsString();
        Settings.propTableBackgroundStyle.setString(backgroundStyle);
        if (this.mProgramArrangementCB.getSelectedIndex() == 2 && this.mLastSelectedLayoutIndex != 2) {
            this.resetBackgroundStyle();
            Settings.propTableLayout.setString("compact");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 3 && this.mLastSelectedLayoutIndex != 3) {
            this.resetBackgroundStyle();
            Settings.propTableLayout.setString("realCompact");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 0 && this.mLastSelectedLayoutIndex != 0) {
            this.resetBackgroundStyle();
            Settings.propTableLayout.setString("timeSynchronous");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 4 && this.mLastSelectedLayoutIndex != 4) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.propTableLayout.setString("timeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 5 && this.mLastSelectedLayoutIndex != 5) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.propTableLayout.setString("compactTimeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 6 && this.mLastSelectedLayoutIndex != 6) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.propTableLayout.setString("optimizedCompactTimeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 1 && this.mLastSelectedLayoutIndex != 1) {
            this.resetBackgroundStyle();
            Settings.propTableLayout.setString("realSynchronous");
        }
        Settings.propColumnWidth.setInt((Integer)this.mColWidth.getValue());
        Settings.propProgramPanelForegroundColor.setColor(this.mForegroundColorLb.getColor());
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.mStartOfDayTimeSp.getValue());
        int minutes = cal.get(11) * 60 + cal.get(12);
        Settings.propProgramTableStartOfDay.setInt(minutes);
        cal.setTime((Date)this.mEndOfDayTimeSp.getValue());
        minutes = cal.get(11) * 60 + cal.get(12);
        Settings.propProgramTableEndOfDay.setInt(minutes);
        Settings.propProgramTableMouseOver.setBoolean(this.mMouseOverCb.isSelected());
        Settings.propProgramTableAutoChangeDate.setBoolean(this.mAutoChangeDate.isSelected());
        Settings.propProgramTableMouseOverColor.setColor(this.mMouseOverColorLb.getColor());
        Settings.propProgramTableCutTitle.setBoolean(this.mCutLongTitlesCB.isSelected());
        Settings.propProgramTableCutTitleLines.setInt((Integer)this.mCutLongTitlesSelection.getValue());
        Settings.propProgramTableMouseAutoScroll.setBoolean(this.mAutoScrollCb.isSelected());
        Settings.propProgramPanelMaxLines.setInt((Integer)this.mDescriptionLines.getValue());
        Settings.propProgramPanelShortDurationActive.setBoolean(this.mShortProgramsCB.isSelected());
        Settings.propProgramPanelShortDurationMinutes.setInt((Integer)this.mShortProgramsMinutes.getValue());
        Settings.propScrollToTimeMarkingActivated.setBoolean(this.mShowScrollHighlight.isSelected());
        Settings.propScrollToTimeProgramsLightBackground.setColor(this.mLightColorLb.getColor());
        Settings.propScrollToTimeProgramsDarkBackground.setColor(this.mDarkColorLb.getColor());
        Settings.propTypeAsYouFindEnabled.setBoolean(this.mTypeAsYouFind.isSelected());
        MainFrame.getInstance().getProgramTableScrollPane().getProgramTable().clearTimeMarkings();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Program table");
    }

    private TableBackgroundStyle[] getTableBackgroundStyles() {
        return new TableBackgroundStyle[]{new SingleColorBackgroundStyle(), new UiColorBackgroundStyle(), new SingleImageBackgroundStyle(), new TimeBlockBackgroundStyle(), new UiTimeBlockBackgroundStyle(), new DayTimeBackgroundStyle()};
    }

    private class TwoSpinnerDateModel
    extends SpinnerDateModel {
        private JSpinner mMeSpinner;

        private TwoSpinnerDateModel() {
        }

        protected void setMe(JSpinner me) {
            this.mMeSpinner = me;
        }

        @Override
        public void setValue(Object value) {
            this.correctValues((Date)value);
            super.setValue(value);
        }

        @Override
        public Object getPreviousValue() {
            Date d = (Date)super.getPreviousValue();
            this.correctValues(d);
            return d;
        }

        @Override
        public Object getNextValue() {
            Date d = (Date)super.getNextValue();
            this.correctValues(d);
            return d;
        }

        private void correctValues(Date d) {
            if (this.mMeSpinner != null && ProgramTableSettingsTab.this.mStartOfDayTimeSp != null && ProgramTableSettingsTab.this.mEndOfDayTimeSp != null) {
                Calendar cal = Calendar.getInstance();
                if (this.mMeSpinner.equals(ProgramTableSettingsTab.this.mStartOfDayTimeSp)) {
                    cal.setTime((Date)ProgramTableSettingsTab.this.mEndOfDayTimeSp.getValue());
                    int endTime = cal.get(11) * 60 + cal.get(12);
                    cal.setTime(d);
                    int startTime = cal.get(11) * 60 + cal.get(12);
                    if (endTime - startTime < -1) {
                        ProgramTableSettingsTab.this.mEndOfDayTimeSp.setValue(d);
                    }
                } else {
                    cal.setTime(d);
                    int endTime = cal.get(11) * 60 + cal.get(12);
                    cal.setTime((Date)ProgramTableSettingsTab.this.mStartOfDayTimeSp.getValue());
                    int startTime = cal.get(11) * 60 + cal.get(12);
                    if (endTime - startTime < -1) {
                        ProgramTableSettingsTab.this.mStartOfDayTimeSp.setValue(d);
                    }
                }
            }
        }
    }

    private static class ConfigureBackgroundStyleDialog {
        private JDialog mDialog;
        private TableBackgroundStyle mStyle;

        public ConfigureBackgroundStyleDialog(Component parent, TableBackgroundStyle style) {
            this.mStyle = style;
            this.mDialog = UiUtilities.createDialog(parent, true);
            this.mDialog.setTitle(mLocalizer.msg("configureBackgroundStyleDialogTitle", "Configure background style '{0}'", style.getName()));
            JPanel dialogContent = (JPanel)this.mDialog.getContentPane();
            dialogContent.setBorder(new EmptyBorder(10, 10, 11, 11));
            dialogContent.setLayout(new BorderLayout(0, 15));
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)style.createSettingsContent(), "North");
            dialogContent.add((Component)content, "Center");
            JPanel buttonPn = new JPanel(new BorderLayout());
            JPanel pn = new JPanel();
            pn.setLayout(new FlowLayout(2, 5, 0));
            JButton okBtn = new JButton(Localizer.getLocalization("i18n_ok"));
            JButton cancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
            pn.add(okBtn);
            pn.add(cancelBtn);
            okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureBackgroundStyleDialog.this.mStyle.storeSettings();
                    ConfigureBackgroundStyleDialog.this.mDialog.setVisible(false);
                }
            });
            cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureBackgroundStyleDialog.this.mDialog.setVisible(false);
                }
            });
            buttonPn.add((Component)pn, "East");
            dialogContent.add((Component)buttonPn, "South");
            this.mDialog.pack();
        }

        public void show() {
            UiUtilities.centerAndShow(this.mDialog);
        }
    }
}

