/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import util.ui.Localizer;
import util.ui.MarkPriorityComboBoxRenderer;
import util.ui.UiUtilities;

public class TrayImportantSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = TrayBaseSettingsTab.mLocalizer;
    private static final int mMaxSizeTray = 30;
    private static final int mMaxSizeSubmenu = 40;
    private JCheckBox mIsEnabled;
    private JCheckBox mShowDate;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JRadioButton mShowInSubMenu;
    private JRadioButton mShowInTray;
    private JSpinner mSize;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private JLabel mSizeLabel;
    private JLabel mSizeInfo;
    private JEditorPane mHelpLabel;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private JComboBox mPriority;
    private JLabel mPriorityText;
    private static boolean mTrayIsEnabled = Settings.propTrayIsEnabled.getBoolean();
    private static TrayImportantSettingsTab mInstance;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu,12dlu,pref,5dlu,pref,5dlu,pref:grow,5dlu", "pref,5dlu,pref,pref,pref,pref,pref,10dlu,pref,5dlu,pref,pref,pref,5dlu,pref,10dlu,pref,5dlu,pref,pref,pref,fill:pref:grow,pref"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(mLocalizer.msg("importantEnabled", "Show important programs"), Settings.propTrayImportantProgramsEnabled.getBoolean());
        this.mIsEnabled.setToolTipText(mLocalizer.msg("importantToolTip", "Important programs are all marked programs."));
        ButtonGroup bg = new ButtonGroup();
        this.mShowInSubMenu = new JRadioButton(mLocalizer.msg("inSubMenu", "in a sub menu"), Settings.propTrayImportantProgramsInSubMenu.getBoolean());
        this.mShowInTray = new JRadioButton(mLocalizer.msg("inTray", "in the tray menu"), !this.mShowInSubMenu.isSelected());
        bg.add(this.mShowInSubMenu);
        bg.add(this.mShowInTray);
        int maxSizeValue = Settings.propTrayImportantProgramsInSubMenu.getBoolean() ? 40 : 30;
        this.mSize = new JSpinner(new SpinnerNumberModel(Settings.propTrayImportantProgramsSize.getInt(), 1, maxSizeValue, 1));
        this.mShowIconAndName = new JRadioButton(mLocalizer.msg("showIconName", "Show channel icon and channel name"), Settings.propTrayImportantProgramsContainsName.getBoolean() && Settings.propTrayImportantProgramsContainsIcon.getBoolean());
        this.mShowName = new JRadioButton(mLocalizer.msg("showName", "Show channel name"), Settings.propTrayImportantProgramsContainsName.getBoolean() && !Settings.propTrayImportantProgramsContainsIcon.getBoolean());
        this.mShowIcon = new JRadioButton(mLocalizer.msg("showIcon", "Show channel icon"), !Settings.propTrayImportantProgramsContainsName.getBoolean() && Settings.propTrayImportantProgramsContainsIcon.getBoolean());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mShowIconAndName);
        bg1.add(this.mShowIcon);
        bg1.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(mLocalizer.msg("showChannelNumber", "Show sort number"), Settings.propTrayImportantProgramsShowingSortNumber.getBoolean());
        this.mShowDate = new JCheckBox(mLocalizer.msg("showDate", "Show date"), Settings.propTrayImportantProgramsContainsDate.getBoolean());
        this.mShowTime = new JCheckBox(mLocalizer.msg("showTime", "Show start time"), Settings.propTrayImportantProgramsContainsTime.getBoolean());
        this.mShowToolTip = new JCheckBox(mLocalizer.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.propTrayImportantProgramsContainsToolTip.getBoolean());
        this.mShowToolTip.setToolTipText(mLocalizer.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#tray");
                }
            }
        });
        JPanel priority = new JPanel(new FormLayout("pref,5dlu,pref", "1dlu,pref"));
        Localizer localizer = MarkingsSettingsTab.mLocalizer;
        String[] colors = new String[]{localizer.msg("color.minPriority", "1. Color (minimum priority)"), localizer.msg("color.lowerMediumPriority", "2. Color (lower medium priority)"), localizer.msg("color.mediumPriority", "3. Color (Medium priority)"), localizer.msg("color.higherMediumPriority", "4. Color (higher medium priority)"), localizer.msg("color.maxPriority", "5. Color (maximum priority)")};
        this.mPriorityText = new JLabel(mLocalizer.msg("importantMarkPriority", "Mark priority higher or the same like:"));
        this.mPriority = new JComboBox<String>(colors);
        this.mPriority.setSelectedIndex(Settings.propTrayImportantProgramsPriority.getInt());
        this.mPriority.setRenderer(new MarkPriorityComboBoxRenderer(this.mPriority.getRenderer()));
        priority.add((Component)this.mPriorityText, CC.xy(1, 2));
        priority.add((Component)this.mPriority, CC.xy(3, 2));
        JPanel c = (JPanel)builder.addSeparator(mLocalizer.msg("important", "Important programs"), CC.xyw(1, 1, 8));
        builder.add((Component)this.mIsEnabled, CC.xyw(2, 3, 6));
        builder.add((Component)this.mShowInTray, CC.xyw(3, 4, 5));
        builder.add((Component)this.mShowInSubMenu, CC.xyw(3, 5, 5));
        this.mSizeLabel = builder.addLabel(mLocalizer.msg("importantSize", "Number of shown programs:"), CC.xy(3, 6));
        builder.add((Component)this.mSize, CC.xy(5, 6));
        this.mSizeInfo = builder.addLabel(mLocalizer.msg("sizeInfo", "(maximum: {0})", maxSizeValue), CC.xy(7, 6));
        builder.add((Component)priority, CC.xyw(3, 7, 5));
        JPanel c1 = (JPanel)builder.addSeparator(mLocalizer.msg("iconNameSeparator", "Channel icons/channel name"), CC.xyw(1, 9, 8));
        builder.add((Component)this.mShowIconAndName, CC.xyw(2, 11, 6));
        builder.add((Component)this.mShowIcon, CC.xyw(2, 12, 6));
        builder.add((Component)this.mShowName, CC.xyw(2, 13, 6));
        builder.add((Component)this.mShowSortNumber, CC.xyw(2, 15, 6));
        JPanel c2 = (JPanel)builder.addSeparator(mLocalizer.msg("settings", "Settings"), CC.xyw(1, 17, 8));
        builder.add((Component)this.mShowDate, CC.xyw(2, 19, 6));
        builder.add((Component)this.mShowTime, CC.xyw(2, 20, 6));
        builder.add((Component)this.mShowToolTip, CC.xyw(2, 21, 6));
        builder.add((Component)this.mHelpLabel, CC.xyw(1, 23, 8));
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mShowInSubMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayImportantSettingsTab.this.mSize.setModel(new SpinnerNumberModel((Integer)TrayImportantSettingsTab.this.mSize.getValue(), 1, 40, 1));
                TrayImportantSettingsTab.this.mSizeInfo.setText(mLocalizer.msg("sizeInfo", "(maximum: {0})", 40));
            }
        });
        this.mShowInTray.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = (Integer)TrayImportantSettingsTab.this.mSize.getValue();
                TrayImportantSettingsTab.this.mSize.setModel(new SpinnerNumberModel(value > 30 ? 30 : value, 1, 30, 1));
                TrayImportantSettingsTab.this.mSizeInfo.setText(mLocalizer.msg("sizeInfo", "(maximum: {0})", 30));
            }
        });
        this.mIsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayImportantSettingsTab.this.setEnabled(false);
            }
        });
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInSubMenu.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInTray.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowDate.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSizeLabel.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSize.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSizeInfo.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mPriority.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mPriorityText.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.propTrayImportantProgramsEnabled.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowInSubMenu != null) {
            Settings.propTrayImportantProgramsInSubMenu.setBoolean(this.mShowInSubMenu.isSelected());
        }
        if (this.mSize != null) {
            Settings.propTrayImportantProgramsSize.setInt((Integer)this.mSize.getValue());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.propTrayImportantProgramsContainsName.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.propTrayImportantProgramsContainsIcon.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowDate != null) {
            Settings.propTrayImportantProgramsContainsDate.setBoolean(this.mShowDate.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.propTrayImportantProgramsContainsTime.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.propTrayImportantProgramsContainsToolTip.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mPriority != null) {
            Settings.propTrayImportantProgramsPriority.setInt(this.mPriority.getSelectedIndex());
        }
        if (this.mShowSortNumber != null) {
            Settings.propTrayImportantProgramsShowingSortNumber.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("important", "Important programs");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

