/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import util.browserlauncher.Launch;
import util.io.IOUtilities;
import util.misc.OperatingSystem;
import util.ui.LinkButton;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class WebbrowserSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(WebbrowserSettingsTab.class);
    private JPanel mSettingsPn;
    private JFileChooser mFileChooser;
    private JTextField mFileTextField;
    private JTextField mParams;
    private JRadioButton mUseWebbrowser;
    private JButton mChooseButton;

    @Override
    public JPanel createSettingsPanel() {
        this.mSettingsPn = new JPanel(new FormLayout("5dlu, 10dlu, pref, 3dlu, pref, 3dlu, pref, fill:3dlu:grow, 3dlu", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref"));
        this.mSettingsPn.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("browser", "Web browser")), cc.xyw(1, 1, 9));
        LinkButton testButton = new LinkButton(mLocalizer.msg("testBrowser", "Test Webbrowser"), "http://www.tvbrowser.org", 2, false);
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String buffer = IOUtilities.translateRelativePath(Settings.propUserDefinedWebbrowser.getString());
                String bufferParams = Settings.propUserDefinedWebbrowserParams.getString();
                WebbrowserSettingsTab.this.saveSettings();
                Launch.openURL("http://www.tvbrowser.org");
                Settings.propUserDefinedWebbrowser.setString(IOUtilities.checkForRelativePath(buffer));
                Settings.propUserDefinedWebbrowserParams.setString(bufferParams);
            }
        });
        this.mSettingsPn.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("help", "Help Text")), cc.xyw(2, 3, 7));
        this.mSettingsPn.add((Component)testButton, cc.xyw(2, 5, 7));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("whichBrowser", "which browser")), cc.xyw(2, 7, 7));
        JRadioButton useDefault = new JRadioButton(mLocalizer.msg("defaultWebbrowser", "Default Webbrowser"));
        useDefault.setSelected(Settings.propUserDefinedWebbrowser.getString() == null);
        useDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebbrowserSettingsTab.this.updateInputFields();
            }
        });
        this.mSettingsPn.add((Component)useDefault, cc.xyw(2, 9, 4));
        this.mUseWebbrowser = new JRadioButton(mLocalizer.msg("userDefinedWebbrowser", "user defined webbrowser"));
        this.mUseWebbrowser.setSelected(Settings.propUserDefinedWebbrowser.getString() != null);
        this.mUseWebbrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebbrowserSettingsTab.this.updateInputFields();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(useDefault);
        group.add(this.mUseWebbrowser);
        this.mSettingsPn.add((Component)this.mUseWebbrowser, cc.xyw(2, 11, 7));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("browserExecutable", "Executable") + ":"), cc.xy(3, 13));
        this.mFileTextField = new JTextField(30);
        this.mFileTextField.setText(Settings.propUserDefinedWebbrowser.getString());
        this.mSettingsPn.add((Component)this.mFileTextField, cc.xy(5, 13));
        this.mChooseButton = new JButton(Localizer.getLocalization("i18n_select"));
        this.mChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File f;
                int retVal;
                if (WebbrowserSettingsTab.this.mFileChooser == null) {
                    WebbrowserSettingsTab.this.mFileChooser = new JFileChooser();
                    if (OperatingSystem.isMacOs()) {
                        WebbrowserSettingsTab.this.mFileChooser.setFileSelectionMode(2);
                    } else {
                        WebbrowserSettingsTab.this.mFileChooser.setFileSelectionMode(0);
                    }
                }
                if ((retVal = WebbrowserSettingsTab.this.mFileChooser.showOpenDialog(WebbrowserSettingsTab.this.mSettingsPn.getParent())) == 0 && (f = WebbrowserSettingsTab.this.mFileChooser.getSelectedFile()) != null) {
                    WebbrowserSettingsTab.this.mFileTextField.setText(f.getAbsolutePath());
                }
            }
        });
        this.mSettingsPn.add((Component)this.mChooseButton, cc.xy(7, 13));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("browserParameter", "Parameter") + ":"), cc.xy(3, 15));
        this.mParams = new JTextField();
        this.mParams.setText(Settings.propUserDefinedWebbrowserParams.getString());
        this.mSettingsPn.add((Component)this.mParams, cc.xy(5, 15));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("browserParameterHelp", "{0} will be replaced by the url.")), cc.xyw(5, 17, 4));
        this.updateInputFields();
        return this.mSettingsPn;
    }

    private void updateInputFields() {
        this.mFileTextField.setEnabled(this.mUseWebbrowser.isSelected());
        this.mChooseButton.setEnabled(this.mUseWebbrowser.isSelected());
    }

    @Override
    public void saveSettings() {
        String webbrowser;
        if (this.mUseWebbrowser.isSelected()) {
            webbrowser = this.mFileTextField.getText();
            String params = this.mParams.getText().trim();
            if (StringUtils.isEmpty(params)) {
                params = "{0}";
            }
            Settings.propUserDefinedWebbrowserParams.setString(params);
        } else {
            webbrowser = null;
        }
        Settings.propUserDefinedWebbrowser.setString(IOUtilities.checkForRelativePath(webbrowser));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "internet-web-browser", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("browser", "Web browser");
    }
}

