/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import devplugin.Channel;
import devplugin.ChannelGroup;
import java.util.ArrayList;
import util.ui.Localizer;

public class ChannelUtil {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelUtil.class);

    public static String getNameForCategories(int category) {
        if ((category & 4) > 0) {
            return mLocalizer.msg("categoryCinema", "Kino");
        }
        if ((category & 8) > 0) {
            return mLocalizer.msg("categoryEvents", "Events");
        }
        if ((category & 2) > 0) {
            return mLocalizer.msg("categoryRadio", "Radio");
        }
        if ((category & 1) > 0) {
            ArrayList<String> categories = new ArrayList<String>();
            if ((category & 0x10) > 0) {
                categories.add(mLocalizer.msg("categoryDigital", "Digitale"));
            }
            if ((category & 0x200) > 0) {
                categories.add(mLocalizer.msg("categoryPayTv", "Pay-TV"));
            }
            if ((category & 0x20) > 0) {
                categories.add(mLocalizer.msg("categoryMusic", "Musik"));
            } else if ((category & 0x80) > 0) {
                categories.add(mLocalizer.msg("categoryNews", "Nachrichten"));
            } else if ((category & 0x40) > 0) {
                categories.add(mLocalizer.msg("categorySport", "Sport"));
            } else if ((category & 0x100) > 0) {
                categories.add(mLocalizer.msg("categoryOthers", "Sonstige Sparten"));
            }
            StringBuilder buf = new StringBuilder(mLocalizer.msg("categoryTV", "TV"));
            if (categories.size() > 0) {
                buf.append(" (");
                for (int i = 0; i < categories.size(); ++i) {
                    buf.append((String)categories.get(i));
                    if (i >= categories.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append(')');
            }
            return buf.toString();
        }
        return mLocalizer.msg("categoryNone", "Not categorized");
    }

    public static String getProviderName(Channel ch) {
        ChannelGroup group = ch.getGroup();
        if (group == null) {
            return ch.getDataServiceProxy().getInfo().getName();
        }
        return group.getProviderName();
    }
}

