/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.looksSettings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import util.misc.OperatingSystem;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SkinLNFSettings
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SkinLNFSettings.class);
    private JComboBox mThemePack;

    public SkinLNFSettings(JDialog parent) {
        super((Dialog)parent, true);
        this.setTitle(mLocalizer.msg("title", "Skin Look and Feel Settings"));
        this.createGui();
    }

    private void createGui() {
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new FormLayout("5dlu, fill:50dlu:grow, 3dlu", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, fill:3dlu:grow, pref"));
        content.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        content.add((Component)DefaultComponentFactory.getInstance().createSeparator(Localizer.getLocalization("i18n_help")), cc.xyw(1, 1, 3));
        content.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("skinLFInfo", "Skin Info", "http://tvbrowser.org/themepacks.php")), cc.xyw(2, 3, 2));
        String temp = Settings.propSkinLFThemepack.getString();
        temp = StringUtils.substringAfterLast(temp, File.separator);
        String[] skins = this.getThemePacks();
        this.mThemePack = new JComboBox<String>(skins);
        this.mThemePack.setSelectedItem(temp);
        content.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("chooseThemepack", "Choose Themepack")), cc.xyw(1, 5, 3));
        content.add((Component)this.mThemePack, cc.xy(2, 7));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SkinLNFSettings.this.okPressed();
            }
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SkinLNFSettings.this.cancelPressed();
            }
        });
        ButtonBarBuilder bar = new ButtonBarBuilder();
        bar.addButton(ok, cancel);
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.add(bar.getPanel());
        content.add((Component)panel, cc.xyw(1, 9, 3));
        UiUtilities.registerForClosing(this);
        this.setPreferredSize(new Dimension(Sizes.dialogUnitXAsPixel(270, this), Sizes.dialogUnitYAsPixel(180, this)));
        this.pack();
    }

    private String[] getThemePacks() {
        TreeSet<String> themepacks = new TreeSet<String>();
        themepacks.addAll(Arrays.asList(this.getThemePacks(new File("themepacks"))));
        themepacks.addAll(Arrays.asList(this.getThemePacks(new File(Settings.getUserDirectoryName(), "themepacks"))));
        if (OperatingSystem.isMacOs()) {
            themepacks.addAll(Arrays.asList(this.getThemePacks(new File(Settings.getOSLibraryDirectoryName() + "themepacks"))));
        }
        return themepacks.toArray(new String[themepacks.size()]);
    }

    private String[] getThemePacks(File directory) {
        if (directory == null || !directory.exists()) {
            return new String[0];
        }
        return directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.toLowerCase().endsWith(".zip");
            }
        });
    }

    protected void cancelPressed() {
        this.setVisible(false);
    }

    protected void okPressed() {
        Settings.propSkinLFThemepack.setString("themepacks/" + this.mThemePack.getSelectedItem());
        this.setVisible(false);
    }

    @Override
    public void close() {
        this.cancelPressed();
    }
}

