/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.tray;

import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.contextmenu.DoNothingContextMenuItem;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.tray.ProgramMenuItemUI;
import tvbrowser.ui.tray.SystemTray;
import util.program.CompoundedProgramFieldType;
import util.programmouseevent.ProgramMouseEventHandler;
import util.ui.Localizer;
import util.ui.TextAreaIcon;
import util.ui.UiUtilities;

public class ProgramMenuItem
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramMenuItem.class);
    private Dimension mPreferredSize = null;
    private Program mProgram;
    private Color mBackground;
    private Color mFill = null;
    private Insets mInsets;
    private Timer mTimer;
    private static Font mPlainFont = new JMenuItem().getFont();
    private static Font mBoldFont = mPlainFont.deriveFont(1);
    private int mIconHeight = 0;
    private boolean mShowStartTime;
    private boolean mShowDate;
    private boolean mShowName;
    private boolean mShowSortNumber;
    private Icon mIcon = null;
    private TextAreaIcon mChannelName;
    protected static final int TIME_WIDTH = new JMenuItem().getFontMetrics(mBoldFont).stringWidth(Plugin.getPluginManager().getExampleProgram().getTimeString()) + 10;
    protected static final int DATE_WIDTH = new JMenuItem().getFontMetrics(mBoldFont).stringWidth(Plugin.getPluginManager().getExampleProgram().getDateString()) + (Date.getCurrentDate().getDayOfMonth() < 10 ? 15 : 9);
    protected static final int NOW_TYPE = 0;
    protected static final int SOON_TYPE = 1;
    protected static final int ON_TIME_TYPE = 2;
    protected static final int IMPORTANT_TYPE = 3;
    protected static final int AFTER_TYPE = 4;
    private boolean mShowToolTip = true;
    private String mToolTipTextBuffer;

    public ProgramMenuItem(Program p, int type, int time, int n) {
        super(p.getTitle());
        this.mProgram = p;
        this.mBackground = this.getBackground();
        boolean showIcon = true;
        if (type == 0) {
            this.mShowStartTime = Settings.propTrayNowProgramsContainsTime.getBoolean();
            this.mShowDate = false;
            this.mShowName = Settings.propTrayNowProgramsContainsName.getBoolean();
            showIcon = Settings.propTrayNowProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTrayNowProgramsContainsToolTip.getBoolean();
            this.mShowSortNumber = Settings.propTrayNowProgramsShowingSortNumber.getBoolean();
        } else if (type == 1) {
            this.mShowStartTime = Settings.propTraySoonProgramsContainsTime.getBoolean();
            this.mShowDate = false;
            this.mShowName = Settings.propTraySoonProgramsContainsName.getBoolean();
            showIcon = Settings.propTraySoonProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTraySoonProgramsContainsToolTip.getBoolean();
            this.mShowSortNumber = Settings.propTraySoonProgramsShowingSortNumber.getBoolean();
        } else if (type == 2) {
            this.mShowStartTime = Settings.propTrayOnTimeProgramsContainsTime.getBoolean();
            this.mShowDate = false;
            this.mShowName = Settings.propTrayOnTimeProgramsContainsName.getBoolean();
            showIcon = Settings.propTrayOnTimeProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTrayOnTimeProgramsContainsToolTip.getBoolean();
            this.mShowSortNumber = Settings.propTrayOnTimeProgramsShowingSortNumber.getBoolean();
            if (!Settings.propTrayOnTimeProgramsShowProgress.getBoolean()) {
                time = -1;
            }
        } else if (type == 3) {
            this.mShowStartTime = Settings.propTrayImportantProgramsContainsTime.getBoolean();
            this.mShowDate = Settings.propTrayImportantProgramsContainsDate.getBoolean();
            this.mShowName = Settings.propTrayImportantProgramsContainsName.getBoolean();
            showIcon = Settings.propTrayImportantProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTrayImportantProgramsContainsToolTip.getBoolean();
            this.mShowSortNumber = Settings.propTrayImportantProgramsShowingSortNumber.getBoolean();
        } else if (type == 1) {
            this.mShowStartTime = true;
            this.mShowDate = false;
            this.mShowName = Settings.propTraySoonProgramsContainsName.getBoolean();
            showIcon = Settings.propTraySoonProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTraySoonProgramsContainsToolTip.getBoolean();
            this.mShowSortNumber = Settings.propTraySoonProgramsShowingSortNumber.getBoolean();
        } else if (type == 4) {
            this.mShowStartTime = true;
            this.mShowDate = false;
            this.mShowName = Settings.propTrayImportantProgramsContainsName.getBoolean();
            showIcon = Settings.propTrayImportantProgramsContainsIcon.getBoolean();
            this.mShowToolTip = Settings.propTrayImportantProgramsContainsToolTip.getBoolean();
            time = -1;
            this.mShowSortNumber = Settings.propTrayImportantProgramsShowingSortNumber.getBoolean();
        } else {
            this.mShowStartTime = true;
            this.mShowDate = false;
            this.mShowName = true;
            this.mShowSortNumber = true;
        }
        String sortNumber = "";
        if (this.mShowSortNumber && p.getChannel().getSortNumber().trim().length() > 0) {
            sortNumber = p.getChannel().getSortNumber() + ". ";
        }
        this.mChannelName = new TextAreaIcon(sortNumber + (this.mShowName ? p.getChannel().getName() : ""), mBoldFont, Settings.propTrayChannelWidth.getInt());
        this.mChannelName.setMaximumLineCount(2);
        if (this.mShowToolTip) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }
        if ((n & 1) == 1 && n != -1) {
            Color temp = this.mBackground.darker();
            this.mFill = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 145);
            this.setBackground(this.mFill);
        }
        if (showIcon) {
            this.mIcon = UiUtilities.createChannelIcon(p.getChannel().getIcon());
            this.mIconHeight = this.mIcon.getIconHeight();
            this.setMargin(new Insets(1, this.getMargin().left, 1, this.getMargin().right));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point = e.getPoint();
                    SwingUtilities.convertPointToScreen(point, e.getComponent());
                    ProgramMenuItem.this.showPopup(point, PluginProxyManager.createPluginContextMenu(ProgramMenuItem.this.mProgram));
                    e.consume();
                } else {
                    ContextMenuIf menu = ContextMenuManager.getInstance().getContextMenuForSingleClick(e);
                    if (menu == null || menu.equals(DoNothingContextMenuItem.getInstance())) {
                        menu = ContextMenuManager.getInstance().getContextMenuForDoubleClick(e);
                    }
                    if (menu != null) {
                        ProgramMouseEventHandler.handleAction(ProgramMenuItem.this.mProgram, menu.getContextMenuActions(ProgramMenuItem.this.mProgram));
                    }
                }
            }
        });
        this.mInsets = this.getMargin();
        this.setUI(new ProgramMenuItemUI(p, this.mChannelName, this.mIcon, this.mShowStartTime, this.mShowDate, showIcon, this.mShowName || sortNumber.trim().length() > 0, time));
        this.mTimer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramMenuItem.this.repaint();
            }
        });
        this.startTimer();
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.mPreferredSize = dim;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPreferredSize != null) {
            return this.mPreferredSize;
        }
        FontMetrics fmBold = this.getFontMetrics(mBoldFont);
        FontMetrics fmPlain = this.getFontMetrics(mPlainFont);
        int height = this.mIconHeight;
        int width = fmPlain.stringWidth(this.mProgram.getTitle().length() > 70 ? this.mProgram.getTitle().substring(0, 67) + "..." : this.mProgram.getTitle()) + this.mInsets.left + this.mInsets.right + 10;
        width = height != 0 ? (width += this.mIcon.getIconWidth() + this.getIconTextGap()) : (width += 30);
        if (this.mShowName || this.mShowSortNumber) {
            width += Settings.propTrayChannelWidth.getInt() + this.getIconTextGap();
        }
        if (this.mShowStartTime) {
            width += TIME_WIDTH;
        }
        if (this.mShowDate) {
            width += DATE_WIDTH;
        }
        if (height == 0) {
            height = this.mShowStartTime || this.mShowDate ? fmBold.getHeight() : fmPlain.getHeight();
            height += this.mInsets.top + this.mInsets.bottom;
        } else {
            height += 2;
        }
        if (this.mChannelName.getIconHeight() > height && (this.mShowName || this.mShowSortNumber)) {
            height = this.mChannelName.getIconHeight() + this.mInsets.top + this.mInsets.bottom + 2;
        }
        return new Dimension(width, height);
    }

    public void setBackground(int n) {
        if (n == -1) {
            this.setBackground(this.mBackground);
        } else if ((n & 1) == 1) {
            Color temp = this.mBackground.darker();
            this.mFill = new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), 145);
            this.setBackground(this.mFill);
        }
    }

    private void startTimer() {
        if (!this.mTimer.isRunning()) {
            this.mTimer.start();
        }
    }

    protected void stopTimer() {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
        }
        this.setForeground(Color.gray);
    }

    protected Color getDefaultBackground() {
        return this.mBackground;
    }

    @Override
    public String getToolTipText() {
        if (this.mShowToolTip) {
            if (this.mToolTipTextBuffer == null) {
                StringBuilder info;
                String episodeText = CompoundedProgramFieldType.EPISODE_COMPOSITION.getFormattedValueForProgram(this.mProgram);
                StringBuilder episode = new StringBuilder(episodeText != null ? episodeText : "");
                this.breakLines(episode);
                if (this.mProgram.getShortInfo() == null) {
                    String desc = this.mProgram.getDescription();
                    if (desc != null) {
                        if (desc.length() > 197) {
                            desc = desc.substring(0, 197) + "...";
                        }
                        info = new StringBuilder(desc);
                    } else {
                        info = new StringBuilder();
                    }
                } else {
                    info = new StringBuilder(this.mProgram.getShortInfo());
                }
                this.breakLines(info);
                StringBuilder toolTip = new StringBuilder("<html>");
                if (episode.length() > 0) {
                    toolTip.append((CharSequence)episode.insert(0, "<b>").append("</b><br>"));
                }
                toolTip.append(mLocalizer.msg("to", "To ")).append(this.mProgram.getEndTimeString());
                if (info.length() > 0) {
                    toolTip.append("<br>").append((CharSequence)info);
                }
                toolTip.append("</html>");
                this.mToolTipTextBuffer = toolTip.toString();
            }
            return this.mToolTipTextBuffer;
        }
        return "";
    }

    private void breakLines(StringBuilder info) {
        for (int i = 38; i < info.length(); i += 38) {
            int index = info.indexOf(" ", i);
            if (index == -1) {
                index = info.indexOf("\n", i);
            }
            if (index == -1) continue;
            info.deleteCharAt(index);
            info.insert(index, "<br>");
            i += index - i;
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return this.getToolTipText();
    }

    private void showPopup(final Point p, final JPopupMenu menu) {
        final JDialog popupParent = SystemTray.getProgamPopupParent();
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                popupParent.setVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popupParent.setVisible(true);
        popupParent.toFront();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                menu.show(popupParent, p.x - popupParent.getLocation().x, p.y - popupParent.getLocation().y);
            }
        });
    }

    public Program getProgram() {
        return this.mProgram;
    }

    @Override
    public String getText() {
        String text = super.getText();
        return text;
    }
}

