/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import devplugin.InfoIf;
import devplugin.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicListUI;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.update.PluginsSoftwareUpdateItem;
import tvbrowser.ui.update.SoftwareUpdateItem;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.EnhancedPanelBuilder;
import util.ui.LinkButton;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.TextAreaIcon;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.ItemFilter;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;
import util.ui.html.HTMLTextHelper;

public class SoftwareUpdateDlg
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowClosingIf {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(SoftwareUpdateDlg.class);
    private JButton mCloseBtn;
    private JButton mDownloadBtn;
    private String mDownloadUrl;
    private JCheckBox mAutoUpdates;
    private SelectableItemList mSoftwareUpdateItemList;
    private int mLastIndex;
    private JButton mHelpBtn;
    private boolean mIsVersionChange;
    private Version mOldTvbVersion;
    private int mDialogType;

    public SoftwareUpdateDlg(Window parent, String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr, boolean isVersionChange, Version oldTvbVersion) {
        super(parent);
        this.setModal(true);
        this.mDialogType = dialogType;
        this.mIsVersionChange = isVersionChange;
        this.mOldTvbVersion = oldTvbVersion;
        this.createGui(downloadUrl, dialogType, itemArr, parent);
        if (dialogType == 3 || dialogType == 1) {
            this.mSoftwareUpdateItemList.selectAll();
            this.mDownloadBtn.setEnabled(this.mSoftwareUpdateItemList.getSelection().length > 0);
        }
    }

    public SoftwareUpdateDlg(Window parent, String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr) {
        this(parent, downloadUrl, dialogType, itemArr, false, null);
    }

    public SoftwareUpdateDlg(Window parent, int dialogType, SoftwareUpdateItem[] itemArr) {
        this(parent, null, dialogType, itemArr);
        this.mDownloadBtn.setEnabled(itemArr.length > 0);
    }

    public SoftwareUpdateDlg(Window parent, int dialogType, SoftwareUpdateItem[] itemArr, boolean isVersionChange, Version oldTvbVersion) {
        this(parent, null, dialogType, itemArr, isVersionChange, oldTvbVersion);
        this.mDownloadBtn.setEnabled(this.mSoftwareUpdateItemList.getItemCount() > 0);
    }

    private void createGui(String downloadUrl, int dialogType, SoftwareUpdateItem[] itemArr, Window parent) {
        Arrays.sort(itemArr, new Comparator<SoftwareUpdateItem>(){

            @Override
            public int compare(SoftwareUpdateItem item1, SoftwareUpdateItem item2) {
                return item1.getName().compareToIgnoreCase(item2.getName());
            }
        });
        this.mDownloadUrl = downloadUrl;
        this.setTitle(mLocalizer.msg("title", "Download plugins"));
        if (this.mIsVersionChange) {
            this.setDefaultCloseOperation(0);
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 11, 11));
        this.mCloseBtn = new JButton(Localizer.getLocalization("i18n_close"));
        this.mCloseBtn.addActionListener(this);
        this.mCloseBtn.setEnabled(!this.mIsVersionChange);
        this.mDownloadBtn = new JButton(mLocalizer.msg("download", "Download selected items"));
        this.mDownloadBtn.addActionListener(this);
        this.mHelpBtn = new JButton(mLocalizer.msg("openWebsite", "Open website"), TVBrowserIcons.webBrowser(16));
        this.mHelpBtn.addActionListener(this);
        this.mHelpBtn.setEnabled(false);
        ButtonBarBuilder builder = new ButtonBarBuilder();
        if (dialogType == 1 && !this.mIsVersionChange) {
            this.mAutoUpdates = new JCheckBox(mLocalizer.msg("autoUpdates", "Find plugin updates automatically"), Settings.propAutoUpdatePlugins.getBoolean());
            this.mAutoUpdates.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Settings.propAutoUpdatePlugins.setBoolean(e.getStateChange() == 1);
                }
            });
            builder.addFixed(this.mAutoUpdates);
            builder.addRelatedGap();
        }
        builder.addFixed(this.mHelpBtn);
        builder.addGlue();
        builder.addFixed(this.mDownloadBtn);
        builder.addRelatedGap();
        builder.addFixed(this.mCloseBtn);
        final CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("default,5dlu,0dlu:grow", "default");
        JPanel northPn = new JPanel(layout);
        JLabel info = new JLabel(mLocalizer.msg("header", "Here you can download new plugins and updates for it."));
        if (dialogType == 1) {
            info.setText(mLocalizer.msg("updateHeader", "Updates for installed plugins/new matching data plugins were found."));
        } else if (dialogType == 2) {
            info.setText(mLocalizer.msg("dataServiceHeader", "TV-Browser is based on Plugins. You will need at least one of the listed data Plugins."));
            info.setFont(info.getFont().deriveFont(1).deriveFont(14.0f));
        }
        northPn.add((Component)info, cc.xyw(1, 1, 3));
        JPanel southPn = new JPanel(new BorderLayout());
        southPn.add((Component)builder.getPanel(), "South");
        ArrayList<SoftwareUpdateItem> selectedItems = new ArrayList<SoftwareUpdateItem>();
        ArrayList<SoftwareUpdateItem> notSelectableItems = new ArrayList<SoftwareUpdateItem>();
        ArrayList<String> selectedDataServices = new ArrayList<String>(0);
        if (dialogType == 2 || this.mIsVersionChange) {
            String country = Locale.getDefault().getCountry();
            if (country.equals(Locale.GERMANY.getCountry()) || country.equals("ES") || country.equals("IT") || country.equals("FR") || country.equals("DK") || country.equals("CH") || country.equals("AT") || Locale.getDefault().getLanguage().toLowerCase().startsWith("de")) {
                selectedDataServices.add("TvBrowserDataService");
                if (country.equals(Locale.GERMANY.getCountry()) || country.equals("CH") || country.equals("AT") || Locale.getDefault().getLanguage().toLowerCase().startsWith("de")) {
                    selectedDataServices.add("EPGdonateData");
                    selectedDataServices.add("EPGpaidData");
                }
            } else if (country.equals(Locale.CANADA.getCountry()) || country.equals(Locale.US.getCountry())) {
                selectedDataServices.add("SchedulesDirectDataService");
                selectedDataServices.add("TvBrowserDataService");
            } else if (country.equals(Locale.UK.getCountry())) {
                selectedDataServices.add("BBCDataService");
                selectedDataServices.add("TvBrowserDataService");
            } else if (country.equals("NO")) {
                selectedDataServices.add("TvBrowserDataService");
                selectedDataServices.add("SweDBTvDataService");
            } else if (country.equals("SE") || country.equals("AU") || country.equals("HR")) {
                selectedDataServices.add("SweDBTvDataService");
            } else {
                selectedDataServices.add("TvBrowserDataService");
                selectedDataServices.add("SchedulesDirectDataService");
                selectedDataServices.add("BBCDataService");
                selectedDataServices.add("RadioTimesDataService");
                selectedDataServices.add("SweDBTvDataService");
            }
        }
        ArrayList<SoftwareUpdateItem> mItemList = new ArrayList<SoftwareUpdateItem>();
        for (SoftwareUpdateItem item : itemArr) {
            if (!item.isPreSelected() && (!selectedDataServices.contains(item.getClassName()) || !this.mIsVersionChange && dialogType != 2)) continue;
            if (this.mIsVersionChange) {
                mItemList.add(item);
            }
            selectedItems.add(item);
            if (!this.mIsVersionChange || item.getEssentialTvbVersion() == null || this.mOldTvbVersion == null || this.mOldTvbVersion.compareTo(item.getEssentialTvbVersion()) >= 0) continue;
            notSelectableItems.add(item);
        }
        this.mDownloadBtn.setEnabled(!selectedItems.isEmpty());
        this.mSoftwareUpdateItemList = new SelectableItemList((Object[])selectedItems.toArray(new SoftwareUpdateItem[selectedItems.size()]), (Object[])(this.mIsVersionChange ? mItemList.toArray(new SoftwareUpdateItem[mItemList.size()]) : itemArr), notSelectableItems.toArray(new SoftwareUpdateItem[notSelectableItems.size()]));
        this.mSoftwareUpdateItemList.addListSelectionListener(this);
        this.mSoftwareUpdateItemList.setSelectionMode(0);
        this.mSoftwareUpdateItemList.setListUI(new MyListUI());
        this.mSoftwareUpdateItemList.setHorizontalScrollBarPolicy(31);
        this.mSoftwareUpdateItemList.addCenterRendererComponent(PluginsSoftwareUpdateItem.class, new SelectableItemRendererCenterComponentIf(){
            private final ImageIcon NEW_VERSION_ICON = IconLoader.getInstance().getIconFromTheme("status", "software-update-available", 16);

            @Override
            public JPanel createCenterPanel(JList list, Object value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                Version installedVersion;
                FormLayout lay = new FormLayout("5dlu,default,5dlu,default:grow", "2dlu,default,2dlu,fill:pref:grow,2dlu");
                EnhancedPanelBuilder pb = new EnhancedPanelBuilder(lay);
                pb.getPanel().setOpaque(false);
                SoftwareUpdateItem item = (SoftwareUpdateItem)value;
                JLabel label = pb.addLabel(HTMLTextHelper.convertHtmlToText(item.getName()) + " " + item.getVersion(), cc.xy(2, 2));
                label.setFont(label.getFont().deriveFont(1, label.getFont().getSize2D() + 2.0f));
                int width = parentScrollPane.getSize().width - parentScrollPane.getVerticalScrollBar().getWidth() - leftColumnWidth - Sizes.dialogUnitXAsPixel(5, pb.getPanel()) * 4 - parentScrollPane.getInsets().left - parentScrollPane.getInsets().right;
                if (width <= 0) {
                    width = Settings.propColumnWidth.getInt();
                }
                TextAreaIcon icon = new TextAreaIcon(HTMLTextHelper.convertHtmlToText(item.getDescription()), new JLabel().getFont(), width, 2);
                JLabel iconLabel = new JLabel("");
                iconLabel.setIcon(icon);
                pb.add((Component)iconLabel, cc.xyw(2, 4, 3));
                JLabel label3 = new JLabel();
                if (item.isAlreadyInstalled() && (installedVersion = item.getInstalledVersion()) != null && installedVersion.compareTo(item.getVersion()) < 0) {
                    label.setIcon(this.NEW_VERSION_ICON);
                    label3.setText("(" + mLocalizer.msg("installed", "Installed version: ") + installedVersion.toString() + ")");
                    label3.setFont(label3.getFont().deriveFont(label3.getFont().getSize2D() + 2.0f));
                    pb.add((Component)label3, cc.xy(4, 2));
                }
                if (isSelected && isEnabled) {
                    label.setForeground(list.getSelectionForeground());
                    String author = item.getProperty("author");
                    String website = item.getWebsite();
                    FormLayout authorAndWebsiteLayout = new FormLayout("default,5dlu,default", "default");
                    JPanel authorAndWebsite = new JPanel(authorAndWebsiteLayout);
                    authorAndWebsite.setOpaque(false);
                    if (author != null) {
                        lay.appendRow(RowSpec.decode("2dlu"));
                        lay.appendRow(RowSpec.decode("default"));
                        lay.appendRow(RowSpec.decode("2dlu"));
                        pb.add((Component)authorAndWebsite, cc.xyw(2, 7, 3));
                        JLabel authorLabel = new JLabel(mLocalizer.msg("author", "Author"));
                        authorLabel.setFont(authorLabel.getFont().deriveFont(1));
                        authorLabel.setForeground(list.getSelectionForeground());
                        authorLabel.setHorizontalAlignment(4);
                        JLabel authorName = new JLabel(HTMLTextHelper.convertHtmlToText(author));
                        authorName.setForeground(list.getSelectionForeground());
                        authorAndWebsite.add((Component)authorLabel, cc.xy(1, 1));
                        authorAndWebsite.add((Component)authorName, cc.xy(3, 1));
                    }
                    if (website != null) {
                        if (author == null) {
                            lay.appendRow(RowSpec.decode("2dlu"));
                            lay.appendRow(RowSpec.decode("default"));
                            lay.appendRow(RowSpec.decode("2dlu"));
                            pb.add((Component)authorAndWebsite, cc.xyw(2, 7, 3));
                        } else {
                            authorAndWebsiteLayout.appendRow(RowSpec.decode("1dlu"));
                            authorAndWebsiteLayout.appendRow(RowSpec.decode("default"));
                        }
                        JLabel webLabel = new JLabel(mLocalizer.msg("website", "Website"));
                        webLabel.setFont(webLabel.getFont().deriveFont(1));
                        webLabel.setForeground(list.getSelectionForeground());
                        webLabel.setHorizontalAlignment(4);
                        LinkButton webLink = new LinkButton(HTMLTextHelper.convertHtmlToText(website));
                        webLink.setForeground(list.getSelectionForeground());
                        authorAndWebsite.add((Component)webLabel, cc.xy(1, author == null ? 1 : 3));
                        authorAndWebsite.add((Component)webLink, cc.xy(3, author == null ? 1 : 3));
                    }
                    icon.setMaximumLineCount(-1);
                    iconLabel.setForeground(list.getSelectionForeground());
                    label3.setForeground(list.getSelectionForeground());
                } else {
                    if (!item.isStable()) {
                        label.setForeground(new Color(200, 0, 0));
                    } else {
                        label.setForeground(list.getForeground());
                    }
                    icon.setMaximumLineCount(1);
                    iconLabel.setForeground(list.getSelectionForeground());
                    iconLabel.setForeground(list.getForeground());
                    label3.setForeground(Color.gray);
                }
                return pb.getPanel();
            }

            @Override
            public void calculateSize(JList list, int index, JPanel contPane) {
                if (list.getUI() instanceof MyListUI) {
                    ((MyListUI)list.getUI()).setCellHeight(index, contPane.getPreferredSize().height);
                }
            }
        });
        this.mSoftwareUpdateItemList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    SoftwareUpdateDlg.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.isPopupTrigger()) {
                    SoftwareUpdateDlg.this.showPopupMenu(e);
                }
            }
        });
        if (dialogType != 1 && dialogType != 2) {
            layout.appendRow(RowSpec.decode("5dlu"));
            layout.appendRow(RowSpec.decode("default"));
            JLabel filterLabel = new JLabel(mLocalizer.msg("filterLabel", "Show only Plugins with the following category:"));
            northPn.add((Component)filterLabel, cc.xy(1, 3));
            ArrayList<FilterItem> filterList = new ArrayList<FilterItem>(0);
            for (SoftwareUpdateItem item : itemArr) {
                int index = 0;
                for (int i = 0; i < filterList.size(); ++i) {
                    int compareValue = ((FilterItem)filterList.get(i)).compareTo(item.getCategory());
                    if (compareValue == 0) {
                        index = -1;
                        break;
                    }
                    if (compareValue >= 0) continue;
                    index = i + 1;
                }
                if (index == -1) continue;
                filterList.add(index, new FilterItem(item.getCategory()));
            }
            filterList.add(0, new FilterItem("all"));
            JComboBox<Object> filterBox = new JComboBox<Object>(filterList.toArray());
            this.mSoftwareUpdateItemList.setFilterComboBox(filterBox);
            northPn.add(filterBox, cc.xy(3, 3));
        }
        contentPane.add((Component)northPn, "North");
        contentPane.add((Component)this.mSoftwareUpdateItemList, "Center");
        contentPane.add((Component)southPn, "South");
        Settings.layoutWindow("softwareUpdateDlg", this, new Dimension(700, 600), parent);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SoftwareUpdateDlg.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SoftwareUpdateDlg.this.mSoftwareUpdateItemList.setVerticalScrollBarBlockIncrement(((SoftwareUpdateDlg)SoftwareUpdateDlg.this).mSoftwareUpdateItemList.getSize().height - 5);
            }
        });
        UiUtilities.registerForClosing(this);
    }

    public boolean isEmpty() {
        return this.mSoftwareUpdateItemList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        SoftwareUpdateItem item;
        if (event.getSource() == this.mCloseBtn) {
            this.close();
        } else if (event.getSource() == this.mDownloadBtn) {
            this.mDownloadBtn.setEnabled(false);
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            int successfullyDownloadedItems = 0;
            try {
                Object[] objects;
                for (Object object : objects = this.mSoftwareUpdateItemList.getSelection()) {
                    SoftwareUpdateItem item2 = (SoftwareUpdateItem)object;
                    try {
                        item2.download(this.mDownloadUrl);
                        ++successfullyDownloadedItems;
                    }
                    catch (TvBrowserException e) {
                        ErrorHandler.handle(e);
                    }
                }
            }
            finally {
                this.mDownloadBtn.setEnabled(true);
                this.setCursor(cursor);
            }
            if (successfullyDownloadedItems > 0 && !this.mIsVersionChange && this.mDialogType != 2) {
                if (TVBrowser.restartEnabled()) {
                    Object[] options = new String[]{"", ""};
                    options[0] = mLocalizer.msg("restartnow", "restart");
                    options[1] = mLocalizer.msg("restartlater", "later");
                    if (JOptionPane.showOptionDialog(null, mLocalizer.msg("restartplugin", "plugins has been installed.\nrestart TV-Browser?"), mLocalizer.msg("restartdialog", "restart"), 0, 3, null, options, options[0]) == 0) {
                        TVBrowser.addRestart();
                        MainFrame.getInstance().quit();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, mLocalizer.msg("restartprogram", "please restart tvbrowser before..."));
                }
                this.setVisible(false);
            } else if (this.mIsVersionChange || this.mDialogType == 2) {
                this.setVisible(false);
            }
        } else if (event.getSource() == this.mHelpBtn && (item = (SoftwareUpdateItem)((SelectableItem)this.mSoftwareUpdateItemList.getSelectedValue()).getItem()) != null) {
            Launch.openURL(item.getWebsite());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.mDownloadBtn.setEnabled(this.mSoftwareUpdateItemList.getSelection().length > 0);
        if (this.mIsVersionChange) {
            this.mCloseBtn.setEnabled(this.mSoftwareUpdateItemList.getSelection().length == 0);
        }
        if (event.getSource() instanceof JList && !event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            if (this.mLastIndex != -1 && list.getSelectedIndex() != this.mLastIndex && list.getModel().getSize() - 1 >= this.mLastIndex) {
                ((MyListUI)list.getUI()).setCellHeight(this.mLastIndex, list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt((int)this.mLastIndex), (int)this.mLastIndex, (boolean)false, (boolean)false).getPreferredSize().height);
            }
            this.mLastIndex = list.getSelectedIndex();
            if (this.mLastIndex < 0) {
                this.mHelpBtn.setEnabled(false);
            } else {
                SoftwareUpdateItem item = (SoftwareUpdateItem)((SelectableItem)this.mSoftwareUpdateItemList.getSelectedValue()).getItem();
                String website = item.getWebsite();
                this.mHelpBtn.setEnabled(website != null && website.length() > 0);
            }
        }
        this.mSoftwareUpdateItemList.calculateSize();
    }

    @Override
    public void close() {
        if (!this.mIsVersionChange || this.mSoftwareUpdateItemList.getSelection().length == 0) {
            this.setVisible(false);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        Object item;
        JList list;
        Object listItem;
        if (e.getSource() instanceof JList && (listItem = (list = (JList)e.getSource()).getModel().getElementAt(list.locationToIndex(e.getPoint()))) instanceof SelectableItem && (item = ((SelectableItem)listItem).getItem()) instanceof SoftwareUpdateItem && ((SoftwareUpdateItem)item).getWebsite() != null) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(mLocalizer.msg("openWebsite", "Open website"), TVBrowserIcons.webBrowser(16));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Launch.openURL(((SoftwareUpdateItem)item).getWebsite());
                }
            });
            menu.add(menuItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static class FilterItem
    implements ItemFilter {
        private String mType;

        public FilterItem(String type) {
            this.mType = type;
        }

        public String toString() {
            return mLocalizer.msg(this.mType, this.mType);
        }

        public boolean equals(Object o) {
            if (o != null) {
                if (o instanceof FilterItem) {
                    return this.mType.equals(((FilterItem)o).mType);
                }
                if (o instanceof String) {
                    return this.mType.equals(o);
                }
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o != null) {
                if (o instanceof FilterItem) {
                    return this.toString().compareToIgnoreCase(((FilterItem)o).toString());
                }
                if (o instanceof String) {
                    return this.toString().compareToIgnoreCase(mLocalizer.msg((String)o, (String)o));
                }
            }
            return 0;
        }

        @Override
        public boolean accept(Object o) {
            if (o instanceof SoftwareUpdateItem) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((SoftwareUpdateItem)o).getCategory());
            }
            if (o instanceof InternalPluginProxyIf) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((InternalPluginProxyIf)o).getPluginCategory());
            }
            if (o instanceof InfoIf) {
                if (this.mType.equals("all")) {
                    return true;
                }
                return this.equals(((InfoIf)o).getPluginCategory());
            }
            return false;
        }
    }

    private static class MyListUI
    extends BasicListUI {
        private MyListUI() {
        }

        protected synchronized void setCellHeight(int row, int height) {
            this.cellHeights[row] = height;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int width = super.getPreferredSize((JComponent)c).width;
            int height = 0;
            Insets i = c.getInsets();
            height += i.top + i.bottom;
            for (int localCellHeight : this.cellHeights) {
                height += localCellHeight;
            }
            return new Dimension(width, height);
        }
    }
}

