/*
 * Decompiled with CFR 0.152.
 */
package util.browserlauncher;

import bsh.StringUtil;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.BrowserLauncher;
import util.exc.ErrorHandler;
import util.io.ExecutionHandler;
import util.io.IOUtilities;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class Launch {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(Launch.class);
    public static final int OS_MAC = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_OTHER = 2;
    public static final int OS_LINUX = 3;

    public static void openURL(String url) {
        block17: {
            if (url == null) {
                return;
            }
            String[] urls = StringUtil.split(url, " ");
            if (urls.length > 1) {
                boolean multiUrls = true;
                for (String partUrl : urls) {
                    if (partUrl.trim().startsWith("http")) continue;
                    multiUrls = false;
                }
                if (multiUrls) {
                    for (String partUrl : urls) {
                        Launch.openURL(partUrl.trim());
                    }
                    return;
                }
            }
            String browserExecutable = IOUtilities.translateRelativePath(Settings.propUserDefinedWebbrowser.getString());
            try {
                if (browserExecutable != null) {
                    String params = Settings.propUserDefinedWebbrowserParams.getString().replace("{0}", url);
                    if (Launch.getOs() == 0 && browserExecutable.trim().toLowerCase().endsWith(".app")) {
                        new ExecutionHandler(params, "open -a " + browserExecutable).execute();
                    } else {
                        new ExecutionHandler(params, browserExecutable).execute();
                    }
                } else {
                    boolean opened = false;
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop desktop = Desktop.getDesktop();
                            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                                desktop.browse(new URI(url));
                                opened = true;
                            }
                        }
                        catch (Exception e) {
                            opened = false;
                        }
                    }
                    if (!opened) {
                        BrowserLauncher.openURL(url);
                    }
                }
                if (Settings.propShowBrowserOpenDialog.getBoolean()) {
                    final JDialog dialog = new JDialog((Frame)MainFrame.getInstance(), true);
                    dialog.setTitle(mLocalizer.msg("okTitle", "okTitle"));
                    UiUtilities.registerForClosing(new WindowClosingIf(){

                        @Override
                        public void close() {
                            dialog.setVisible(false);
                            Settings.propShowBrowserOpenDialog.setBoolean(true);
                        }

                        @Override
                        public JRootPane getRootPane() {
                            return dialog.getRootPane();
                        }
                    });
                    JPanel content = (JPanel)dialog.getContentPane();
                    content.setBorder(Borders.DIALOG);
                    FormLayout layout = new FormLayout("fill:235dlu:grow", "default, 3dlu, default, 3dlu, default");
                    dialog.getContentPane().setLayout(layout);
                    CellConstraints cc = new CellConstraints();
                    content.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("okMessage", "OK Message")), cc.xy(1, 1));
                    final JCheckBox showBrowserDialog = new JCheckBox(mLocalizer.msg("okCheckbox", "OK Checkbox"));
                    content.add((Component)showBrowserDialog, cc.xy(1, 3));
                    JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog.setVisible(false);
                            if (showBrowserDialog.isSelected()) {
                                Settings.propShowBrowserOpenDialog.setBoolean(false);
                            } else {
                                Settings.propShowBrowserOpenDialog.setBoolean(true);
                            }
                        }
                    });
                    JButton configure = new JButton(mLocalizer.msg("okConfigure", "Configure"));
                    configure.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dialog.setVisible(false);
                            MainFrame.getInstance().showSettingsDialog("#webbrowser");
                        }
                    });
                    JPanel buttonPanel = new JPanel(new FlowLayout(2));
                    buttonPanel.add(configure);
                    buttonPanel.add(ok);
                    content.add((Component)buttonPanel, cc.xy(1, 5));
                    dialog.pack();
                    UiUtilities.centerAndShow(dialog);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                int ret = ErrorHandler.handle(mLocalizer.msg("error", "An error occured"), e, 1);
                if (ret != 2) break block17;
                MainFrame.getInstance().showSettingsDialog("#webbrowser");
            }
        }
    }

    public static int getOs() {
        if (BrowserLauncher.getJvm() < 0) {
            return 2;
        }
        if (BrowserLauncher.getJvm() < 6) {
            return 0;
        }
        if (BrowserLauncher.getJvm() <= 7) {
            return 1;
        }
        if (BrowserLauncher.getJvm() == 8) {
            return 3;
        }
        return 2;
    }

    public static boolean isOsWindowsNtBranch() {
        return BrowserLauncher.getJvm() == 6;
    }
}

