/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import util.io.StreamReaderThread;

public class ExecutionHandler {
    private String[] mParameter;
    private File mRuntimeDirectory;
    private StreamReaderThread mInputStream;
    private StreamReaderThread mErrorStream;
    private Process mProcess;

    public ExecutionHandler(String parameter, String programPath) {
        this(parameter, programPath, (File)null);
        if (programPath.contains(File.separator)) {
            String path = programPath.substring(0, programPath.lastIndexOf(File.separator) + 1);
            if (path == null || path.length() < 1 || !new File(path).isDirectory()) {
                path = System.getProperty("user.dir");
            }
            this.mRuntimeDirectory = new File(path.trim());
        }
    }

    public ExecutionHandler(String parameter, String programPath, String runtimeDirectory) {
        this(parameter, programPath, new File(runtimeDirectory.trim()));
    }

    public ExecutionHandler(String parameter, String programPath, File runtimeDirectory) {
        this.mParameter = this.calculateParameter(parameter, programPath);
        this.mRuntimeDirectory = runtimeDirectory;
    }

    public ExecutionHandler(String[] parameterWithProgramPath) {
        this(parameterWithProgramPath, (File)null);
    }

    public ExecutionHandler(String[] parameterWithProgramPath, String runtimeDirectory) {
        this(parameterWithProgramPath, new File(runtimeDirectory.trim()));
    }

    public ExecutionHandler(String[] parameterWithProgramPath, File runtimeDirectory) {
        this.mParameter = parameterWithProgramPath;
        this.mRuntimeDirectory = runtimeDirectory;
    }

    public void execute() throws IOException {
        this.execute(false, false);
    }

    public void execute(String encoding) throws IOException {
        this.execute(false, false, encoding);
    }

    public void execute(boolean logInputStream) throws IOException {
        this.execute(logInputStream, false);
    }

    public void execute(boolean logInputStream, String encoding) throws IOException {
        this.execute(logInputStream, false, encoding);
    }

    public void execute(boolean logInputStream, boolean logErrorStream) throws IOException {
        this.execute(logInputStream, logErrorStream, null);
    }

    public void execute(boolean logInputStream, boolean logErrorStream, String encoding) throws IOException {
        this.mProcess = Runtime.getRuntime().exec(this.mParameter, null, this.mRuntimeDirectory);
        this.mInputStream = new StreamReaderThread(this.mProcess.getInputStream(), logInputStream, encoding);
        this.mErrorStream = new StreamReaderThread(this.mProcess.getErrorStream(), logErrorStream, encoding);
        this.mInputStream.start();
        this.mErrorStream.start();
    }

    public Process getProcess() {
        return this.mProcess;
    }

    public int exitValue() throws IllegalThreadStateException {
        if (this.mProcess == null) {
            throw new IllegalThreadStateException("Process wasn't started.");
        }
        return this.mProcess.exitValue();
    }

    public StreamReaderThread getInputStreamReaderThread() {
        return this.mInputStream;
    }

    public StreamReaderThread getErrorStreamReaderThread() {
        return this.mErrorStream;
    }

    private String[] calculateParameter(String parameter, String programPath) {
        StringBuilder lastString = null;
        ArrayList<String> args = new ArrayList<String>();
        args.add(programPath.trim());
        for (String part : parameter.split(" ")) {
            if (part.length() > 0 && part.charAt(0) == '\"') {
                if (part.charAt(part.length() - 1) == '\"') {
                    args.add(part);
                    continue;
                }
                lastString = new StringBuilder(part);
                lastString.deleteCharAt(0);
                continue;
            }
            if (lastString != null) {
                lastString.append(' ');
                lastString.append(part);
                if (part.length() <= 0 || part.charAt(part.length() - 1) != '\"') continue;
                lastString.deleteCharAt(lastString.length() - 1);
                args.add(lastString.toString());
                lastString = null;
                continue;
            }
            if (part.trim().length() <= 0) continue;
            args.add(part);
        }
        return args.toArray(new String[args.size()]);
    }

    public String getOutput() {
        StreamReaderThread thread = this.getInputStreamReaderThread();
        try {
            thread.join(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return thread.getOutputString();
    }

    public String getErrors() {
        StreamReaderThread thread = this.getErrorStreamReaderThread();
        try {
            thread.join(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return thread.getOutputString();
    }
}

