/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import util.paramhandler.ParamCheckDialog;
import util.paramhandler.ParamHelpDialog;
import util.paramhandler.ParamLibrary;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class ParamInputField
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ParamInputField.class);
    private JTextArea mParamText;
    private ParamLibrary mParamLibrary;

    public ParamInputField(String text) {
        this(text, false);
    }

    public ParamInputField(String text, boolean singleLine) {
        this(new ParamLibrary(), text, singleLine);
    }

    public ParamInputField(ParamLibrary library, String text) {
        this(library, text, false);
    }

    public ParamInputField(ParamLibrary library, String text, boolean singleLine) {
        this.mParamLibrary = library;
        if (this.mParamLibrary == null) {
            this.mParamLibrary = new ParamLibrary();
        }
        this.createGui(text, singleLine);
    }

    private void createGui(String text, boolean singleLine) {
        FormLayout layout = new FormLayout("fill:min:grow, 3dlu, default, 3dlu, default, 3dlu, default", "fill:20dlu:grow, 3dlu, default");
        this.setLayout(layout);
        CellConstraints cc = new CellConstraints();
        this.mParamText = new JTextArea();
        this.mParamText.setText(text);
        if (singleLine) {
            this.mParamText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        ke.consume();
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.mParamText, 20, 31);
            this.add((Component)scroll, cc.xyw(1, 1, layout.getColumnCount()));
        } else {
            this.mParamText.setLineWrap(true);
            this.add((Component)new JScrollPane(this.mParamText), cc.xyw(1, 1, layout.getColumnCount()));
        }
        ArrayList<String> items = new ArrayList<String>();
        items.add(mLocalizer.msg("insert", "Insert"));
        List<String> functions = Arrays.asList(this.mParamLibrary.getPossibleFunctions());
        Collections.sort(functions);
        for (String function : functions) {
            items.add(function + "()");
        }
        List<String> keys = Arrays.asList(this.mParamLibrary.getPossibleKeys());
        Collections.sort(keys);
        for (String key : keys) {
            items.add(key);
        }
        final JComboBox<String> insert = new JComboBox<String>(items.toArray(new String[items.size()]));
        this.add(insert, cc.xy(layout.getColumnCount() - 4, 3));
        insert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (insert.getSelectedIndex() > 0) {
                    int selEnd;
                    boolean inFunction = false;
                    String newText = insert.getSelectedItem().toString();
                    int selStart = ParamInputField.this.mParamText.getSelectionStart();
                    if (selStart > 0) {
                        try {
                            if (ParamInputField.this.mParamText.getText(selStart - 1, 1).equals("(")) {
                                inFunction = true;
                            }
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if ((selEnd = ParamInputField.this.mParamText.getSelectionEnd()) < ParamInputField.this.mParamText.getText().length()) {
                        try {
                            if (ParamInputField.this.mParamText.getText(selEnd + 1, 1).equals(")")) {
                                inFunction = true;
                            }
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (!inFunction) {
                        newText = "{" + newText + "}";
                    }
                    ParamInputField.this.mParamText.insert(newText, selStart);
                    int lastBrace = newText.lastIndexOf(41);
                    if (lastBrace > 0 && newText.length() - lastBrace <= 2) {
                        ParamInputField.this.mParamText.setCaretPosition(ParamInputField.this.mParamText.getSelectionStart() - (newText.length() - lastBrace));
                    }
                    ParamInputField.this.mParamText.requestFocus();
                }
            }
        });
        JButton check = new JButton(mLocalizer.msg("check", "Check"));
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Window bestparent = UiUtilities.getBestDialogParent(ParamInputField.this);
                ParamCheckDialog dialog = new ParamCheckDialog(bestparent, ParamInputField.this.mParamLibrary, ParamInputField.this.mParamText.getText());
                dialog.setVisible(true);
            }
        });
        this.add((Component)check, cc.xy(layout.getColumnCount() - 2, 3));
        JButton help = new JButton(Localizer.getLocalization("i18n_help"));
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Window bestparent = UiUtilities.getBestDialogParent(ParamInputField.this);
                ParamHelpDialog dialog = new ParamHelpDialog(bestparent, ParamInputField.this.mParamLibrary);
                dialog.setVisible(true);
            }
        });
        this.add((Component)help, cc.xy(layout.getColumnCount(), 3));
    }

    public String getText() {
        return this.mParamText.getText();
    }

    public void setText(String text) {
        this.mParamText.setText(text);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.mParamText.addFocusListener(listener);
    }
}

