/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.settings.Property;
import util.settings.PropertyManager;

public class ByteProperty
extends Property {
    private byte mDefaultValue;
    private boolean mIsCacheFilled;
    private byte mCachedValue;

    public ByteProperty(PropertyManager manager, String key, byte defaultValue) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mIsCacheFilled = false;
    }

    public byte getDefault() {
        return this.mDefaultValue;
    }

    public byte getByte() {
        if (!this.mIsCacheFilled) {
            String asString = this.getProperty();
            if (asString == null) {
                this.mCachedValue = this.mDefaultValue;
            } else {
                try {
                    this.mCachedValue = Byte.parseByte(asString);
                }
                catch (Exception exc) {
                    this.mCachedValue = this.mDefaultValue;
                }
            }
            this.mIsCacheFilled = true;
        }
        return this.mCachedValue;
    }

    public void setByte(byte value) {
        if (value == this.mDefaultValue) {
            this.setProperty(null);
        } else {
            this.setProperty(Byte.toString(value));
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mIsCacheFilled = false;
    }
}

