/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.ui.Localizer;
import util.ui.TabLayout;
import util.ui.UiUtilities;

public class AlphaColorChooser
extends JDialog
implements ChangeListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AlphaColorChooser.class);
    private JSlider mRedSl;
    private JSlider mGreenSl;
    private JSlider mBlueSl;
    private JSlider mAlphaSl;
    private JSpinner mRedSp;
    private JSpinner mGreenSp;
    private JSpinner mBlueSp;
    private JSpinner mAlphaSp;
    private PaintColor mColorPanel;
    private Color mCurrentColor;
    private Color mDefaultColor;
    private Color mStandardColor;
    private int mReturnValue = 2;

    public AlphaColorChooser(Window parent, String title, Color color, Color stdColor) {
        super(parent, title);
        this.setModal(true);
        this.mStandardColor = stdColor;
        this.createGui();
        this.mDefaultColor = color;
        this.setColor(color);
    }

    @Deprecated
    public AlphaColorChooser(JDialog parent, String title, Color color, Color stdColor) {
        this((Window)parent, title, color, stdColor);
    }

    @Deprecated
    public AlphaColorChooser(JFrame parent, String title, Color color, Color stdColor) {
        this((Window)parent, title, color, stdColor);
    }

    public void createGui() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(Borders.DLU4);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel values = new JPanel(new TabLayout(3));
        values.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("Values", "Values") + ":"));
        values.add(new JLabel(mLocalizer.msg("red", "Red") + ":"));
        this.mRedSl = this.createSlider();
        values.add(this.mRedSl);
        this.mRedSp = this.createSpinner();
        values.add(this.mRedSp);
        values.add(new JLabel(mLocalizer.msg("green", "Green") + ":"));
        this.mGreenSl = this.createSlider();
        values.add(this.mGreenSl);
        this.mGreenSp = this.createSpinner();
        values.add(this.mGreenSp);
        values.add(new JLabel(mLocalizer.msg("blue", "Blue") + ":"));
        this.mBlueSl = this.createSlider();
        values.add(this.mBlueSl);
        this.mBlueSp = this.createSpinner();
        values.add(this.mBlueSp);
        values.add(new JLabel(mLocalizer.msg("alpha", "Alpha") + ":"));
        this.mAlphaSl = this.createSlider();
        values.add(this.mAlphaSl);
        this.mAlphaSp = this.createSpinner();
        values.add(this.mAlphaSp);
        this.mRedSl.addChangeListener(this);
        this.mRedSp.addChangeListener(this);
        this.mGreenSl.addChangeListener(this);
        this.mGreenSp.addChangeListener(this);
        this.mBlueSl.addChangeListener(this);
        this.mBlueSp.addChangeListener(this);
        this.mAlphaSl.addChangeListener(this);
        this.mAlphaSp.addChangeListener(this);
        panel.add((Component)values, c);
        JPanel color = new JPanel(new BorderLayout());
        color.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("Color", "Color") + ":"));
        this.mColorPanel = new PaintColor();
        color.add((Component)this.mColorPanel, "Center");
        color.setMinimumSize(new Dimension(100, 100));
        color.setPreferredSize(new Dimension(100, 100));
        c.gridwidth = 0;
        panel.add((Component)color, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.gridwidth = 0;
        FormLayout layout = new FormLayout("pref, fill:pref:grow, pref, 3dlu, pref", "pref");
        layout.setColumnGroups(new int[][]{{1, 3, 5}});
        JPanel buttonPanel = new JPanel(layout);
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaColorChooser.this.stopEditing();
                AlphaColorChooser.this.updateColorPanel();
                AlphaColorChooser.this.mReturnValue = 0;
                AlphaColorChooser.this.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaColorChooser.this.mCurrentColor = AlphaColorChooser.this.mDefaultColor;
                AlphaColorChooser.this.updateColorPanel();
                AlphaColorChooser.this.mReturnValue = 2;
                AlphaColorChooser.this.setVisible(false);
            }
        });
        CellConstraints cc = new CellConstraints();
        if (this.mStandardColor != null) {
            JButton def = new JButton(Localizer.getLocalization("i18n_default"));
            def.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlphaColorChooser.this.setColor(AlphaColorChooser.this.mStandardColor);
                    AlphaColorChooser.this.mCurrentColor = AlphaColorChooser.this.mStandardColor;
                }
            });
            buttonPanel.add((Component)def, cc.xy(1, 1));
        }
        buttonPanel.add((Component)ok, cc.xy(3, 1));
        buttonPanel.add((Component)cancel, cc.xy(5, 1));
        panel.add((Component)buttonPanel, c);
        this.updateColorPanel();
        this.pack();
    }

    private JSpinner createSpinner() {
        SpinnerNumberModel model = new SpinnerNumberModel(100, 0, 255, 1);
        JSpinner ret = new JSpinner(model);
        ret.setMinimumSize(new Dimension(50, 10));
        ret.setPreferredSize(new Dimension(50, 10));
        return ret;
    }

    private JSlider createSlider() {
        JSlider ret = new JSlider(0, 255, 100);
        ret.setMinorTickSpacing(25);
        ret.setPaintTicks(true);
        return ret;
    }

    public static Color showDialog(Component parent, String title, Color color, Color stdColor) {
        AlphaColorChooser chooser = parent instanceof Window ? new AlphaColorChooser((Window)parent, title, color, stdColor) : new AlphaColorChooser((Window)null, title, color, stdColor);
        UiUtilities.centerAndShow(chooser);
        if (chooser.getReturnValue() == 0) {
            return chooser.getColor();
        }
        return color;
    }

    public int getReturnValue() {
        return this.mReturnValue;
    }

    private void updateColorPanel() {
        int red = this.mRedSl.getValue();
        int green = this.mGreenSl.getValue();
        int blue = this.mBlueSl.getValue();
        int alpha = this.mAlphaSl.getValue();
        this.mCurrentColor = new Color(red, green, blue, alpha);
        this.mColorPanel.setBackground(this.mCurrentColor);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.mRedSp) {
            this.mRedSl.setValue((Integer)this.mRedSp.getValue());
        } else if (e.getSource() == this.mGreenSp) {
            this.mGreenSl.setValue((Integer)this.mGreenSp.getValue());
        } else if (e.getSource() == this.mBlueSp) {
            this.mBlueSl.setValue((Integer)this.mBlueSp.getValue());
        } else if (e.getSource() == this.mAlphaSp) {
            this.mAlphaSl.setValue((Integer)this.mAlphaSp.getValue());
        } else if (e.getSource() == this.mRedSl) {
            this.mRedSp.setValue(this.mRedSl.getValue());
        } else if (e.getSource() == this.mGreenSl) {
            this.mGreenSp.setValue(this.mGreenSl.getValue());
        } else if (e.getSource() == this.mBlueSl) {
            this.mBlueSp.setValue(this.mBlueSl.getValue());
        } else if (e.getSource() == this.mAlphaSl) {
            this.mAlphaSp.setValue(this.mAlphaSl.getValue());
        }
        this.updateColorPanel();
    }

    private void stopEditing() {
        this.mRedSl.grabFocus();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.mRedSl.setValue(color.getRed());
            this.mGreenSl.setValue(color.getGreen());
            this.mBlueSl.setValue(color.getBlue());
            this.mAlphaSl.setValue(color.getAlpha());
        }
    }

    public Color getColor() {
        this.stopEditing();
        this.updateColorPanel();
        return this.mCurrentColor;
    }

    private static class PaintColor
    extends JPanel {
        private PaintColor() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.GRAY);
            for (int y = 0; y < this.getHeight(); y += 15) {
                int start = 0;
                if ((y & 1) == 1) {
                    start = 15;
                }
                for (int x = start; x < this.getWidth(); x += 30) {
                    g.fillRect(x, y, 15, 15);
                }
            }
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

