/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import util.ui.Localizer;

public class FontChooserPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FontChooserPanel.class);
    private JComboBox mFontCB;
    private JComboBox mStyleCB;
    private JSpinner mSizeSpinner;
    private JLabel mTitle;
    private static GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static final String[] FONTNAMES = ge.getAvailableFontFamilyNames();
    private static final String[] FONTSTYLES = new String[]{mLocalizer.msg("plain", "plain"), mLocalizer.msg("bold", "bold"), mLocalizer.msg("italic", "italic")};
    private static final int FONTSIZE_MIN = 8;
    private static final int FONTSIZE_MAX = 40;

    public FontChooserPanel(String title, Font font, boolean style) {
        this.setLayout(new BorderLayout());
        if (title != null) {
            this.mTitle = new JLabel(title);
            this.add((Component)this.mTitle, "North");
        }
        FormLayout layout = new FormLayout("min:grow,2dlu,min", "default");
        JPanel innerPanel = new JPanel(layout);
        innerPanel.setBorder(BorderFactory.createEmptyBorder());
        CellConstraints cc = new CellConstraints();
        this.mFontCB = new JComboBox<String>(FONTNAMES);
        this.mStyleCB = new JComboBox<String>(FONTSTYLES);
        this.mSizeSpinner = new JSpinner(new SpinnerNumberModel(8, 8, 40, 1));
        int column = 1;
        innerPanel.add((Component)this.mFontCB, cc.xy(column, 1));
        if (style) {
            layout.appendColumn(ColumnSpec.decode("2dlu"));
            layout.appendColumn(ColumnSpec.decode("min"));
            innerPanel.add((Component)this.mStyleCB, cc.xy(column += 2, 1));
        }
        innerPanel.add((Component)this.mSizeSpinner, cc.xy(column += 2, 1));
        this.add((Component)innerPanel, "Center");
        if (font != null) {
            this.selectFont(font);
        }
    }

    public FontChooserPanel(String title, Font font) {
        this(title, font, true);
    }

    public FontChooserPanel(Font font) {
        this(null, font, true);
    }

    public FontChooserPanel(Font font, boolean enableStyleSelection) {
        this(null, font, enableStyleSelection);
    }

    public FontChooserPanel(String title) {
        this(title, null);
    }

    public void selectFont(Font font) {
        for (int i = 0; i < this.mFontCB.getItemCount(); ++i) {
            String item = (String)this.mFontCB.getItemAt(i);
            if (!item.equals(font.getName())) continue;
            this.mFontCB.setSelectedIndex(i);
            break;
        }
        this.mSizeSpinner.setValue(font.getSize());
        if (font.getStyle() == 1) {
            this.mStyleCB.setSelectedIndex(1);
        } else if (font.getStyle() == 2) {
            this.mStyleCB.setSelectedIndex(2);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mFontCB.setEnabled(enabled);
        this.mStyleCB.setEnabled(enabled);
        this.mSizeSpinner.setEnabled(enabled);
        if (this.mTitle != null) {
            this.mTitle.setEnabled(enabled);
        }
    }

    public Font getChosenFont() {
        int inx = this.mStyleCB.getSelectedIndex();
        int style = inx == 0 ? 0 : (inx == 1 ? 1 : 2);
        Font result = new Font((String)this.mFontCB.getSelectedItem(), style, (Integer)this.mSizeSpinner.getValue());
        return result;
    }
}

