/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tvbrowser.core.Settings;

public class LocalizerClassloader
extends ClassLoader {
    private static final Logger mLog = Logger.getLogger(LocalizerClassloader.class.getName());

    public LocalizerClassloader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            File file = new File(Settings.getUserSettingsDirName() + "/lang/" + name);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    mLog.log(Level.WARNING, "Could not open language properties found in user settings directory.", e);
                }
            }
            if ((file = new File("lang/" + name)).exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    mLog.log(Level.WARNING, "Could not open language properties found in program directory.", e);
                }
            }
            int propertyIndex = name.indexOf(".properties");
            int localeIndex = name.indexOf("_");
            if (localeIndex != -1) {
                String locale = name.substring(localeIndex, propertyIndex);
                File zip = new File(Settings.getUserSettingsDirName() + "/languages/tvbrowser-translation" + locale + ".zip");
                if (!zip.isFile()) {
                    zip = new File("/languages/tvbrowser-translation" + locale + ".zip");
                }
                if (zip.isFile()) {
                    ZipFile zipFile = new ZipFile(zip);
                    ZipEntry entry = zipFile.getEntry(name);
                    if (entry == null) {
                        entry = zipFile.getEntry(name.replace("/", "\\"));
                    }
                    if (entry != null) {
                        return zipFile.getInputStream(entry);
                    }
                }
            }
        }
        catch (Throwable e) {
            mLog.log(Level.SEVERE, "Could not load user defined language properties, using default instead.", e);
        }
        return this.getParent().getResourceAsStream(name);
    }
}

