/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginManager;
import devplugin.Program;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateListener;
import util.exc.TvBrowserException;
import util.programkeyevent.ProgramKeyAndContextMenuListener;
import util.programkeyevent.ProgramKeyEventHandler;
import util.programmouseevent.ProgramMouseAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.ProgramListCellRenderer;
import util.ui.ProgramPanel;

public class ProgramList
extends JList
implements ChangeListener,
ListDataListener,
PluginStateListener,
ProgramMouseAndContextMenuListener,
ProgramKeyAndContextMenuListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramList.class);
    public static final String DATE_SEPARATOR = "DATE_SEPARATOR";
    private Vector<Program> mPrograms = new Vector();
    private boolean mSeparatorsCreated = false;
    private ProgramMouseEventHandler mMouseEventHandler;
    private ContextMenuIf mCaller;
    private ProgramKeyEventHandler mKeyEventHandler;
    private JPopupMenu mPopupMenu;

    public ProgramList(Vector<Program> programArr) {
        this(programArr, new PluginPictureSettings(0));
    }

    public ProgramList(Program[] programArr) {
        this(programArr, new PluginPictureSettings(0));
    }

    public ProgramList(ListModel programs) {
        this(programs, new PluginPictureSettings(0));
    }

    public ProgramList(Vector<Program> programVector, ProgramPanelSettings settings) {
        super(programVector);
        this.initialize(settings);
    }

    private void initialize(ProgramPanelSettings settings) {
        this.setCellRenderer(new ProgramListCellRenderer(settings));
        this.setToolTipText("");
    }

    public ProgramList(Program[] programArr, ProgramPanelSettings settings) {
        super(programArr);
        this.initialize(settings);
    }

    public ProgramList(ListModel programs, ProgramPanelSettings settings) {
        super(programs);
        programs.addListDataListener(this);
        this.initialize(settings);
    }

    public ProgramList(Vector<Program> programVector, PluginPictureSettings settings) {
        this(programVector, new ProgramPanelSettings(settings, false));
    }

    public ProgramList(Program[] programArr, PluginPictureSettings settings) {
        this(programArr, new ProgramPanelSettings(settings, false));
    }

    public ProgramList(ListModel programs, PluginPictureSettings settings) {
        this(programs, new ProgramPanelSettings(settings, false));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeFromPrograms();
        this.addToPrograms();
        PluginProxyManager.getInstance().addPluginStateListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeFromPrograms();
        PluginProxyManager.getInstance().removePluginStateListener(this);
    }

    private void removeFromPrograms() {
        this.removeFromPrograms(0, this.mPrograms.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromPrograms(int indexFirst, int indexLast) {
        Vector<Program> vector = this.mPrograms;
        synchronized (vector) {
            while (indexFirst >= this.mPrograms.size()) {
                indexFirst = this.mPrograms.size() - 1;
            }
            while (indexLast >= this.mPrograms.size()) {
                indexLast = this.mPrograms.size() - 1;
            }
            if (indexFirst >= 0) {
                for (int i = indexLast; i >= indexFirst; --i) {
                    this.mPrograms.remove(i).removeChangeListener(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPrograms() {
        ListModel list;
        ListModel listModel = list = this.getModel();
        synchronized (listModel) {
            this.addToPrograms(0, list.getSize() - 1, list);
        }
    }

    private void addToPrograms(int indexFirst, int indexLast, ListModel list) {
        if (list.getSize() > indexLast) {
            for (int i = indexFirst; i <= indexLast; ++i) {
                Object element = list.getElementAt(i);
                if (!(element instanceof Program)) continue;
                Program prg = (Program)element;
                prg.addChangeListener(this);
                this.mPrograms.add(prg);
            }
        }
    }

    public void addMouseListeners(ContextMenuIf caller) {
        this.addMouseAndKeyListeners(caller);
    }

    public void addMouseAndKeyListeners(ContextMenuIf caller) {
        if (this.mMouseEventHandler == null) {
            this.mMouseEventHandler = new ProgramMouseEventHandler(this, caller);
            this.addMouseListener(this.mMouseEventHandler);
            this.mCaller = caller;
        }
        if (this.mKeyEventHandler == null) {
            this.mCaller = caller;
            this.mKeyEventHandler = new ProgramKeyEventHandler(this, caller);
            this.addKeyListener(this.mKeyEventHandler);
        }
    }

    private void showPopup(Point p, ContextMenuIf caller) {
        if (this.mPopupMenu != null && this.mPopupMenu.isVisible()) {
            this.mPopupMenu.setVisible(false);
        } else {
            PluginManager mng = Plugin.getPluginManager();
            int inx = this.locationToIndex(p);
            this.setSelectedIndex(inx);
            if (this.getModel().getElementAt(inx) instanceof Program) {
                Program prog = (Program)this.getModel().getElementAt(inx);
                this.mPopupMenu = mng.createPluginContextMenu(prog, caller);
                this.mPopupMenu.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close window");
                this.mPopupMenu.getInputMap(2).put(KeyStroke.getKeyStroke(82, 0), "close window");
                this.mPopupMenu.getInputMap(2).put(KeyStroke.getKeyStroke(525, 0), "close window");
                this.mPopupMenu.getActionMap().put("close window", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgramList.this.mPopupMenu.setVisible(false);
                    }
                });
                this.mPopupMenu.show(this, p.x - 15, p.y - 15);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.removeFromPrograms();
        this.addToPrograms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalAdded(ListDataEvent e) {
        ListModel list;
        ListModel listModel = list = this.getModel();
        synchronized (listModel) {
            this.addToPrograms(e.getIndex0(), e.getIndex1(), list);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.removeFromPrograms(e.getIndex0(), e.getIndex1());
    }

    public Program[] getSelectedPrograms() {
        Object[] o = this.getSelectedValues();
        if (o == null || o.length == 0) {
            return null;
        }
        if (this.mSeparatorsCreated) {
            ArrayList<Program> progs = new ArrayList<Program>(o.length);
            for (Object p : o) {
                if (!(p instanceof Program)) continue;
                progs.add((Program)p);
            }
            return progs.toArray(new Program[progs.size()]);
        }
        Program[] p = new Program[o.length];
        for (int i = 0; i < o.length; ++i) {
            p[i] = (Program)o[i];
        }
        return p;
    }

    @Override
    public void pluginActivated(PluginProxy plugin) {
        if (plugin.getProgramTableIcons(Plugin.getPluginManager().getExampleProgram()) != null) {
            this.updatePrograms();
        }
    }

    @Override
    public void pluginDeactivated(PluginProxy plugin) {
        this.updatePrograms();
    }

    private void updatePrograms() {
        this.repaint();
    }

    @Override
    public void pluginLoaded(PluginProxy plugin) {
    }

    @Override
    public void pluginUnloaded(PluginProxy plugin) {
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Rectangle bounds;
        Point point = event.getPoint();
        int index = this.locationToIndex(point);
        if (index >= 0 && (bounds = this.getCellBounds(index, index)) != null) {
            Container container;
            int x = point.x - bounds.x;
            int y = point.y - bounds.y;
            Component component = this.getCellRenderer().getListCellRendererComponent(this, this.getModel().getElementAt(index), index, false, false);
            if (component != null && component instanceof Container && (component = (container = (Container)component).getComponent(1)) != null && component instanceof ProgramPanel) {
                ProgramPanel panel = (ProgramPanel)component;
                return panel.getToolTipText(x -= panel.getX(), y -= panel.getY());
            }
        }
        return null;
    }

    public void addDateSeparators() throws TvBrowserException {
        DefaultListModel<Object> newModel;
        if (this.getModel() instanceof DefaultListModel) {
            this.mSeparatorsCreated = true;
            newModel = new DefaultListModel<Object>();
            Program previous = null;
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                Object o = this.getModel().getElementAt(i);
                if (!(o instanceof Program)) continue;
                Program prog = (Program)o;
                if (previous == null || prog.getDate().compareTo(previous.getDate()) > 0) {
                    newModel.addElement(DATE_SEPARATOR);
                }
                newModel.addElement(prog);
                previous = prog;
            }
        } else {
            throw new TvBrowserException(ProgramList.class, "unsupportedListModel", "Used ListModel not supported.");
        }
        super.setModel(newModel);
    }

    public void setModel(ListModel model) {
        this.mSeparatorsCreated = false;
        super.setModel(model);
    }

    public void scrollToNextDateIfAvailable(Date date) {
        for (int i = 0; i < super.getModel().getSize(); ++i) {
            Object test = super.getModel().getElementAt(i);
            if (!(test instanceof Program) || date.compareTo(((Program)test).getDate()) != 0) continue;
            Point p = this.indexToLocation(i - (this.mSeparatorsCreated ? 1 : 0));
            if (this.getVisibleRect() != null) {
                super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                this.repaint();
            }
            return;
        }
    }

    public void scrollToTimeFromCurrentViewIfAvailable(int time) {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1) {
                boolean down;
                Date current = ((Program)o).getDate();
                int i = index + 1;
                boolean bl = down = time <= ((Program)o).getStartTime();
                if (down) {
                    i = index - 1;
                }
                Point scrollPoint = null;
                if (down && ((Program)o).getStartTime() == time) {
                    scrollPoint = i > 0 && this.getModel().getElementAt(i) instanceof String ? this.indexToLocation(i) : this.indexToLocation(i + 1);
                }
                while (down ? i >= 0 : i < super.getModel().getSize()) {
                    Object test = super.getModel().getElementAt(i);
                    if (test instanceof Program) {
                        Program prog = (Program)test;
                        int startTime = prog.getStartTime();
                        if (prog.getDate().compareTo(current) == 0) {
                            if (down ? startTime < time : startTime >= time) {
                                if (scrollPoint != null) break;
                                if (i > 0 && this.getModel().getElementAt(i - 1) instanceof String || startTime > time) {
                                    scrollPoint = this.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = this.indexToLocation(i);
                                break;
                            }
                            if (down && startTime == time) {
                                if (i > 0 && this.getModel().getElementAt(i - 1) instanceof String) {
                                    scrollPoint = this.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = this.indexToLocation(i);
                            }
                        } else if (scrollPoint == null) {
                            if (down && i < this.getModel().getSize() - 1) {
                                scrollPoint = this.indexToLocation(i + 1);
                                break;
                            }
                            if (!down && i > 0) {
                                scrollPoint = this.indexToLocation(i - 1);
                                break;
                            }
                            scrollPoint = this.indexToLocation(i);
                            break;
                        }
                    } else if (test instanceof String && scrollPoint == null) {
                        if (down || i == 0) {
                            scrollPoint = this.indexToLocation(i);
                            break;
                        }
                        scrollPoint = this.indexToLocation(i - 1);
                        break;
                    }
                    if (down) {
                        --i;
                        continue;
                    }
                    ++i;
                }
                if (scrollPoint == null) {
                    if (down) {
                        if (this.getModel().getSize() > 0) {
                            scrollPoint = this.indexToLocation(0);
                        }
                    } else if (this.getModel().getSize() > 0) {
                        scrollPoint = this.indexToLocation(this.getModel().getSize() - 1);
                    }
                }
                if (scrollPoint != null && this.getVisibleRect() != null) {
                    super.scrollRectToVisible(new Rectangle(scrollPoint.x, scrollPoint.y, 1, this.getVisibleRect().height));
                    this.repaint();
                }
            }
        }
    }

    public void scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable(int time) {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1 && ((Program)o).getStartTime() != time) {
                Date current = ((Program)o).getDate();
                if (((Program)o).getStartTime() > time) {
                    time += 1440;
                }
                for (int i = index + 1; i < super.getModel().getSize(); ++i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program)) continue;
                    Program prog = (Program)test;
                    int startTime = prog.getStartTime();
                    if (prog.getDate().compareTo(current) > 0) {
                        startTime += 1440;
                    }
                    if (prog.getDate().compareTo(current) < 0 || startTime < time) continue;
                    Point p = this.indexToLocation(i);
                    if (i > 0 && this.getModel().getElementAt(i - 1) instanceof String || startTime > time) {
                        p = this.indexToLocation(i - 1);
                    }
                    if (this.getVisibleRect() != null) {
                        super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                        this.repaint();
                    }
                    return;
                }
            }
        }
    }

    public void scrollToNextDayIfAvailable() {
        int index = this.locationToIndex(this.getVisibleRect().getLocation());
        if (index < this.getModel().getSize() - 1) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < super.getModel().getSize() - 1) {
                Date current = ((Program)o).getDate();
                for (int i = index + 1; i < super.getModel().getSize(); ++i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) >= 0) continue;
                    Point p = this.indexToLocation(i - (this.mSeparatorsCreated ? 1 : 0));
                    if (this.getVisibleRect() != null) {
                        super.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.getVisibleRect().height));
                    }
                    return;
                }
            }
        }
    }

    public void scrollToPreviousDayIfAvailable() {
        int index = this.locationToIndex(this.getVisibleRect().getLocation()) - 1;
        if (index > 0) {
            Object o = super.getModel().getElementAt(index);
            if (o instanceof String) {
                o = super.getModel().getElementAt(index - 1);
                --index;
            }
            if (index > 0) {
                Date current = ((Program)o).getDate();
                for (int i = index - 1; i >= 0; --i) {
                    Object test = super.getModel().getElementAt(i);
                    if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) <= 0) continue;
                    super.ensureIndexIsVisible(i + 1);
                    return;
                }
            }
        }
        if (this.getModel().getSize() > 0) {
            super.ensureIndexIsVisible(0);
        }
    }

    public int getNewIndexForOldIndex(int index) {
        if (this.mSeparatorsCreated) {
            for (int i = 0; i < Math.min(index, this.mPrograms.size()); ++i) {
                if (!(this.getModel().getElementAt(i) instanceof String)) continue;
                ++index;
            }
        }
        return index;
    }

    public static String getPreviousActionTooltip() {
        return mLocalizer.msg("prevTooltip", "Scrolls to previous day from current view position (if there is previous day in the list)");
    }

    public static String getNextActionTooltip() {
        return mLocalizer.msg("nextTooltip", "Scrolls to next day from current view position (if there is next day in the list)");
    }

    @Override
    public Program getProgramForMouseEvent(MouseEvent e) {
        Object element;
        int inx = this.locationToIndex(e.getPoint());
        if (inx >= 0 && (element = this.getModel().getElementAt(inx)) instanceof Program) {
            return (Program)element;
        }
        return null;
    }

    @Override
    public void mouseEventActionFinished() {
    }

    @Override
    public void showContextMenu(MouseEvent e) {
        this.showPopup(e.getPoint(), this.mCaller);
    }

    @Override
    public Program getProgramForKeyEvent(KeyEvent e) {
        Object program = this.getSelectedValue();
        if (program instanceof Program) {
            return (Program)program;
        }
        return null;
    }

    @Override
    public void keyEventActionFinished() {
    }

    @Override
    public void showContextMenu(Program program) {
        this.showPopup(this.indexToLocation(this.getSelectedIndex()), this.mCaller);
    }
}

