/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFilter;
import devplugin.ProgramSearcher;
import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.extras.searchplugin.SearchDialog;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;
import util.ui.ProgramList;
import util.ui.SearchFormSettings;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SearchHelper {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchHelper.class);
    private static SearchHelper mInstance;
    private DefaultListModel mListModel = null;
    private ProgressMonitor mProgressMonitor;
    private JProgressBar mProgressBar;
    private ProgramList mProgramList;
    private JDialog mDialog = null;
    private JScrollPane mProgramListScrollPane;
    private JComboBox mFilterSelection;

    private SearchHelper() {
    }

    public static void search(Component comp, SearchFormSettings settings, ProgramPanelSettings pictureSettings) {
        SearchHelper.search(comp, settings, pictureSettings, false);
    }

    public static void search(Component comp, SearchFormSettings settings, ProgramPanelSettings pictureSettings, boolean showDialog) {
        if (mInstance == null) {
            mInstance = new SearchHelper();
        }
        if (pictureSettings == null) {
            pictureSettings = new ProgramPanelSettings(new PluginPictureSettings(0), false);
        }
        mInstance.doSearch(comp, settings, pictureSettings, showDialog);
    }

    public static void search(Component comp, PluginPictureSettings pictureSettings, SearchFormSettings settings, boolean showDialog) {
        SearchHelper.search(comp, settings, new ProgramPanelSettings(pictureSettings, false), showDialog);
    }

    public static void search(Component comp, PluginPictureSettings pictureSettings, SearchFormSettings settings) {
        SearchHelper.search(comp, settings, new ProgramPanelSettings(pictureSettings, false));
    }

    public static void search(Component comp, SearchFormSettings settings) {
        SearchHelper.search(comp, settings, null);
    }

    private void doSearch(final Component comp, final SearchFormSettings searcherSettings, final ProgramPanelSettings pictureSettings, final boolean showDialog) {
        if (showDialog) {
            this.mDialog = this.createHitsDialog(comp, new Program[0], mLocalizer.msg("search", "Search"), searcherSettings, pictureSettings);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    Date startDate = new Date();
                    Cursor cursor = comp.getCursor();
                    try {
                        comp.setCursor(Cursor.getPredefinedCursor(3));
                        ProgramSearcher searcher = searcherSettings.createSearcher();
                        ProgressMonitor progressMonitor = null;
                        if (SearchHelper.this.mProgressMonitor == null && !TvDataUpdater.getInstance().isDownloading()) {
                            progressMonitor = MainFrame.getInstance().getStatusBar().createProgressMonitor();
                            progressMonitor.setMessage(mLocalizer.msg("searching", "Searching"));
                        }
                        Program[] programArr = searcher.search(searcherSettings.getFieldTypes(), startDate, searcherSettings.getNrDays(), searcherSettings.getChannels(), true, SearchHelper.this.mProgressMonitor != null ? SearchHelper.this.mProgressMonitor : progressMonitor, SearchHelper.this.mListModel);
                        comp.setCursor(cursor);
                        if (programArr.length == 0) {
                            UIThreadRunner.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String msg = mLocalizer.msg("nothingFound", "No programs found with {0}!", searcherSettings.getSearchText());
                                    JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg);
                                    if (SearchHelper.this.mDialog != null) {
                                        SearchHelper.this.mDialog.setVisible(false);
                                        SearchHelper.this.mDialog = null;
                                    }
                                }
                            });
                            break block6;
                        }
                        SearchHelper.this.mFilterSelection.setEnabled(true);
                        if (!showDialog) {
                            String title = mLocalizer.msg("hitsTitle", "Programs with {0}", searcherSettings.getSearchText());
                            UiUtilities.centerAndShow(SearchHelper.this.createHitsDialog(comp, programArr, title, searcherSettings, pictureSettings));
                            SearchHelper.this.mDialog = null;
                            break block6;
                        }
                        if (SearchHelper.this.mProgressBar == null) break block6;
                        SearchHelper.this.mProgressBar.setVisible(false);
                        UIThreadRunner.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchHelper.this.mProgramList.updateUI();
                            }
                        });
                        if (SearchHelper.this.mProgramList.getSelectedIndex() != -1 || SearchHelper.this.mProgramListScrollPane.getVerticalScrollBar().getValue() != 0) break block6;
                        for (int i = 0; i < SearchHelper.this.mProgramList.getModel().getSize(); ++i) {
                            Object value = SearchHelper.this.mProgramList.getModel().getElementAt(i);
                            if (!(value instanceof Program) || ((Program)value).isExpired()) continue;
                            final int scrollIndex = i;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SearchHelper.this.mProgramListScrollPane.getVerticalScrollBar().setValue(0);
                                    SearchHelper.this.mProgramListScrollPane.getHorizontalScrollBar().setValue(0);
                                    if (scrollIndex != -1) {
                                        Rectangle cellBounds = SearchHelper.this.mProgramList.getCellBounds(scrollIndex, scrollIndex);
                                        cellBounds.setLocation(cellBounds.x, cellBounds.y - ((SearchHelper)SearchHelper.this).mProgramListScrollPane.getBorder().getBorderInsets((Component)((SearchHelper)SearchHelper.this).mProgramListScrollPane).top - ((SearchHelper)SearchHelper.this).mProgramListScrollPane.getInsets().top + SearchHelper.this.mProgramListScrollPane.getHeight() - cellBounds.height);
                                        SearchHelper.this.mProgramList.scrollRectToVisible(cellBounds);
                                    }
                                }
                            });
                            break;
                        }
                    }
                    catch (TvBrowserException exc) {
                        comp.setCursor(cursor);
                        ErrorHandler.handle(exc);
                    }
                }
            }
        }, "Search programs").start();
        if (this.mDialog != null) {
            UiUtilities.centerAndShow(this.mDialog);
            this.mDialog = null;
        }
    }

    private JDialog createHitsDialog(Component comp, Program[] programArr, String title, final SearchFormSettings searchSettings, ProgramPanelSettings pictureSettings) {
        final Window parentWindow = UiUtilities.getBestDialogParent(comp);
        final JDialog dlg = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow, title, true) : new JDialog((Dialog)parentWindow, title, true);
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                dlg.dispose();
            }

            @Override
            public JRootPane getRootPane() {
                return dlg.getRootPane();
            }
        });
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder("default:grow");
        pb.border(Borders.DIALOG);
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)pb.getPanel(), "Center");
        int curPos = -1;
        for (int i = 0; i < programArr.length && curPos == -1; ++i) {
            if (programArr[i].isExpired()) continue;
            curPos = i;
        }
        this.mListModel = new DefaultListModel();
        for (Program program : programArr) {
            this.mListModel.addElement(program);
        }
        if (programArr.length == 0) {
            this.mProgressBar = new JProgressBar();
            this.mProgressMonitor = new ProgressMonitor(){

                @Override
                public void setMaximum(final int maximum) {
                    UIThreadRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchHelper.this.mProgressBar.setMaximum(maximum);
                        }
                    });
                }

                @Override
                public void setMessage(String msg) {
                }

                @Override
                public void setValue(final int value) {
                    UIThreadRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SearchHelper.this.mProgressBar.setValue(value);
                        }
                    });
                }
            };
            pb.addRow();
            pb.add((Component)this.mProgressBar, CC.xy(1, pb.getRow()));
        }
        this.mFilterSelection = new JComboBox<ProgramFilter>(FilterManagerImpl.getInstance().getAvailableFilters());
        this.mFilterSelection.setSelectedItem(FilterManagerImpl.getInstance().getAllFilter());
        this.mFilterSelection.setEnabled(false);
        this.mFilterSelection.addItemListener(new ItemListener(){
            private Program[] mPrograms;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (this.mPrograms == null) {
                        this.mPrograms = new Program[SearchHelper.this.mListModel.size()];
                        SearchHelper.this.mListModel.copyInto(this.mPrograms);
                    }
                    SearchHelper.this.mListModel.clear();
                    ProgramFilter progFilter = (ProgramFilter)e.getItem();
                    for (Program p : this.mPrograms) {
                        if (!progFilter.accept(p)) continue;
                        SearchHelper.this.mListModel.addElement(p);
                    }
                }
            }
        });
        JPanel filter = new JPanel(new FormLayout("default,3dlu,default:grow", "default"));
        filter.add((Component)new JLabel("Filter:"), CC.xy(1, 1));
        filter.add((Component)this.mFilterSelection, CC.xy(3, 1));
        pb.addRow(false);
        pb.add((Component)filter, CC.xy(1, pb.getRow()));
        this.mProgramList = new ProgramList((ListModel)this.mListModel, pictureSettings);
        this.mProgramList.addMouseAndKeyListeners(null);
        this.mProgramListScrollPane = new JScrollPane(this.mProgramList);
        pb.addGrowingRow();
        pb.add((Component)this.mProgramListScrollPane, CC.xy(1, pb.getRow()));
        if (curPos >= 0) {
            this.mProgramList.setSelectedValue(programArr[curPos], true);
        }
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRight(true);
        builder.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        ImageIcon icon = TVBrowserIcons.copy(16);
        final JButton sendBt = new JButton(icon);
        sendBt.setEnabled(false);
        sendBt.setToolTipText(mLocalizer.msg("send", "Send Programs to another Plugin"));
        sendBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Program[] program = SearchHelper.this.mProgramList.getSelectedPrograms();
                if (program == null) {
                    program = new Program[SearchHelper.this.mListModel.size()];
                    for (int programIndex = 0; programIndex < SearchHelper.this.mListModel.size(); ++programIndex) {
                        program[programIndex] = (Program)SearchHelper.this.mListModel.getElementAt(programIndex);
                    }
                }
                SendToPluginDialog send = new SendToPluginDialog(null, (Window)MainFrame.getInstance(), program);
                send.setVisible(true);
            }
        });
        builder.addFixed(sendBt);
        this.mListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                sendBt.setEnabled(true);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        if (!(comp instanceof SearchDialog)) {
            icon = TVBrowserIcons.edit(16);
            JButton changeBt = new JButton(icon);
            changeBt.setToolTipText(mLocalizer.msg("edit", "Change search parameters"));
            changeBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    dlg.dispose();
                    SearchDialog searchDialog = new SearchDialog(parentWindow);
                    searchDialog.setSearchSettings(searchSettings);
                    UiUtilities.centerAndShow(searchDialog);
                }
            });
            builder.addRelatedGap();
            builder.addFixed(changeBt);
        }
        JButton closeBt = new JButton(Localizer.getLocalization("i18n_close"));
        closeBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dlg.dispose();
            }
        });
        builder.addGlue();
        builder.addFixed(closeBt);
        pb.addRow();
        pb.add((Component)builder.getPanel(), CC.xy(1, pb.getRow()));
        dlg.getRootPane().setDefaultButton(closeBt);
        Settings.layoutWindow("searchDlg", dlg, new Dimension(400, 400));
        return dlg;
    }
}

