/*
 * Decompiled with CFR 0.152.
 */
package util.ui.customizableitems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.CustomizableItemsListener;

public class CustomizableItemsPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(CustomizableItemsPanel.class);
    private final DefaultListModel mLeftListModel;
    private final DefaultListModel mRightListModel;
    private final JList mLeftList;
    private final JList mRightList;
    private JLabel mRightLabel;
    private JLabel mLeftLabel;
    private JButton mRightBt;
    private JButton mLeftBt;
    private JButton mUpBt;
    private JButton mDownBt;
    private ArrayList<CustomizableItemsListener> mListeners = new ArrayList();

    public CustomizableItemsPanel(String leftText, String rightText) {
        super(new GridLayout(1, 2));
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.mLeftListModel = new DefaultListModel();
        this.mLeftList = new JList(this.mLeftListModel);
        this.mLeftList.setVisibleRowCount(10);
        this.mLeftList.setSelectionMode(2);
        this.mLeftList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomizableItemsPanel.this.updateEnabled();
            }
        });
        this.mRightListModel = new DefaultListModel();
        this.mRightList = new JList(this.mRightListModel);
        this.mRightList.setVisibleRowCount(10);
        this.mRightList.setSelectionMode(2);
        this.mRightList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomizableItemsPanel.this.updateEnabled();
            }
        });
        this.mLeftList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CustomizableItemsPanel.this.fireLeftListSelectionChanged(e);
            }
        });
        this.mRightList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CustomizableItemsPanel.this.fireRightListSelectionChanged(e);
            }
        });
        this.mLeftLabel = new JLabel(leftText);
        this.mRightLabel = new JLabel(rightText);
        this.mLeftLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.mRightLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        leftPanel.add((Component)this.mLeftLabel, "North");
        rightPanel.add((Component)this.mRightLabel, "North");
        leftPanel.add((Component)new JScrollPane(this.mLeftList), "Center");
        rightPanel.add((Component)new JScrollPane(this.mRightList), "Center");
        JPanel leftButtons = new JPanel(new GridLayout(2, 1));
        JPanel rightButtons = new JPanel(new GridLayout(2, 1));
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel panel3 = new JPanel(new BorderLayout());
        JPanel panel4 = new JPanel(new BorderLayout());
        JPanel panel5 = new JPanel(new BorderLayout());
        this.mRightBt = new JButton(TVBrowserIcons.right(22));
        String msg = mLocalizer.msg("tooltip.right", "Move selected rows in right list");
        this.mRightBt.setToolTipText(msg);
        this.mRightBt.setMargin(UiUtilities.ZERO_INSETS);
        this.mLeftBt = new JButton(TVBrowserIcons.left(22));
        msg = mLocalizer.msg("tooltip.left", "Move selected rows in left list");
        this.mLeftBt.setToolTipText(msg);
        this.mLeftBt.setMargin(UiUtilities.ZERO_INSETS);
        this.mUpBt = new JButton(TVBrowserIcons.up(22));
        msg = mLocalizer.msg("tooltip.up", "Move selected rows up");
        this.mUpBt.setToolTipText(msg);
        this.mUpBt.setMargin(UiUtilities.ZERO_INSETS);
        this.mDownBt = new JButton(TVBrowserIcons.down(22));
        msg = mLocalizer.msg("tooltip.down", "Move selected rows down");
        this.mDownBt.setToolTipText(msg);
        this.mDownBt.setMargin(UiUtilities.ZERO_INSETS);
        panel2.add((Component)this.mRightBt, "South");
        panel3.add((Component)this.mLeftBt, "North");
        panel4.add((Component)this.mUpBt, "South");
        panel5.add((Component)this.mDownBt, "North");
        leftButtons.add(panel2);
        leftButtons.add(panel3);
        rightButtons.add(panel4);
        rightButtons.add(panel5);
        leftButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        rightButtons.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        leftPanel.add((Component)leftButtons, "East");
        rightPanel.add((Component)rightButtons, "East");
        this.add(leftPanel);
        this.add(rightPanel);
        this.mRightBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] items = UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mLeftList, CustomizableItemsPanel.this.mRightList);
                if (items != null && items.length > 0) {
                    CustomizableItemsPanel.this.fireItemTransferredToRightList(items);
                }
            }
        });
        this.mLeftBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] items = UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mRightList, CustomizableItemsPanel.this.mLeftList);
                if (items != null && items.length > 0) {
                    CustomizableItemsPanel.this.fireItemTransferredToLeftList(items);
                }
            }
        });
        this.mLeftList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object[] items;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (items = UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mLeftList, CustomizableItemsPanel.this.mRightList)) != null && items.length > 0) {
                    CustomizableItemsPanel.this.fireItemTransferredToRightList(items);
                }
            }
        });
        this.mRightList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object[] items;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (items = UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mRightList, CustomizableItemsPanel.this.mLeftList)) != null && items.length > 0) {
                    CustomizableItemsPanel.this.fireItemTransferredToLeftList(items);
                }
            }
        });
        this.mUpBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mRightList, -1);
            }
        });
        this.mDownBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UiUtilities.moveSelectedItems(CustomizableItemsPanel.this.mRightList, 1);
            }
        });
        this.updateEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mLeftList.setEnabled(enabled);
        this.mRightList.setEnabled(enabled);
        this.mRightBt.setEnabled(enabled);
        this.mLeftBt.setEnabled(enabled);
        this.mUpBt.setEnabled(enabled);
        this.mDownBt.setEnabled(enabled);
        this.mRightLabel.setEnabled(enabled);
        this.mLeftLabel.setEnabled(enabled);
    }

    public void clearLeft() {
        this.mLeftListModel.clear();
    }

    public void clearRight() {
        this.mRightListModel.clear();
    }

    public JList getLeftList() {
        return this.mLeftList;
    }

    public JList getRightList() {
        return this.mRightList;
    }

    public void addElementLeft(Object item) {
        this.mLeftListModel.addElement(item);
    }

    public void addElementRight(Object item) {
        this.mRightListModel.addElement(item);
    }

    public void insertElementLeft(int index, Object item) {
        this.mLeftListModel.add(index, item);
    }

    public void insertElementRight(int index, Object item) {
        this.mRightListModel.add(index, item);
    }

    public void setElementsLeft(Object[] items) {
        this.mLeftListModel.clear();
        for (Object item : items) {
            this.mLeftListModel.addElement(item);
        }
    }

    public void setElementsRight(Object[] items) {
        this.mRightListModel.clear();
        for (Object item : items) {
            this.mRightListModel.addElement(item);
        }
    }

    public Object[] getElementsLeft() {
        return this.mLeftListModel.toArray();
    }

    public Object[] getElementsRight() {
        return this.mRightListModel.toArray();
    }

    public Object getElementAtRight(int inx) {
        return this.mRightListModel.getElementAt(inx);
    }

    public Object getElementAtLeft(int inx) {
        return this.mLeftListModel.getElementAt(inx);
    }

    public void removeLeft(Object o) {
        this.mLeftListModel.removeElement(o);
    }

    public void removeRight(Object o) {
        this.mRightListModel.removeElement(o);
    }

    public Object getLeftSelection() {
        return this.mLeftList.getSelectedValue();
    }

    public Object getRightSelection() {
        return this.mRightList.getSelectedValue();
    }

    public Object[] getRightSelections() {
        return this.getSelectedValues(this.mRightList);
    }

    public Object[] getLeftSelections() {
        return this.getSelectedValues(this.mLeftList);
    }

    private Object[] getSelectedValues(JList list) {
        int[] inx = list.getSelectedIndices();
        Object[] res = new Object[inx.length];
        for (int i = 0; i < inx.length; ++i) {
            res[i] = list.getModel().getElementAt(inx[i]);
        }
        return res;
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.mLeftList.setCellRenderer(renderer);
        this.mRightList.setCellRenderer(renderer);
    }

    public void addCustomizableItemsListener(CustomizableItemsListener listener) {
        this.mListeners.add(listener);
    }

    private void fireLeftListSelectionChanged(ListSelectionEvent e) {
        for (CustomizableItemsListener listener : this.mListeners) {
            listener.leftListSelectionChanged(e);
        }
    }

    private void fireRightListSelectionChanged(ListSelectionEvent e) {
        for (CustomizableItemsListener listener : this.mListeners) {
            listener.rightListSelectionChanged(e);
        }
    }

    private void fireItemTransferredToLeftList(Object[] items) {
        for (CustomizableItemsListener listener : this.mListeners) {
            listener.itemsTransferredToLeftList(items);
        }
    }

    private void fireItemTransferredToRightList(Object[] items) {
        for (CustomizableItemsListener listener : this.mListeners) {
            listener.itemsTransferredToRightList(items);
        }
    }

    public static CustomizableItemsPanel createCustomizableItemsPanel(String leftText, String rightText) {
        return new CustomizableItemsPanel(leftText, rightText);
    }

    private void updateEnabled() {
        this.mRightBt.setEnabled(this.mLeftList.getSelectedIndex() != -1);
        this.mLeftBt.setEnabled(this.mRightList.getSelectedIndex() != -1);
        this.mUpBt.setEnabled(this.mRightList.getMinSelectionIndex() > 0);
        int maxIdx = this.mRightList.getMaxSelectionIndex();
        this.mDownBt.setEnabled(maxIdx != -1 && maxIdx < this.mRightListModel.getSize() - 1);
    }
}

