/*
 * Decompiled with CFR 0.152.
 */
package util.ui.findasyoutype;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import tvbrowser.core.icontheme.IconLoader;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.findasyoutype.FindAction;

public class TextComponentFindAction
extends FindAction
implements FocusListener,
ComponentListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TextComponentFindAction.class);
    private JPanel mSearchBar;
    private JButton mFindNext;
    private JButton mFindPrev;
    private JButton mSearchCloseBtn;

    public TextComponentFindAction(JTextComponent comp) {
        super(comp, false);
        this.ini();
    }

    public TextComponentFindAction(JTextComponent comp, boolean startAtKeyType) {
        super(comp, startAtKeyType);
        this.ini();
    }

    private void ini() {
        PanelBuilder b = new PanelBuilder(new FormLayout("2dlu,pref,5dlu,pref,5dlu,100dlu,5dlu,pref,5dlu,pref,15dlu,pref", "pref,3dlu"));
        CellConstraints cc = new CellConstraints();
        this.mSearchBar = b.getPanel();
        this.mSearchBar.addComponentListener(this);
        this.mSearchBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.mSearchBar.getBackground().darker()));
        this.mSearchCloseBtn = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
        this.mSearchCloseBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mSearchCloseBtn.setPressedIcon(IconLoader.getInstance().getIconFromTheme("actions", "close-pressed", 16));
        this.mSearchCloseBtn.setToolTipText(mLocalizer.msg("closeToolTip", "Close Find bar"));
        this.mSearchCloseBtn.setContentAreaFilled(false);
        this.mSearchCloseBtn.setFocusable(false);
        MouseListener[] ml = this.mSearchCloseBtn.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (ml[i] instanceof ToolTipManager) continue;
            this.mSearchCloseBtn.removeMouseListener(ml[i]);
        }
        final JTextField searchField = this.getSearchField();
        this.mFindNext = new JButton(mLocalizer.msg("next", "Find Next"));
        this.mFindNext.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mFindNext.setIcon(TVBrowserIcons.down(16));
        this.mFindNext.setContentAreaFilled(false);
        this.mFindNext.setFocusable(false);
        this.mFindNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentFindAction.this.next();
            }
        });
        this.mFindPrev = new JButton(mLocalizer.msg("prev", "Find Previous"));
        this.mFindPrev.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mFindPrev.setIcon(TVBrowserIcons.up(16));
        this.mFindPrev.setContentAreaFilled(false);
        this.mFindPrev.setFocusable(false);
        this.mFindPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentFindAction.this.prev();
            }
        });
        this.addMouseAdapter(this.mFindNext);
        this.addMouseAdapter(this.mFindPrev);
        this.addMouseAdapter(this.mSearchCloseBtn);
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TextComponentFindAction.this.mFindNext.setEnabled(searchField.getText().length() > 0);
                TextComponentFindAction.this.mFindPrev.setEnabled(searchField.getText().length() > 0);
            }
        });
        b.add((Component)this.mSearchCloseBtn, cc.xy(2, 1));
        b.addLabel(mLocalizer.msg("find", "Find:"), cc.xy(4, 1));
        b.add((Component)searchField, cc.xy(6, 1));
        b.add((Component)this.mFindNext, cc.xy(8, 1));
        b.add((Component)this.mFindPrev, cc.xy(10, 1));
        b.add((Component)this.getMessageLabel(), cc.xy(12, 1));
        AbstractAction close = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TextComponentFindAction.this.mSearchBar.setVisible(false);
                TextComponentFindAction.this.setBlockAutoClosing(false);
                TextComponentFindAction.this.interrupt();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        searchField.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        searchField.getActionMap().put("CLOSE_SEARCH", close);
        this.mFindNext.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        this.mFindNext.getActionMap().put("CLOSE_SEARCH", close);
        this.mFindPrev.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        this.mFindPrev.getActionMap().put("CLOSE_SEARCH", close);
        this.mSearchCloseBtn.getInputMap(0).put(stroke, "CLOSE_SEARCH");
        this.mSearchCloseBtn.getActionMap().put("CLOSE_SEARCH", close);
        this.mSearchBar.setVisible(false);
        this.mSearchCloseBtn.setVisible(false);
    }

    private void addMouseAdapter(JButton button) {
        button.addMouseListener(new MouseAdapter(){
            boolean mOver;
            boolean mPressed;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mOver = true;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    if (b.equals(TextComponentFindAction.this.mFindPrev) || b.equals(TextComponentFindAction.this.mFindNext)) {
                        TextComponentFindAction.this.setBorder(b, this.mPressed);
                    } else if (this.mPressed) {
                        b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "close-pressed", 16));
                    } else {
                        b.setIcon(IconLoader.getInstance().getIconFromTheme("status", "close-over", 16));
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.mOver = false;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    if (b.equals(TextComponentFindAction.this.mFindPrev) || b.equals(TextComponentFindAction.this.mFindNext)) {
                        b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    } else {
                        b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mPressed = true;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    if (b.equals(TextComponentFindAction.this.mFindPrev) || b.equals(TextComponentFindAction.this.mFindNext)) {
                        TextComponentFindAction.this.setBorder(b, true);
                    } else {
                        b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "close-pressed", 16));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mPressed = false;
                JButton b = (JButton)e.getSource();
                if (b.isEnabled()) {
                    if (b.equals(TextComponentFindAction.this.mFindPrev) || b.equals(TextComponentFindAction.this.mFindNext)) {
                        if (this.mOver) {
                            TextComponentFindAction.this.setBorder(b, false);
                        } else {
                            b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                        }
                    } else {
                        b.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
                        if (this.mOver) {
                            TextComponentFindAction.this.mSearchBar.setVisible(false);
                            TextComponentFindAction.this.mSearchCloseBtn.setVisible(false);
                            TextComponentFindAction.this.setBlockAutoClosing(false);
                            TextComponentFindAction.this.interrupt();
                        }
                    }
                }
            }
        });
    }

    private void setBorder(JButton b, boolean pressed) {
        b.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, pressed ? this.mSearchBar.getBackground().darker() : this.mSearchBar.getBackground().brighter()), BorderFactory.createEmptyBorder(1, 1, 0, 0)), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, pressed ? this.mSearchBar.getBackground().brighter() : this.mSearchBar.getBackground().darker()), BorderFactory.createEmptyBorder(0, 0, 1, 1))));
    }

    @Override
    protected void initSearch(ActionEvent ae) {
        this.mSearchBar.removeComponentListener(this);
        this.mSearchBar.setVisible(true);
        this.mSearchCloseBtn.setVisible(true);
        this.mSearchBar.addComponentListener(this);
        super.initSearch(ae);
        this.getSearchField().setText("");
        this.getSearchField().removeFocusListener(this);
        this.getSearchField().addFocusListener(this);
    }

    @Override
    protected boolean changed(JComponent comp, String str, Position.Bias bias) {
        JTextComponent textComp = (JTextComponent)comp;
        int offset = bias == Position.Bias.Forward ? textComp.getCaretPosition() : textComp.getCaret().getMark() - 1;
        int index = this.getNextMatch(textComp, str, offset, bias);
        if (index != -1) {
            textComp.setSelectionStart(index);
            textComp.setSelectionEnd(index + str.length());
            return true;
        }
        offset = bias == null || bias == Position.Bias.Forward ? 0 : textComp.getDocument().getLength();
        index = this.getNextMatch(textComp, str, offset, bias);
        if (index != -1) {
            textComp.select(index, index + str.length());
            return true;
        }
        return false;
    }

    protected int getNextMatch(JTextComponent textComp, String str, int startingOffset, Position.Bias bias) {
        try {
            String text = textComp.getDocument().getText(0, textComp.getDocument().getLength());
            if (this.isIgnoreCase()) {
                str = str.toLowerCase();
                text = text.toLowerCase();
            }
            return bias == null || bias == Position.Bias.Forward ? text.indexOf(str, startingOffset) : text.lastIndexOf(str, startingOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Caret caret = this.getTextComponent().getCaret();
        caret.setVisible(false);
        caret.setSelectionVisible(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public JTextComponent getTextComponent() {
        return (JTextComponent)this.getComponent();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.mSearchCloseBtn.setVisible(false);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.interrupt();
        this.actionPerformed(new ActionEvent(this, 0, "show"));
    }

    @Override
    public void run() {
        try {
            while (this.getWaitTime() > 0) {
                Thread.sleep(100L);
                this.setWaitTime(this.getWaitTime() - 100);
            }
            this.mSearchBar.setVisible(false);
            this.mSearchCloseBtn.setVisible(false);
            this.setWaitTime(5000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void interrupt() {
        if (this.getThread() != null && this.getThread().isAlive()) {
            this.getThread().interrupt();
        }
        this.setWaitTime(5000);
    }

    public JPanel getSearchBar() {
        return this.mSearchBar;
    }

    public void showSearchBar() {
        if (!this.mSearchBar.isVisible()) {
            this.mFindPrev.setEnabled(false);
            this.mFindNext.setEnabled(false);
            this.reset();
        }
        this.setBlockAutoClosing(true);
        this.interrupt();
        this.mSearchBar.setVisible(true);
        this.mSearchCloseBtn.setVisible(true);
        this.getSearchField().requestFocusInWindow();
    }

    public boolean isAlwaysVisible() {
        return this.mSearchBar.isVisible() && this.isBlockAutoClosing();
    }

    public JButton getCloseButton() {
        return this.mSearchCloseBtn;
    }
}

