/*
 * Decompiled with CFR 0.152.
 */
package util.ui.progress;

import devplugin.ProgressMonitor;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import util.ui.progress.ProgressBarProgressMonitor;

public class ProgressMonitorGroup {
    private static final Logger mLog = Logger.getLogger(ProgressMonitorGroup.class.getName());
    private int MAXIMUM = 1000;
    private ProgressMonitor mDelegate;
    private int mTotalWeight;
    private int mUsedWeight;
    private int mCurrentMonitorWeight;
    private int mCurrentMonitorMaximum;

    public ProgressMonitorGroup(ProgressMonitor delegate, int totalWeight) {
        this.mDelegate = delegate;
        this.mTotalWeight = totalWeight;
        this.mDelegate.setMaximum(this.MAXIMUM);
    }

    public ProgressMonitorGroup(JProgressBar progressBar, JLabel label, int totalWeight) {
        this(new ProgressBarProgressMonitor(progressBar, label), totalWeight);
    }

    public ProgressMonitor getNextProgressMonitor(int weight) {
        this.mUsedWeight += this.mCurrentMonitorWeight;
        this.mCurrentMonitorWeight = weight;
        return new ProgressMonitor(){

            @Override
            public void setMaximum(int maximum) {
                ProgressMonitorGroup.this.mCurrentMonitorMaximum = maximum;
            }

            @Override
            public void setValue(int value) {
                ProgressMonitorGroup.this.setCurrentMonitorValue(value);
            }

            @Override
            public void setMessage(String msg) {
                ProgressMonitorGroup.this.mDelegate.setMessage(msg);
            }
        };
    }

    private void setCurrentMonitorValue(int value) {
        if (value < 0 || value > this.mCurrentMonitorMaximum) {
            mLog.severe("Progress value " + value + " is out of range [0.." + this.mCurrentMonitorMaximum + "]");
            return;
        }
        int groupStartValue = this.MAXIMUM * this.mUsedWeight / this.mTotalWeight;
        int groupValue = this.MAXIMUM * this.mCurrentMonitorWeight * value / this.mCurrentMonitorMaximum / this.mTotalWeight;
        int result = groupStartValue + groupValue;
        if (result >= 0) {
            this.mDelegate.setValue(result);
        }
    }
}

