/*
 * Decompiled with CFR 0.152.
 */
package util.ui.progress;

import devplugin.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.progress.Progress;

public class ProgressWindow
implements ProgressMonitor {
    private JLabel mLabel;
    private JDialog mDialog;
    private JProgressBar mBar;

    public ProgressWindow(Component parent, String msg) {
        this.mDialog = UiUtilities.createDialog(parent, true);
        JPanel content = (JPanel)this.mDialog.getContentPane();
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        content.setLayout(new BorderLayout());
        this.mLabel = new JLabel(msg);
        this.mLabel.setHorizontalAlignment(0);
        content.add((Component)this.mLabel, "Center");
        this.mBar = new JProgressBar();
        this.mBar.setVisible(false);
        content.add((Component)this.mBar, "South");
        this.mDialog.setSize(500, 70);
        this.mDialog.setUndecorated(true);
        this.mDialog.setCursor(Cursor.getPredefinedCursor(3));
    }

    public ProgressWindow(Component parent) {
        this(parent, "");
    }

    public void run(final Progress progress) {
        Thread thread = new Thread("Progress window"){

            @Override
            public void run() {
                progress.run();
                while (!ProgressWindow.this.mDialog.isVisible()) {
                }
                ProgressWindow.this.mDialog.setVisible(false);
                ProgressWindow.this.mDialog.dispose();
            }
        };
        thread.start();
        UiUtilities.centerAndShow(this.mDialog);
    }

    @Override
    public void setMaximum(final int maximum) {
        UIThreadRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (maximum == -1) {
                    ProgressWindow.this.mBar.setVisible(false);
                } else {
                    ProgressWindow.this.mBar.setMaximum(maximum);
                    ProgressWindow.this.mBar.setVisible(true);
                    ProgressWindow.this.mBar.setStringPainted(true);
                }
            }
        });
    }

    @Override
    public void setValue(final int value) {
        UIThreadRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.mBar.setValue(value);
            }
        });
    }

    @Override
    public void setMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressWindow.this.mLabel.setText(msg);
            }
        });
    }
}

