/*
 * Decompiled with CFR 0.152.
 */
package com._17od.upm.database;

import com._17od.upm.database.ProblemReadingDatabaseFile;
import com._17od.upm.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public abstract class FlatPackObject {
    private static int LENGTH_FIELD_NUM_CHARS = 4;

    protected byte[] flatPack(String s) throws UnsupportedEncodingException {
        return this.flatPack(s.getBytes("UTF-8"));
    }

    protected byte[] flatPack(byte[] bytesToFlatPack) throws UnsupportedEncodingException {
        String l = Util.lpad(bytesToFlatPack.length, LENGTH_FIELD_NUM_CHARS, '0');
        byte[] fieldLengthBytes = l.getBytes("UTF-8");
        byte[] returnBuffer = new byte[fieldLengthBytes.length + bytesToFlatPack.length];
        System.arraycopy(fieldLengthBytes, 0, returnBuffer, 0, fieldLengthBytes.length);
        System.arraycopy(bytesToFlatPack, 0, returnBuffer, fieldLengthBytes.length, bytesToFlatPack.length);
        return returnBuffer;
    }

    public byte[] getBytes(InputStream is) throws IOException, ProblemReadingDatabaseFile {
        byte[] fieldContents = null;
        byte[] fieldLength = new byte[LENGTH_FIELD_NUM_CHARS];
        int bytesRead = is.read(fieldLength);
        if (bytesRead == -1 || bytesRead != LENGTH_FIELD_NUM_CHARS) {
            throw new EOFException();
        }
        String s = new String(fieldLength);
        try {
            int i = Integer.parseInt(s);
            fieldContents = new byte[i];
            for (int j = 0; j < i; ++j) {
                fieldContents[j] = (byte)is.read();
                if (fieldContents[j] != -1) continue;
                throw new EOFException();
            }
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingDatabaseFile("A field length had invalid characters", e);
        }
        return fieldContents;
    }

    public int getInt(InputStream is) throws IOException, ProblemReadingDatabaseFile {
        return Integer.parseInt(this.getString(is));
    }

    public String getString(InputStream is) throws IOException, ProblemReadingDatabaseFile {
        return new String(this.getBytes(is), "UTF-8");
    }

    public String getString(InputStream is, Charset charset) throws IOException, ProblemReadingDatabaseFile {
        return new String(this.getBytes(is), charset.name());
    }

    public abstract void flatPack(OutputStream var1) throws IOException;
}

