/*
 * Decompiled with CFR 0.152.
 */
import com.sfs._102.awt.BottomStatus;
import com.sfs._102.awt.ImageButton;
import com.sfs._102.awt.SplitPanel;
import com.sfs._102.awt.Toolbar;
import com.sfs.awt.treeview.Folder;
import com.sfs.awt.treeview.Item;
import com.sfs.awt.treeview.ItemSorter;
import com.sfs.awt.treeview.RootFolder;
import com.sfs.awt.treeview.TreeView;
import com.sfs.awt.treeview.TreeViewEventObject;
import com.sfs.awt.treeview.TreeViewListener;
import com.sfs.base.SFSFramedApp;
import com.sfs.base.commitdialog.CommitDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DiskCatalog
extends SFSFramedApp
implements TreeViewListener,
FilenameFilter {
    TreeView tv;
    Toolbar toolbar1;
    ImageButton newButton;
    ImageButton searchButton;
    ImageButton openButton;
    ImageButton saveButton;
    ImageButton settingsButton;
    ImageButton exportButton;
    ImageButton exporthtmlButton;
    Hashtable katalog;
    Panel textpanel;
    Panel leftpanel;
    Panel searchpanel;
    CardLayout cardl;
    CardLayout cardl2;
    Button editComment;
    Button removeEntry;
    ViewPanel emptypanel;
    ViewPanel viewpanel;
    ViewPanel2 stats1;
    ViewPanel2 mp3panel;
    MediaTracker mt1;
    List search;
    Button closeButton;
    Vector searchresult;
    boolean changed;
    boolean reload;
    boolean thumbnail;
    boolean mp3;
    boolean zip;
    String lastfile;
    String licensekey;
    BottomStatus status;
    public String statusstring = "";
    MenuItem dateineu;
    MenuItem dateioeffnen;
    MenuItem dateispeichern;
    MenuItem dateibeenden;
    MenuItem dateiimport;
    MenuItem dateiupdate;
    MenuItem bearbeitenedit;
    MenuItem bearbeitenremove;
    MenuItem bearbeitensettings;
    MenuItem extrasuchen;
    MenuItem extratext;
    MenuItem extrahtml1;
    MenuItem extrahtml2;
    MenuItem extrahtml3;
    MenuItem registername;
    MenuItem registerkey;
    Vector katfilepath;
    IPanel exportpanel;
    SimpleTable st1;
    Button addButton;
    Button deleteButton;
    Button editButton;
    Panel p1;
    IPanel p2;
    IPanel p3;
    Button searchmode;
    Button searchmode2;
    TextField inp;
    CardLayout cardl3;
    CommitDialog ad;
    boolean complex;
    Button selectstartpoint = new Button(this.getText("selectstart"));
    TextField newInp = new TextField(20);
    double countreksize;

    public DiskCatalog(String[] stringArray) {
        super(stringArray);
        this.setTitle("Disk Katalog 1.0.21");
        this.changed = false;
        SplitPanel splitPanel = new SplitPanel(false, 40);
        this.tv = new TreeView(this, "Database", null);
        this.leftpanel = new Panel();
        this.setLayout(new BorderLayout());
        this.setIconImage(this.getImage("logo"));
        this.add("Center", splitPanel);
        this.toolbar1 = new Toolbar();
        this.add("North", this.toolbar1);
        this.status = new BottomStatus();
        this.add("South", this.status);
        BPanel bPanel = new BPanel();
        this.stats1 = new ViewPanel2();
        this.stats1.setTexture(this.getImage("texture5"));
        this.stats1.setColor(Color.yellow);
        this.stats1.str1 = this.getText("filename");
        this.stats1.str3 = this.getText("filesize");
        this.stats1.str5 = this.getText("comment");
        bPanel.setLayout(new BorderLayout());
        bPanel.add("North", this.stats1);
        this.cardl = new CardLayout();
        this.cardl2 = new CardLayout();
        this.textpanel = new Panel();
        this.textpanel.setLayout(this.cardl);
        this.leftpanel.setLayout(this.cardl2);
        splitPanel.add("Left", this.leftpanel);
        this.leftpanel.add("Tree", this.tv);
        this.searchpanel = new Panel();
        this.searchpanel.setLayout(new BorderLayout());
        this.search = new List();
        this.searchpanel.add("Center", this.search);
        this.closeButton = new Button(this.getText("sclose"));
        this.searchpanel.add("South", this.closeButton);
        this.leftpanel.add("Search", this.searchpanel);
        this.emptypanel = new ViewPanel();
        this.emptypanel.setTexture(this.getImage("texture2"));
        this.emptypanel.setImage(this.getImage("logo"), this, "");
        this.mp3panel = new ViewPanel2();
        this.mp3panel.setTexture(this.getImage("texture4"));
        this.mp3panel.setColor(new Color(255, 255, 60));
        this.mp3panel.setColor2(new Color(0, 0, 0));
        this.mp3panel.str1 = this.getText("songtitle");
        this.mp3panel.str3 = this.getText("artist");
        this.mp3panel.str5 = this.getText("albumname");
        this.mp3panel.str7 = this.getText("comment");
        this.mp3panel.str9 = this.getText("releaseyear");
        this.mp3panel.str11 = this.getText("musicstyle");
        this.viewpanel = new ViewPanel();
        this.viewpanel.setTexture(this.getImage("texture3"));
        this.textpanel.add("empty", this.emptypanel);
        this.textpanel.add("mp3", this.mp3panel);
        this.textpanel.add("view", this.viewpanel);
        bPanel.add("Center", this.textpanel);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.editComment = new Button(this.getText("editcomment"));
        this.removeEntry = new Button(this.getText("removeentry"));
        panel.add(this.editComment);
        panel.add(this.removeEntry);
        bPanel.add("South", panel);
        splitPanel.add("Right", bPanel);
        this.newButton = new ImageButton(this.getImage("iconNew"));
        this.newButton.setBorder(false);
        this.newButton.setShowMouseOver(true);
        this.searchButton = new ImageButton(this.getImage("iconSearch"));
        this.searchButton.setBorder(false);
        this.searchButton.setShowMouseOver(true);
        this.openButton = new ImageButton(this.getImage("iconOpen"));
        this.openButton.setBorder(false);
        this.openButton.setShowMouseOver(true);
        this.saveButton = new ImageButton(this.getImage("iconSave"));
        this.saveButton.setBorder(false);
        this.saveButton.setShowMouseOver(true);
        this.exporthtmlButton = new ImageButton(this.getImage("iconhtmlExport"));
        this.exporthtmlButton.setBorder(false);
        this.exporthtmlButton.setShowMouseOver(true);
        this.settingsButton = new ImageButton(this.getImage("iconSettings"));
        this.settingsButton.setBorder(false);
        this.settingsButton.setShowMouseOver(true);
        this.toolbar1.add(this.newButton);
        this.toolbar1.add(this.openButton);
        this.toolbar1.add(this.saveButton);
        this.toolbar1.addSeparator();
        this.toolbar1.add(this.settingsButton);
        this.toolbar1.addSeparator();
        this.toolbar1.add(this.searchButton);
        ((Component)this).setSize(this.str2int(this.getProperty("xsize"), 500), this.str2int(this.getProperty("ysize"), 400));
        ((Component)this).setLocation(this.str2int(this.getProperty("x"), 10), this.str2int(this.getProperty("y"), 10));
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu(this.getText("Datei"));
        menuBar.add(menu);
        this.dateineu = new MenuItem(this.getText("Neu"));
        menu.add(this.dateineu);
        this.dateioeffnen = new MenuItem(this.getText("oeffnen"));
        menu.add(this.dateioeffnen);
        this.dateiimport = new MenuItem(this.getText("import"));
        menu.add(this.dateiimport);
        this.dateispeichern = new MenuItem(this.getText("Speichern"));
        menu.add(this.dateispeichern);
        menu.addSeparator();
        this.dateiupdate = new MenuItem(this.getText("update"));
        menu.add(this.dateiupdate);
        menu.addSeparator();
        this.dateibeenden = new MenuItem(this.getText("Beenden"));
        menu.add(this.dateibeenden);
        Menu menu2 = new Menu(this.getText("Bearbeiten"));
        menuBar.add(menu2);
        this.bearbeitenedit = new MenuItem(this.getText("EditComment"));
        menu2.add(this.bearbeitenedit);
        this.bearbeitenremove = new MenuItem(this.getText("RemoveEntry"));
        menu2.add(this.bearbeitenremove);
        menu2.addSeparator();
        this.bearbeitensettings = new MenuItem(this.getText("Settings"));
        menu2.add(this.bearbeitensettings);
        Menu menu3 = new Menu(this.getText("Extras"));
        Menu menu4 = new Menu(this.getText("ExportHTML"));
        this.extrasuchen = new MenuItem(this.getText("Suchen"), new MenuShortcut(102));
        menu3.add(this.extrasuchen);
        this.extratext = new MenuItem(this.getText("ExportasText"));
        menu3.add(this.extratext);
        menu3.add(menu4);
        this.extrahtml1 = new MenuItem(this.getText("Standard"));
        menu4.add(this.extrahtml1);
        this.extrahtml2 = new MenuItem(this.getText("TableofMP3"));
        menu4.add(this.extrahtml2);
        menuBar.add(menu3);
        this.show();
        this.katalog = new Hashtable(1000, 0.75f);
        this.tv.setSorter(new ItemSorter());
        this.tv.addTreeViewListener(this);
        this.tv.setTexture(this.getImage("texture"));
        this.searchresult = new Vector();
        this.thumbnail = this.getProperty("thumbnail", "true").equalsIgnoreCase("true");
        this.mp3 = this.getProperty("mp3", "true").equalsIgnoreCase("true");
        this.zip = this.getProperty("zip", "true").equalsIgnoreCase("true");
        this.licensekey = this.getProperty("licensekey", "");
        this.reload = this.getProperty("reload", "false").equalsIgnoreCase("true");
        this.lastfile = this.getProperty("lastfile", "");
        this.katfilepath = new Vector();
        if (this.reload) {
            worker3 worker32 = new worker3();
            worker32.setData(this, this.lastfile);
            worker32.start();
            this.statusstring = this.getText("loading");
            this.updatestatus();
        }
        this.mt1 = new MediaTracker(this);
    }

    public int str2int(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean accept(File file, String string) {
        return file.exists();
    }

    public boolean onExit() {
        Rectangle rectangle = this.getBounds();
        this.setProperty("xsize", String.valueOf(rectangle.width));
        this.setProperty("ysize", String.valueOf(rectangle.height));
        this.setProperty("x", String.valueOf(rectangle.x));
        this.setProperty("y", String.valueOf(rectangle.y));
        this.setProperty("reload", this.reload ? "true" : "false");
        this.setProperty("thumbnail", this.thumbnail ? "true" : "false");
        this.setProperty("mp3", this.mp3 ? "true" : "false");
        this.setProperty("zip", this.zip ? "true" : "false");
        this.setProperty("lastfile", this.lastfile);
        this.setProperty("licensekey", this.licensekey);
        return true;
    }

    public void openButtonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(0);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            File file = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            if (!file.exists()) {
                this.askForCommit(this.getText("filenotfound"), this.getText("ok"));
                return;
            }
            if (file.isDirectory()) {
                this.askForCommit(this.getText("fileisdirectory"), this.getText("ok"));
                return;
            }
            this.katalog = null;
            this.katfilepath = new Vector();
            this.tv.Root = new RootFolder(this.tv, "Database", null);
            this.tv.setSorter(new ItemSorter());
            this.tv.repaint();
            worker3 worker32 = new worker3();
            worker32.setData(this, file.toString());
            worker32.start();
            this.statusstring = this.getText("loading");
            this.updatestatus();
            this.lastfile = file.toString();
        }
    }

    public void importButtonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(0);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            File file = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            if (!file.exists()) {
                this.askForCommit(this.getText("filenotfound"), this.getText("ok"));
                return;
            }
            if (file.isDirectory()) {
                this.askForCommit(this.getText("fileisdirectory"), this.getText("ok"));
                return;
            }
            worker3 worker32 = new worker3();
            worker32.setData(this, file.toString());
            worker32.start();
            this.statusstring = this.getText("loading");
            this.updatestatus();
        }
    }

    public void settingsButtonpressed() {
        IPanel iPanel = new IPanel();
        Checkbox checkbox = new Checkbox(this.getText("reload"), this.reload);
        Checkbox checkbox2 = new Checkbox(this.getText("thumbnails"), this.thumbnail);
        Checkbox checkbox3 = new Checkbox(this.getText("readmp3"), this.mp3);
        Checkbox checkbox4 = new Checkbox(this.getText("readzip"), this.zip);
        iPanel.setLayout(new GridLayout(0, 1));
        iPanel.add(checkbox);
        iPanel.add(checkbox2);
        iPanel.add(checkbox3);
        iPanel.add(checkbox4);
        Label label = new Label(this.getText("license"));
        TextField textField = new TextField(20);
        ((TextComponent)textField).setText(this.licensekey);
        iPanel.add(label);
        iPanel.add(textField);
        if (this.askForCommit(this.getText("settings"), iPanel, true)) {
            this.reload = checkbox.getState();
            this.thumbnail = checkbox2.getState();
            this.mp3 = checkbox3.getState();
            this.zip = checkbox4.getState();
            this.licensekey = textField.getText();
        }
    }

    public void saveButtonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(1);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            File file = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            if (file.exists() && !this.askForCommit(this.getText("fileexist"), this.getText("ok"))) {
                return;
            }
            if (file.isDirectory()) {
                this.askForCommit(this.getText("fileisdirectory"), this.getText("ok"));
                return;
            }
            this.statusstring = this.getText("saving");
            this.updatestatus();
            worker7 worker72 = new worker7();
            worker72.setData(file.toString(), this);
            worker72.start();
            this.changed = false;
            this.lastfile = file.toString();
        }
    }

    public void addpressed() {
        Choice choice = new Choice();
        choice.add(this.getText("slabel"));
        choice.add(this.getText("spath"));
        choice.add(this.getText("sfilename"));
        choice.add(this.getText("scomment"));
        choice.add(this.getText("ssongtitle"));
        choice.add(this.getText("sartist"));
        choice.add(this.getText("salbumname"));
        choice.add(this.getText("smcomment"));
        choice.add(this.getText("smusicstyle"));
        choice.add(this.getText("sreleaseyear"));
        Panel panel = new Panel();
        panel.add(choice);
        if (this.askForCommit(this.getText("add"), panel, true)) {
            this.st1.addRow(new String[]{choice.getSelectedItem()});
        }
    }

    public void editpressed() {
        Choice choice = new Choice();
        choice.add(this.getText("slabel"));
        choice.add(this.getText("spath"));
        choice.add(this.getText("sfilename"));
        choice.add(this.getText("scomment"));
        choice.add(this.getText("ssongtitle"));
        choice.add(this.getText("sartist"));
        choice.add(this.getText("salbumname"));
        choice.add(this.getText("smcomment"));
        choice.add(this.getText("smusicstyle"));
        choice.add(this.getText("sreleaseyear"));
        Panel panel = new Panel();
        panel.add(choice);
        if (this.askForCommit(this.getText("edit"), panel, true)) {
            this.st1.setRow(this.st1.getSelected(), new String[]{choice.getSelectedItem()});
        }
    }

    public void deletepressed() {
        int n = this.st1.getSelected();
        if (n != -1) {
            this.st1.delete(n);
        }
        this.st1.repaint();
    }

    public void exportButtonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(1);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            File file = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            if (file.exists() && !this.askForCommit(this.getText("fileexist"), this.getText("ok"))) {
                return;
            }
            if (file.isDirectory()) {
                this.askForCommit(this.getText("fileisdirectory"), this.getText("ok"));
                return;
            }
            this.exportpanel = new 1();
            this.st1 = new SimpleTable(new String[]{this.getText("datafield")}, new float[]{1.0f});
            this.st1.addRow(new String[]{this.getText("slabel")});
            this.st1.addRow(new String[]{this.getText("spath")});
            this.st1.addRow(new String[]{this.getText("sfilename")});
            this.st1.addRow(new String[]{this.getText("scomment")});
            this.st1.addRow(new String[]{this.getText("ssongtitle")});
            this.st1.addRow(new String[]{this.getText("sartist")});
            this.st1.addRow(new String[]{this.getText("salbumname")});
            this.st1.addRow(new String[]{this.getText("smcomment")});
            this.st1.addRow(new String[]{this.getText("smusicstyle")});
            this.st1.addRow(new String[]{this.getText("sreleaseyear")});
            this.addButton = new Button(this.getText("add"));
            this.editButton = new Button(this.getText("edit"));
            this.deleteButton = new Button(this.getText("delete"));
            Panel panel = new Panel();
            Panel panel2 = new Panel();
            panel.add(this.st1);
            panel2.add(this.addButton);
            panel2.add(this.editButton);
            panel2.add(this.deleteButton);
            Panel panel3 = new Panel();
            panel3.setLayout(new BorderLayout());
            panel3.add("Center", panel);
            panel3.add("South", panel2);
            Label label = new Label("sortedby");
            Choice choice = new Choice();
            choice.add(this.getText("slabelpath"));
            choice.add(this.getText("slabel"));
            choice.add(this.getText("spath"));
            choice.add(this.getText("sfilename"));
            choice.add(this.getText("scomment"));
            choice.add(this.getText("ssongtitle"));
            choice.add(this.getText("sartist"));
            choice.add(this.getText("salbumname"));
            choice.add(this.getText("smcomment"));
            choice.add(this.getText("smusicstyle"));
            choice.add(this.getText("sreleaseyear"));
            Panel panel4 = new Panel();
            panel4.setLayout(new GridLayout(0, 2));
            panel4.add(label);
            panel4.add(choice);
            Label label2 = new Label("separator");
            TextField textField = new TextField(4);
            ((TextComponent)textField).setText(";");
            panel4.add(label2);
            panel4.add(textField);
            this.exportpanel.setLayout(new BorderLayout());
            this.exportpanel.add("North", panel4);
            this.exportpanel.add("Center", panel3);
            if (this.askForCommit(this.getText("exportoptions"), this.exportpanel, true)) {
                worker5 worker52 = new worker5();
                this.statusstring = this.getText("exporting");
                this.updatestatus();
                int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                int n = 0;
                while (n < this.st1.getTableSize()) {
                    String[] stringArray = this.st1.getRow(n);
                    if (stringArray[0].equals(this.getText("slabel"))) {
                        nArray[n] = 0;
                    }
                    if (stringArray[0].equals(this.getText("spath"))) {
                        nArray[n] = 1;
                    }
                    if (stringArray[0].equals(this.getText("sfilename"))) {
                        nArray[n] = 2;
                    }
                    if (stringArray[0].equals(this.getText("scomment"))) {
                        nArray[n] = 3;
                    }
                    if (stringArray[0].equals(this.getText("ssongtitle"))) {
                        nArray[n] = 4;
                    }
                    if (stringArray[0].equals(this.getText("sartist"))) {
                        nArray[n] = 5;
                    }
                    if (stringArray[0].equals(this.getText("salbumname"))) {
                        nArray[n] = 6;
                    }
                    if (stringArray[0].equals(this.getText("smcomment"))) {
                        nArray[n] = 7;
                    }
                    if (stringArray[0].equals(this.getText("smusicstyle"))) {
                        nArray[n] = 8;
                    }
                    if (stringArray[0].equals(this.getText("sreleaseyear"))) {
                        nArray[n] = 9;
                    }
                    ++n;
                }
                worker52.setData(this, textField.getText(), choice.getSelectedIndex(), nArray, file.toString());
                worker52.start();
            }
        }
    }

    public void editCommentpressed() {
        Item item = this.tv.Root.getCaretItem();
        if (item != null) {
            String string = (String)item.getContent();
            FileEntry fileEntry = (FileEntry)this.katalog.get(string);
            String string2 = fileEntry.Comment;
            if (string2 == null) {
                string2 = "";
            }
            Panel panel = new Panel();
            TextField textField = new TextField(20);
            panel.add(textField);
            ((TextComponent)textField).setText(string2);
            if (this.askForCommit(this.getText("comment"), panel, true)) {
                this.stats1.str6 = fileEntry.Comment = textField.getText();
                this.changed = true;
                this.stats1.repaint();
            }
        }
    }

    public void removeEntrypressed() {
        Item item = this.tv.Root.getCaretItem();
        if (item != null) {
            String string = (String)item.getContent();
            if (string != null) {
                FileEntry cfr_ignored_0 = (FileEntry)this.katalog.get(string);
                if (this.askForCommit(this.getText("removeentry"), this.getText("ok"))) {
                    this.katalog.remove(string);
                    this.tv.Root = new RootFolder(this.tv, "Database", null);
                    this.tv.setSorter(new ItemSorter());
                    this.fillTreeview();
                    this.tv.repaint();
                    return;
                }
            } else {
                String string2 = item.getAbsoluteName();
                if (string2.indexOf(92) != -1) {
                    string2 = string2.substring(string2.indexOf(92) + 1);
                    if (this.askForCommit(this.getText("removeentry"), this.getText("ok"))) {
                        Enumeration enumeration = this.katalog.keys();
                        while (enumeration.hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            FileEntry fileEntry = (FileEntry)this.katalog.get(string3);
                            if (!fileEntry.toString().startsWith(string2)) continue;
                            this.katalog.remove(string3);
                        }
                        this.tv.Root = new RootFolder(this.tv, "Database", null);
                        this.tv.setSorter(new ItemSorter());
                        this.fillTreeview();
                        this.tv.repaint();
                    }
                }
            }
        }
    }

    public void searchmodepressed() {
        this.p1.remove(this.p2);
        this.p1.add(this.p3);
        this.p1.validate();
        this.ad.validate();
        this.ad.pack();
        this.repaint();
        this.complex = true;
    }

    public void searchmode2pressed() {
        this.p1.remove(this.p3);
        this.p1.add(this.p2);
        this.p1.validate();
        this.ad.validate();
        this.ad.pack();
        this.repaint();
        this.complex = false;
    }

    public void searchButtonpressed() {
        this.complex = false;
        this.p1 = new 2();
        this.p2 = new IPanel();
        this.inp = new TextField(20);
        this.p2.add(this.inp);
        this.searchmode = new Button(this.getText("complexsearch"));
        this.p2.add(this.searchmode);
        this.p3 = new IPanel();
        this.p3.setLayout(new GridLayout(0, 2));
        Choice choice = new Choice();
        choice.add(this.getText("sany"));
        choice.add(this.getText("slabel"));
        choice.add(this.getText("spath"));
        choice.add(this.getText("sfilename"));
        choice.add(this.getText("scomment"));
        choice.add(this.getText("ssongtitle"));
        choice.add(this.getText("sartist"));
        choice.add(this.getText("salbumname"));
        choice.add(this.getText("smcomment"));
        choice.add(this.getText("smusicstyle"));
        choice.add(this.getText("sreleaseyear"));
        Label label = new Label(this.getText("searchin"));
        this.p3.add(label);
        this.p3.add(choice);
        Label label2 = new Label(this.getText("searchfor"));
        TextField textField = new TextField(20);
        this.p3.add(label2);
        this.p3.add(textField);
        Label label3 = new Label();
        Choice choice2 = new Choice();
        choice2.add(this.getText("sor"));
        choice2.add(this.getText("sand"));
        this.p3.add(label3);
        this.p3.add(choice2);
        Choice choice3 = new Choice();
        choice3.add(this.getText("sany"));
        choice3.add(this.getText("slabel"));
        choice3.add(this.getText("spath"));
        choice3.add(this.getText("sfilename"));
        choice3.add(this.getText("scomment"));
        choice3.add(this.getText("ssongtitle"));
        choice3.add(this.getText("sartist"));
        choice3.add(this.getText("salbumname"));
        choice3.add(this.getText("smcomment"));
        choice3.add(this.getText("smusicstyle"));
        choice3.add(this.getText("sreleaseyear"));
        Label label4 = new Label(this.getText("searchin"));
        this.p3.add(label4);
        this.p3.add(choice3);
        Label label5 = new Label(this.getText("searchfor"));
        TextField textField2 = new TextField(20);
        this.p3.add(label5);
        this.p3.add(textField2);
        this.searchmode2 = new Button(this.getText("simplesearch"));
        this.p3.add(this.searchmode2);
        this.p1.add(this.p2);
        this.ad = new CommitDialog((Frame)this, this.getText("search"), this.p1, true);
        if (this.ad.accept()) {
            this.search.removeAll();
            this.searchresult.removeAllElements();
            worker4 worker42 = new worker4();
            this.statusstring = this.getText("searching");
            this.updatestatus();
            if (!this.complex) {
                worker42.setData(this, this.inp.getText());
            } else {
                worker42.setData(this, choice.getSelectedIndex(), textField.getText(), choice3.getSelectedIndex(), textField2.getText(), choice2.getSelectedIndex());
            }
            worker42.start();
            this.cardl2.show(this.leftpanel, "Search");
        }
    }

    public void closeButtonpressed() {
        this.cardl2.show(this.leftpanel, "Tree");
    }

    public void searchpressed() {
        int n = this.search.getSelectedIndex();
        if (n == -1) {
            return;
        }
        String string = (String)this.searchresult.elementAt(n);
        if (string == null) {
            return;
        }
        FileEntry fileEntry = (FileEntry)this.katalog.get(string);
        if (fileEntry == null) {
            return;
        }
        String string2 = fileEntry.filename;
        this.stats1.str2 = string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
        n = fileEntry.filesize;
        if (n < 10000) {
            this.stats1.str4 = n + " " + this.getText("bytes");
        }
        if (n >= 10000 && n < 10000000) {
            this.stats1.str4 = (float)n / 1000.0f + " " + this.getText("kbytes");
        }
        if (n >= 1000000) {
            this.stats1.str4 = (float)(n / 1000) / 1000.0f + " " + this.getText("mbytes");
        }
        if ((string2 = fileEntry.Comment) != null) {
            this.stats1.str6 = string2;
        }
        this.stats1.repaint();
        if (fileEntry.type != 3 && fileEntry.type != 4) {
            this.cardl.show(this.textpanel, "empty");
        }
        if (fileEntry.type == 3) {
            this.mp3panel.str2 = fileEntry.mp3entry.Songtitle;
            this.mp3panel.str4 = fileEntry.mp3entry.Artist;
            this.mp3panel.str6 = fileEntry.mp3entry.Albumname;
            this.mp3panel.str8 = fileEntry.mp3entry.Comment;
            this.mp3panel.str10 = fileEntry.mp3entry.Releaseyear;
            this.mp3panel.str12 = fileEntry.mp3entry.Musicstyle;
            this.mp3panel.repaint();
            this.cardl.show(this.textpanel, "mp3");
        }
        if (fileEntry.type == 4) {
            this.viewpanel.setImage(null, this, "Imagesize: " + fileEntry.imgentry.xsize + " x " + fileEntry.imgentry.ysize);
            this.viewpanel.load(fileEntry.imgentry.img);
            this.cardl.show(this.textpanel, "view");
        }
    }

    String str2html(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\u00c4': {
                    string2 = String.valueOf(string2) + "&Auml;";
                    break;
                }
                case '\u00d6': {
                    string2 = String.valueOf(string2) + "&Ouml;";
                    break;
                }
                case '\u00dc': {
                    string2 = String.valueOf(string2) + "&Uuml;";
                    break;
                }
                case '\u00df': {
                    string2 = String.valueOf(string2) + "&szlig;";
                    break;
                }
                case '\u00e4': {
                    string2 = String.valueOf(string2) + "&auml;";
                    break;
                }
                case '\u00f6': {
                    string2 = String.valueOf(string2) + "&ouml;";
                    break;
                }
                case '\u00fc': {
                    string2 = String.valueOf(string2) + "&uuml;";
                    break;
                }
                case '<': {
                    string2 = String.valueOf(string2) + "&lt;";
                    break;
                }
                case '>': {
                    string2 = String.valueOf(string2) + "&gt;";
                    break;
                }
                default: {
                    string2 = String.valueOf(string2) + c;
                }
            }
            ++n;
        }
        return string2;
    }

    public void rek(Folder folder, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes("<ul type =disc>");
        int n = 0;
        while (n < folder.size()) {
            Item item = folder.getItem(n);
            if (item instanceof Folder) {
                dataOutputStream.writeBytes("<li> <a href=#" + URLEncoder.encode(item.getAbsoluteName()) + "> " + this.str2html(item.getName()) + "</a> \n");
                this.rek((Folder)item, dataOutputStream);
            }
            ++n;
        }
        dataOutputStream.writeBytes("</ul>");
    }

    public void rek2(Folder folder, DataOutputStream dataOutputStream, String string) throws IOException {
        Object object;
        dataOutputStream.writeBytes("<hr>");
        dataOutputStream.writeBytes("<a name=" + URLEncoder.encode(folder.getAbsoluteName()) + "><h2> Index of " + this.str2html(folder.getName()) + "</h2> </a> \n");
        dataOutputStream.writeBytes("<table border><tr><th> Filename </th><th> Size </th><th> Comment </th> <th> Spezial </th></tr> \n");
        int n = 0;
        while (n < folder.size()) {
            Item item = folder.getItem(n);
            if (item instanceof Folder) {
                dataOutputStream.writeBytes("<tr><th><a href=#" + URLEncoder.encode(item.getAbsoluteName()) + ">" + this.str2html(item.getName()) + "</a></th><th> &lt;dir&gt;</th><th></th><th></th></tr> \n");
            } else {
                object = (String)item.getContent();
                if (object != null) {
                    FileEntry fileEntry = (FileEntry)this.katalog.get(object);
                    dataOutputStream.writeBytes("<tr><th>" + this.str2html(fileEntry.filename.substring(fileEntry.filename.lastIndexOf(File.separator) + 1)) + "</th><th> " + fileEntry.filesize + "</th><th>" + this.str2html(fileEntry.Comment) + "</th><th>");
                    if (fileEntry.type == 4) {
                        FileOutputStream fileOutputStream;
                        dataOutputStream.writeBytes("<img src=" + '\"' + fileEntry.hashCode() + ".jpeg" + '\"' + ">");
                        FileOutputStream fileOutputStream2 = fileOutputStream = new FileOutputStream(String.valueOf(string) + fileEntry.hashCode() + ".jpeg");
                        synchronized (fileOutputStream2) {
                            int n2 = 0;
                            while (n2 < fileEntry.imgentry.length) {
                                fileOutputStream.write(fileEntry.imgentry.img[n2]);
                                ++n2;
                            }
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                    }
                    if (fileEntry.type == 3) {
                        dataOutputStream.writeBytes("<p align=left><br> Mp3 TAG:<br> Artist : " + this.str2html(fileEntry.mp3entry.Artist) + "<br> Songtitle : " + this.str2html(fileEntry.mp3entry.Songtitle) + "</p>");
                    }
                    dataOutputStream.writeBytes("</th></tr> \n");
                }
            }
            ++n;
        }
        dataOutputStream.writeBytes("</table border> \n");
        int n3 = 0;
        while (n3 < folder.size()) {
            object = folder.getItem(n3);
            if (object instanceof Folder) {
                this.rek2((Folder)object, dataOutputStream, string);
            }
            ++n3;
        }
    }

    public void exporthtmlButtonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(1);
        fileDialog.show();
        if (fileDialog.getDirectory() == null) {
            return;
        }
        worker9 worker92 = new worker9();
        worker92.setData(this, String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile(), fileDialog.getDirectory());
        worker92.start();
        this.statusstring = this.getText("exporthtml");
        this.updatestatus();
    }

    public void exporthtml2Buttonpressed() {
        FileDialog fileDialog = new FileDialog(this);
        fileDialog.setMode(1);
        fileDialog.show();
        if (fileDialog.getDirectory() == null) {
            return;
        }
        worker8 worker82 = new worker8();
        worker82.setData(this, String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
        worker82.start();
        this.statusstring = this.getText("exporthtml");
        this.updatestatus();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001 && event.target instanceof MenuItem) {
            if (event.target == this.dateineu) {
                this.newButtonpressed();
            }
            if (event.target == this.dateioeffnen) {
                this.openButtonpressed();
            }
            if (event.target == this.dateiimport) {
                this.importButtonpressed();
            }
            if (event.target == this.dateiupdate) {
                this.updateButtonpressed();
            }
            if (event.target == this.dateispeichern) {
                this.saveButtonpressed();
            }
            if (event.target == this.dateibeenden && this.onExit()) {
                this.saveSettings("DiskCatalog 1.0.21 - All Rights reserved \u00a91999");
                this.dispose();
                System.exit(0);
            }
            if (event.target == this.bearbeitensettings) {
                this.settingsButtonpressed();
            }
            if (event.target == this.bearbeitenedit) {
                this.editCommentpressed();
            }
            if (event.target == this.bearbeitenremove) {
                this.removeEntrypressed();
            }
            if (event.target == this.extratext) {
                this.exportButtonpressed();
            }
            if (event.target == this.extrahtml1) {
                this.exporthtmlButtonpressed();
            }
            if (event.target == this.extrahtml2) {
                this.exporthtml2Buttonpressed();
            }
            if (event.target == this.extrasuchen) {
                this.searchButtonpressed();
            }
        }
        if (event.id == 1001 && event.target instanceof ImageButton) {
            if (event.target == this.newButton) {
                this.newButtonpressed();
            }
            if (event.target == this.openButton) {
                this.openButtonpressed();
            }
            if (event.target == this.searchButton) {
                this.searchButtonpressed();
            }
            if (event.target == this.saveButton) {
                this.saveButtonpressed();
            }
            if (event.target == this.settingsButton) {
                this.settingsButtonpressed();
            }
            if (event.target == this.exportButton) {
                this.exportButtonpressed();
            }
            if (event.target == this.exporthtmlButton) {
                this.exporthtmlButtonpressed();
            }
        }
        if (event.id == 1001 && event.target instanceof Button) {
            if (event.target == this.editComment) {
                this.editCommentpressed();
            }
            if (event.target == this.removeEntry) {
                this.removeEntrypressed();
            }
            if (event.target == this.closeButton) {
                this.closeButtonpressed();
            }
        }
        if (event.id == 1001 && event.target instanceof List && event.target == this.search) {
            this.searchpressed();
        }
        if (event.id == 504 && event.target instanceof ImageButton) {
            if (event.target == this.newButton) {
                this.status.setMessage(this.getText("status.new"), "");
            } else if (event.target == this.openButton) {
                this.status.setMessage(this.getText("status.open"), "");
            } else if (event.target == this.saveButton) {
                this.status.setMessage(this.getText("status.save"), "");
            } else if (event.target == this.settingsButton) {
                this.status.setMessage(this.getText("status.settings"), "");
            } else if (event.target == this.exporthtmlButton) {
                this.status.setMessage(this.getText("status.export"), "");
            } else if (event.target == this.searchButton) {
                this.status.setMessage(this.getText("status.search"), "");
            }
        } else if (event.id == 505 && event.target instanceof ImageButton) {
            this.status.setMessage(this.getText("status.ready"), this.statusstring);
        }
        return super.handleEvent(event);
    }

    public void updatestatus() {
        this.status.setMessage(this.getText("status.ready"), this.statusstring);
    }

    public void selectstartpressed() {
        DirectorySelect directorySelect = new DirectorySelect((Frame)this, "Select Directory...", true, this.getImage("texture"));
        if (directorySelect.result) {
            ((TextComponent)this.newInp).setText(directorySelect.getDirectory());
        }
    }

    public void newButtonpressed() {
        Panel panel = new 3();
        panel.add(this.newInp);
        panel.add(this.selectstartpoint);
        if (this.askForCommit(this.getText("startpoint"), panel, true)) {
            if (this.newInp.getText().equals("")) {
                return;
            }
            String string = this.newInp.getText();
            panel = new Panel();
            panel.add(this.newInp);
            if (this.askForCommit(this.getText("label"), panel, true)) {
                if (this.newInp.getText().equals("")) {
                    return;
                }
                this.katfilepath.addElement(string);
                this.katfilepath.addElement(this.newInp.getText());
                worker2 worker22 = new worker2();
                this.statusstring = this.getText("getting");
                this.updatestatus();
                worker22.setData(this, string, string, this.newInp.getText(), this.thumbnail, this.mp3, this.zip, this.getText("getting"), this.licensekey);
                worker22.start();
                this.changed = true;
                this.tv.repaint();
            }
        }
    }

    public void updateButtonpressed() {
        int n = 0;
        while (n < this.katfilepath.size()) {
            String string = (String)this.katfilepath.elementAt(n);
            String string2 = (String)this.katfilepath.elementAt(++n);
            ++n;
            worker2 worker22 = new worker2();
            this.statusstring = this.getText("getting");
            this.updatestatus();
            worker22.setData(this, string, string, string2, this.thumbnail, this.mp3, this.zip, this.getText("getting"), this.licensekey);
            worker22.start();
            this.changed = true;
        }
        this.tv.repaint();
    }

    public void fillTreeview() {
        Folder folder = null;
        String string = "";
        int n = this.katalog.size();
        int n2 = 0;
        Enumeration enumeration = this.katalog.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (++n2 % 100 == 0) {
                this.statusstring = n2 * 100 / n + " %";
                this.updatestatus();
            }
            FileEntry fileEntry = (FileEntry)this.katalog.get(string2);
            if (fileEntry.type == 0 || fileEntry.type == 1) continue;
            try {
                folder = (Folder)this.tv.Root.lookup(fileEntry.label);
                if (folder == null) {
                    folder = this.tv.addFolder(fileEntry.label, null);
                }
                string = fileEntry.filename;
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
                int n3 = stringTokenizer.countTokens();
                while (n3 > 1) {
                    String string3 = stringTokenizer.nextToken();
                    --n3;
                    Folder folder2 = (Folder)folder.lookup(string3);
                    if (folder2 == null) {
                        folder2 = folder.addFolder(string3, null);
                    }
                    folder = folder2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
            if (folder.lookup(string) != null || string.length() <= 0) continue;
            try {
                Item item = folder.addItem(string, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void addtoTreeview(String string, FileEntry fileEntry) {
        Folder folder = null;
        String string2 = "";
        if (fileEntry.type == 0) {
            return;
        }
        if (fileEntry.type == 1) {
            return;
        }
        try {
            folder = (Folder)this.tv.Root.lookup(fileEntry.label);
            if (folder == null) {
                folder = this.tv.addFolder(fileEntry.label, null);
            }
            string2 = fileEntry.filename;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.separator);
            int n = stringTokenizer.countTokens();
            while (n > 1) {
                --n;
                String string3 = stringTokenizer.nextToken();
                Folder folder2 = (Folder)folder.lookup(string3);
                if (folder2 == null) {
                    folder2 = folder.addFolder(string3, null);
                }
                folder = folder2;
            }
        }
        catch (Exception exception) {}
        string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
        if (string2.length() > 0) {
            try {
                Item item = folder.addItem(string2, string);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void countrek(Folder folder) {
        int n = 0;
        while (n < folder.size()) {
            Item item = folder.getItem(n);
            if (item != null) {
                if (item instanceof Folder) {
                    this.countrek((Folder)item);
                } else {
                    String string = (String)item.getContent();
                    if (string != null) {
                        FileEntry fileEntry = (FileEntry)this.katalog.get(string);
                        this.countreksize += (double)fileEntry.filesize;
                    }
                }
            }
            ++n;
        }
    }

    public void handleTreeViewEvent(TreeViewEventObject treeViewEventObject) {
        String string;
        Item item = treeViewEventObject.getItem();
        if ((treeViewEventObject.getAction() == 0 || treeViewEventObject.getAction() == 1 || treeViewEventObject.getAction() == 5) && item instanceof Folder) {
            this.countreksize = 0.0;
            this.countrek((Folder)item);
            this.stats1.str2 = item.getName();
            double d = this.countreksize;
            if (d < 10000.0) {
                this.stats1.str4 = d + " " + this.getText("bytes");
            }
            if (d >= 10000.0 && d < 1.0E7) {
                this.stats1.str4 = Math.round(d / 1024.0 * 100.0) / 100L + " " + this.getText("kbytes");
            }
            if (d >= 1000000.0) {
                this.stats1.str4 = Math.round(d / 1024.0 / 1024.0 * 100.0) / 100L + " " + this.getText("mbytes");
            }
            this.cardl.show(this.textpanel, "empty");
            this.stats1.repaint();
        }
        if ((treeViewEventObject.getAction() == 3 || treeViewEventObject.getAction() == 2 || treeViewEventObject.getAction() == 4) && (string = (String)item.getContent()) != null) {
            FileEntry fileEntry = (FileEntry)this.katalog.get(string);
            String string2 = fileEntry.filename;
            this.stats1.str2 = string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1);
            int n = fileEntry.filesize;
            if (n < 10000) {
                this.stats1.str4 = n + " " + this.getText("bytes");
            }
            if (n >= 10000 && n < 10000000 && n >= 10000 && n < 10000000) {
                this.stats1.str4 = Math.round((double)n / 1024.0 * 100.0) / 100L + " " + this.getText("kbytes");
            }
            if (n >= 1000000) {
                this.stats1.str4 = Math.round((double)(n / 1024) / 1024.0 * 100.0) / 100L + " " + this.getText("mbytes");
            }
            if ((string2 = fileEntry.Comment) != null) {
                this.stats1.str6 = string2;
            }
            this.stats1.repaint();
            if (fileEntry.type != 3 && fileEntry.type != 4) {
                this.cardl.show(this.textpanel, "empty");
            }
            if (fileEntry.type == 3) {
                this.mp3panel.str2 = fileEntry.mp3entry.Songtitle;
                this.mp3panel.str4 = fileEntry.mp3entry.Artist;
                this.mp3panel.str6 = fileEntry.mp3entry.Albumname;
                this.mp3panel.str8 = fileEntry.mp3entry.Comment;
                this.mp3panel.str10 = fileEntry.mp3entry.Releaseyear;
                this.mp3panel.str12 = fileEntry.mp3entry.Musicstyle;
                this.mp3panel.repaint();
                this.cardl.show(this.textpanel, "mp3");
            }
            if (fileEntry.type == 4) {
                this.viewpanel.setImage(null, this, "Imagesize: " + fileEntry.imgentry.xsize + " x " + fileEntry.imgentry.ysize);
                this.viewpanel.load(fileEntry.imgentry.img);
                this.cardl.show(this.textpanel, "view");
            }
        }
    }

    public static void main(String[] stringArray) {
        new DiskCatalog(stringArray);
    }

    private final class 1
    extends IPanel {
        public boolean handleEvent(Event event) {
            if (event.target == DiskCatalog.this.addButton && event.id == 1001) {
                DiskCatalog.this.addpressed();
            }
            if (event.target == DiskCatalog.this.editButton && event.id == 1001) {
                DiskCatalog.this.editpressed();
            }
            if (event.target == DiskCatalog.this.deleteButton && event.id == 1001) {
                DiskCatalog.this.deletepressed();
            }
            return super.handleEvent(event);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends Panel {
        public boolean handleEvent(Event event) {
            if (event.target == DiskCatalog.this.searchmode && event.id == 1001) {
                DiskCatalog.this.searchmodepressed();
            }
            if (event.target == DiskCatalog.this.searchmode2 && event.id == 1001) {
                DiskCatalog.this.searchmode2pressed();
            }
            return super.handleEvent(event);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends Panel {
        public boolean handleEvent(Event event) {
            if (event.id == 1001 && event.target == DiskCatalog.this.selectstartpoint) {
                DiskCatalog.this.selectstartpressed();
            }
            return super.handleEvent(event);
        }

        /* synthetic */ 3() {
        }
    }
}

