/*
 * Decompiled with CFR 0.152.
 */
package com.sfs._102.awt;

import com.sfs._102.awt.SplitLayout;
import com.sfs._102.awt.SplitPanel;
import com.sfs._102.awt.dummy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

class SplitHorizontalLayout
extends SplitLayout {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;

    public SplitHorizontalLayout(SplitPanel splitPanel, int n) {
        super(splitPanel, n);
    }

    public void addLayoutComponent(String string, Component component) {
        if (component == null) {
            component = new dummy();
        }
        if (string.equals("Top")) {
            this.components[0] = component;
            return;
        }
        if (string.equals("Center")) {
            this.components[1] = component;
            return;
        }
        if (string.equals("Bottom")) {
            this.components[2] = component;
        }
    }

    public void setBorderLine(int n) {
        Dimension dimension = this.Parent.size();
        Insets insets = this.Parent.insets();
        int n2 = dimension.height - this.components[1].minimumSize().height;
        if (n <= n2 && n > insets.top) {
            this.percentBorder = n * 100 / dimension.height;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component instanceof dummy) {
            return;
        }
        if (this.components[0] == component) {
            this.components[0] = new dummy();
            return;
        }
        if (this.components[1] == component) {
            this.components[1] = new dummy();
            return;
        }
        this.components[2] = new dummy();
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.components[0].preferredSize();
        Dimension dimension3 = this.components[1].preferredSize();
        Dimension dimension4 = this.components[2].preferredSize();
        Insets insets = this.Parent.insets();
        dimension.height = dimension2.height + 6 + dimension3.height + dimension4.height + insets.top + insets.bottom;
        int n = dimension2.width > dimension4.width ? dimension2.width : dimension4.width;
        n = n > dimension3.width ? n : dimension3.width;
        dimension.width = insets.left + insets.right + n;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = this.components[0].minimumSize();
        Dimension dimension3 = this.components[1].minimumSize();
        Dimension dimension4 = this.components[2].minimumSize();
        Insets insets = this.Parent.insets();
        dimension.height = dimension2.height + 6 + dimension3.height + dimension4.height + insets.top + insets.bottom;
        int n = dimension2.width > dimension4.width ? dimension2.width : dimension4.width;
        n = n > dimension3.width ? n : dimension3.width;
        dimension.width = insets.left + insets.right + n;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n = container.size().width - (insets.left + insets.right);
        int n2 = container.size().height - (insets.top + insets.bottom);
        int n3 = this.components[1].minimumSize().height;
        this.pixelBorder = n2 * this.percentBorder / 100;
        this.components[0].reshape(insets.left, insets.top, n, this.pixelBorder);
        this.components[1].reshape(insets.left, insets.top + this.pixelBorder + 6, n, n3);
        this.components[2].reshape(insets.left, insets.top + this.pixelBorder + 6 + n3, n, n2 - this.pixelBorder - 6 - n3);
    }

    public void paintBorderLine(Graphics graphics) {
        int n = this.pixelBorder;
        Dimension dimension = this.Parent.size();
        Insets insets = this.Parent.insets();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(insets.left, insets.top + n, dimension.width, 6);
        graphics.setColor(this.Parent.isDragged ? Color.white : Color.black);
        graphics.drawLine(insets.left + 2, insets.top + n + 2, insets.left + dimension.width - 2, insets.top + n + 2);
        graphics.setColor(this.Parent.isDragged ? Color.black : Color.white);
        graphics.drawLine(insets.left + 2, insets.top + n + 3, insets.left + dimension.width - 2, insets.top + n + 3);
    }
}

