/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.awt.treeview;

import com.sfs.awt.treeview.Folder;
import com.sfs.awt.treeview.RootFolder;

public class Item {
    boolean Disabled = false;
    boolean Selected = false;
    Object Item;
    String Name;
    boolean Opened;
    int iconType;
    int Spaces;
    RootFolder Owner;
    protected Folder Parent;

    protected Item(RootFolder rootFolder, Folder folder, String string, Object object) {
        this.Item = object;
        this.Name = string;
        this.Opened = false;
        this.Parent = folder;
        this.iconType = 4;
        this.Owner = rootFolder;
        this.Spaces = folder != null ? folder.getSpaces() + 1 : 0;
    }

    public String getAbsoluteName() {
        String string = this.getName();
        Item item = this;
        while ((item = item.getParent()) != null) {
            string = String.valueOf(item.getName()) + "\\" + string;
        }
        return string;
    }

    public Folder getParent() {
        return this.Parent;
    }

    public Object getContent() {
        return this.Item;
    }

    public void setContent(Object object) {
        this.Item = object;
    }

    public boolean isVisible() {
        Item item = this;
        while ((item = item.getParent()) != null && item.isOpen()) {
        }
        return item == null;
    }

    public boolean isDisabled() {
        if (this.Disabled) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isDisabled();
        }
        return false;
    }

    public void setDisabled(boolean bl) {
        this.Disabled = bl;
    }

    public boolean isSelected() {
        if (this.Selected) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isSelected();
        }
        return false;
    }

    public int getSelectedDistance() {
        if (this.Selected) {
            return 0;
        }
        if (this.getParent() == null || !this.getParent().isSelected()) {
            return -1;
        }
        int n = 0;
        Item item = this;
        while ((item = item.getParent()) != null) {
            if (!item.isSelected()) break;
            ++n;
        }
        return n;
    }

    public void setSelected(boolean bl) {
        if (this.Selected != bl && this.Owner != null) {
            if (bl) {
                this.Owner.addSelectedItem(this);
            } else {
                this.Owner.removeSelectedItem(this);
            }
        }
        this.Selected = bl;
    }

    protected Item(RootFolder rootFolder, Folder folder, String string, Object object, int n) {
        this(rootFolder, folder, string, object);
        this.iconType = n;
    }

    public boolean isOpen() {
        return this.Opened;
    }

    public int getSpaces() {
        return this.Spaces;
    }

    public int getDocumentType() {
        return this.iconType;
    }

    public void setDocumentType(int n) {
        this.iconType = n;
    }

    public void setOpen(boolean bl) {
        this.Opened = bl;
    }

    public String toString() {
        return this.Name;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = new String(string);
    }

    public boolean[] getSpacesArray() {
        int n = this.Spaces;
        boolean[] blArray = new boolean[n--];
        if (n == -1) {
            return blArray;
        }
        blArray[n--] = true;
        Folder folder = this.getParent();
        while (n != -1) {
            Folder folder2 = folder.getParent();
            blArray[n] = folder2 != null && !folder2.isLastElement(folder);
            folder = folder2;
            --n;
        }
        return blArray;
    }
}

