/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.awt.treeview;

import com.sfs.awt.treeview.Folder;
import com.sfs.awt.treeview.Item;
import com.sfs.awt.treeview.TreeView;
import com.sfs.util.Insertionsort;
import com.sfs.util.Sortable;
import java.awt.FontMetrics;
import java.util.Vector;

public class RootFolder
extends Folder
implements Sortable {
    public Vector Rows = new Vector();
    public FontMetrics fm;
    TreeView View;
    Vector Selection;
    Item caretItem;
    public Insertionsort Sorter;

    public RootFolder(TreeView treeView, String string, Object object) {
        this(null, string, object, 0);
        this.View = treeView;
    }

    RootFolder(TreeView treeView, String string, Object object, int n) {
        super(null, null, string, object, n);
        this.Owner = this;
        this.Selection = new Vector();
        this.setOpen(true);
        this.insertItem(this);
        this.Sorter = new Insertionsort(this);
    }

    public int compare(Object object, Object object2) {
        return 0;
    }

    public synchronized void setSorter(Sortable sortable) {
        this.Sorter = new Insertionsort(sortable);
    }

    public void clearSelection() {
        while (this.Selection.size() > 0) {
            ((Item)this.Selection.elementAt(0)).setSelected(false);
        }
    }

    protected void removeSelectedItem(Item item) {
        this.Selection.removeElement(item);
    }

    protected void addSelectedItem(Item item) {
        this.Selection.addElement(item);
    }

    protected boolean isSelectedItem(Item item) {
        return this.Selection.contains(item);
    }

    public Vector getSelection() {
        return this.Selection;
    }

    public Item getLastSelectedItem() {
        if (this.Selection.size() == 0) {
            return null;
        }
        return (Item)this.Selection.lastElement();
    }

    public Item getCaretItem() {
        return this.caretItem;
    }

    protected void setCaretItem(Item item) {
        this.caretItem = item;
    }

    public int getHeight() {
        int n = 0;
        int n2 = this.Rows.size();
        while (n2-- > 0) {
            if (!this.getItemAt(n2).isVisible()) continue;
            ++n;
        }
        return n;
    }

    public void insertItem2(Item item) {
        Folder folder = item.getParent();
        int n = 0;
        if (folder != null) {
            if (folder.Root.size() == 1) {
                n = this.indexOf(folder) + 1;
            } else if (folder.Root.indexOf(item) == folder.Root.size() - 1) {
                n = this.indexOf(folder) + folder.size();
                if (folder.size() > 0) {
                    int n2 = folder.getSpaces();
                    while (n < this.Rows.size() && (this.getItemAt(n).getSpaces() > n2 || this.getItemAt(n).getParent() == folder)) {
                        ++n;
                    }
                }
            } else {
                n = this.indexOf(folder.getItem(folder.Root.indexOf(item) + 1));
            }
        }
        this.Rows.insertElementAt(item, n);
    }

    public synchronized void insertItem(Item item) {
        Folder folder = item.getParent();
        int n = 0;
        if (folder != null) {
            if (folder.Root.size() == 1) {
                n = this.indexOf(folder) + 1;
            } else if (folder.Root.indexOf(item) == folder.Root.size() - 1) {
                n = this.indexOf(folder) + folder.size();
                if (folder.size() > 0) {
                    int n2 = folder.getSpaces();
                    while (n < this.Rows.size() && (this.getItemAt(n).getSpaces() > n2 || this.getItemAt(n).getParent() == folder)) {
                        ++n;
                    }
                }
            } else {
                n = this.indexOf(folder.getItem(folder.Root.indexOf(item) + 1));
            }
        }
        this.Rows.insertElementAt(item, n);
    }

    public void AdjustScrollbars() {
        if (this.fm == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Item item = this.visibleItemAt(0);
        int n3 = this.indexOf(item);
        while (true) {
            int n4;
            if ((n4 = item.getSpaces() * 17 + 16 + this.fm.stringWidth(item.getName())) > n2) {
                n2 = n4;
            }
            ++n;
            item = this.nextVisibleItem(n3);
            if (item == null) break;
            n3 = this.indexOf(item);
        }
        if (this.View != null) {
            this.View.setScrollbars(n, n2 / 17);
        }
    }

    public Item visibleItemAt(int n) {
        Item item = null;
        while (n < this.Rows.size()) {
            item = this.getItemAt(n);
            ++n;
            if (!item.isVisible()) continue;
        }
        if (n > this.Rows.size()) {
            return null;
        }
        return item;
    }

    public Item nextVisibleItem(int n) {
        Item item = null;
        while (++n < this.Rows.size() && !(item = this.getItemAt(n)).isVisible()) {
        }
        if (n == this.Rows.size()) {
            return null;
        }
        return item;
    }

    public Item prevVisibleItem(int n) {
        Item item = null;
        while (--n > -1 && !(item = this.getItemAt(n)).isVisible()) {
        }
        if (n == -1) {
            return null;
        }
        return item;
    }

    public Item getItemAt(int n) {
        try {
            return (Item)this.Rows.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized int indexOf(Item item) {
        return this.Rows.indexOf(item);
    }

    public void removeItem(Item item) {
        this.removeItemAt(this.indexOf(item));
    }

    public void removeItemAt(int n) {
        Item item = (Item)this.Rows.elementAt(n);
        int n2 = item.getSpaces();
        do {
            this.Rows.removeElementAt(n);
        } while (this.Rows.size() > n && ((Item)this.Rows.elementAt(n)).getSpaces() > n2);
    }

    public String toString() {
        String string = "RootFolder ->\n";
        int n = 0;
        while (n < this.Rows.size()) {
            Item item = (Item)this.Rows.elementAt(n);
            String string2 = item.getName();
            int n2 = item.getSpaces();
            string = String.valueOf(string) + Integer.toString(n) + "\t:";
            while (n2-- > 0) {
                string = String.valueOf(string) + " ";
            }
            string = String.valueOf(string) + string2 + "\n";
            ++n;
        }
        string = String.valueOf(string) + "_________________________________________________\n";
        return string;
    }
}

