/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.awt.treeview;

import com.sfs.awt.treeview.Folder;
import com.sfs.awt.treeview.Item;
import com.sfs.awt.treeview.RootFolder;
import com.sfs.awt.treeview.TreeViewEventObject;
import com.sfs.awt.treeview.TreeViewException;
import com.sfs.awt.treeview.TreeViewListener;
import com.sfs.util.Sortable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Vector;

public class TreeView
extends Panel
implements AdjustmentListener {
    public int ofsX;
    public int ofsY;
    static final int FOLDER = 0;
    static final int OPENFOLDER = 1;
    static final int PLUS = 2;
    static final int MINUS = 3;
    static final int DOCUMENT = 4;
    static final int OPENDOCUMENT = 5;
    static final int EMPTYDOCUMENT = 6;
    static final int EMPTYOPENDOCUMENT = 7;
    public static final int DISTANCE = 17;
    public RootFolder Root;
    Vector Icons = new Vector(8);
    ImageObserver iObserver;
    public boolean doPaint = true;
    MediaTracker mt;
    Scrollbar Hor = new Scrollbar(0);
    Scrollbar Ver = new Scrollbar(1);
    protected Vector TreeViewListeners = new Vector();
    Dimension dimension = new Dimension(100, 200);
    boolean haveFocus = false;
    public boolean SelectionAllowed = true;
    Image Background;
    Image texture;
    Graphics bg;

    public TreeView(Applet applet, String string, Object object) {
        this(string, object);
        this.iObserver = applet;
        this.mt = new MediaTracker(this);
        Class<?> clazz = this.getClass();
        int n = 0;
        while (n < this.Icons.capacity()) {
            Image image = applet.getImage(clazz.getResource(String.valueOf(Integer.toString(n)) + ".gif"));
            this.Icons.addElement(image);
            this.mt.addImage(image, n);
            ++n;
        }
        try {
            this.mt.waitForAll();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public TreeView(Frame frame, String string, Object object) {
        this(string, object);
        this.iObserver = frame;
        this.mt = new MediaTracker(this);
        Class<?> clazz = this.getClass();
        int n = 0;
        while (n < this.Icons.capacity()) {
            Image image = frame.getToolkit().getImage(clazz.getResource(String.valueOf(Integer.toString(n)) + ".gif"));
            this.Icons.addElement(image);
            this.mt.addImage(image, n);
            ++n;
        }
        try {
            this.mt.waitForAll();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void setTexture(Image image) {
        this.texture = image;
    }

    public void setSorter(Sortable sortable) {
        this.Root.setSorter(sortable);
    }

    public void setAllowSelection(boolean bl) {
        this.SelectionAllowed = bl;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected TreeView(String string, Object object) {
        this.Root = new RootFolder(this, string, object);
        this.Hor.addAdjustmentListener(this);
        this.Ver.addAdjustmentListener(this);
        this.setLayout(new BorderLayout());
        this.Ver.setUnitIncrement(1);
        this.Ver.setVisibleAmount(0);
        this.Ver.setBlockIncrement(1);
        this.Hor.setUnitIncrement(1);
        this.Hor.setVisibleAmount(0);
        this.Hor.setBlockIncrement(1);
        this.Root.caretItem = this.Root;
        this.setBackground(Color.white);
        this.enableEvents(28L);
    }

    public Dimension getMinimumSize() {
        return this.dimension;
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public void setSize(Dimension dimension) {
        this.dimension = dimension;
        this.Background = null;
        this.validate();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.dimension = this.getSize();
        this.setSize(this.dimension);
        this.validate();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.dimension = this.getSize();
        this.Background = null;
        this.Root.AdjustScrollbars();
        this.validate();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            switch (focusEvent.getID()) {
                case 1004: {
                    this.haveFocus = true;
                    return;
                }
                case 1005: {
                    this.haveFocus = false;
                    return;
                }
            }
        }
    }

    private void processSelection(InputEvent inputEvent, Item item) {
        if (!this.SelectionAllowed) {
            return;
        }
        if ((inputEvent.getModifiers() & 3) == 0) {
            this.Root.clearSelection();
        }
        if (inputEvent.isControlDown() && inputEvent instanceof MouseEvent) {
            if (this.Root.getCaretItem().isSelected()) {
                this.Root.getCaretItem().setSelected(false);
                return;
            }
            if (!(this.Root.getCaretItem() instanceof Folder) || !this.Root.getCaretItem().isOpen()) {
                this.Root.getCaretItem().setSelected(true);
            }
            return;
        }
        if (inputEvent.isShiftDown()) {
            int n;
            int n2 = this.Root.indexOf(this.Root.getCaretItem());
            if (n2 > (n = this.Root.indexOf(item))) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            Item item2 = this.Root.visibleItemAt(n2++);
            do {
                if (!(item2 instanceof Folder) || !item2.isOpen()) {
                    item2.setSelected(true);
                }
                n2 = this.Root.indexOf(item2);
                item2 = this.Root.nextVisibleItem(n2);
            } while (n2 < n);
        }
    }

    /*
     * Exception decompiling
     */
    protected void processKeyEvent(KeyEvent var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            int n = this.dimension.height / 17;
            this.Root.getSpaces();
            if (n >= this.Root.getHeight()) {
                n = this.Root.getHeight() - 1;
            }
            Item item = this.Root.visibleItemAt(this.ofsY);
            int n2 = this.Root.indexOf(item);
            int n3 = 0;
            Point point = mouseEvent.getPoint();
            do {
                Rectangle rectangle;
                Rectangle rectangle2;
                if ((rectangle2 = new Rectangle(10 + (item.getSpaces() - this.ofsX) * 17 - 8, 10 + n3 * 17 - 9, 17 + this.Root.fm.stringWidth(item.getName()) + 4, 17)).contains(point)) {
                    if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 3) == 0) {
                        item.setOpen(!item.isOpen());
                    }
                    this.processSelection(mouseEvent, item);
                    this.Root.caretItem = item;
                    this.Root.AdjustScrollbars();
                    this.repaint(500L);
                    this.castTreeViewEvent(item, mouseEvent.getClickCount());
                    break;
                }
                if (item instanceof Folder && (rectangle = new Rectangle(10 + (item.getSpaces() - 1 - this.ofsX) * 17 - 4, 10 + n3 * 17 - 4, 13, 13)).contains(point)) {
                    if ((mouseEvent.getModifiers() & 3) == 0) {
                        item.setOpen(!item.isOpen());
                    }
                    this.processSelection(mouseEvent, item);
                    this.Root.caretItem = item;
                    this.Root.AdjustScrollbars();
                    this.repaint(500L);
                    this.castTreeViewEvent(item, mouseEvent.getClickCount());
                    break;
                }
                item = this.Root.nextVisibleItem(n2);
                if (item == null) break;
                n2 = this.Root.indexOf(item);
            } while (n3++ < n);
        }
        super.processMouseEvent(mouseEvent);
    }

    public void update(Graphics graphics) {
        if (this.doPaint) {
            this.paint(graphics);
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        Serializable serializable;
        if (!this.doPaint) {
            return;
        }
        this.Background = this.createImage(this.dimension.width, this.dimension.height);
        this.bg = this.Background.getGraphics();
        if (this.bg == null) {
            return;
        }
        if (this.texture == null) {
            this.bg.setColor(this.getBackground());
            this.bg.fillRect(0, 0, this.dimension.width, this.dimension.height);
        } else {
            serializable = this.dimension;
            Dimension dimension = new Dimension(this.texture.getWidth(this.iObserver), this.texture.getHeight(this.iObserver));
            if (dimension.height == -1) {
                this.bg.setColor(this.getBackground());
                this.bg.fillRect(0, 0, this.dimension.width, this.dimension.height);
            }
            int n2 = 0;
            while (n2 < serializable.height) {
                n = 0;
                while (n < serializable.width) {
                    this.bg.drawImage(this.texture, n, n2, this.iObserver);
                    n += dimension.width;
                }
                n2 += dimension.height;
            }
        }
        this.bg.setColor(Color.black);
        if (this.Root.fm == null) {
            serializable = this.getGraphics().getFontMetrics();
            this.Root.fm = serializable;
            this.Root.AdjustScrollbars();
        }
        if (this.mt.statusAll(true) == 5) {
            this.bg.drawString("loading icons ...", 10, 10);
        } else {
            Object object;
            int n3 = this.dimension.width / 17;
            int n4 = this.dimension.height / 17;
            this.Root.getSpaces();
            if (n4 >= this.Root.getHeight()) {
                n4 = this.Root.getHeight() - 1;
            }
            Item item = this.Root.visibleItemAt(this.ofsY);
            n = this.Root.indexOf(item);
            int n5 = 0;
            do {
                object = item.getSpacesArray();
                int n6 = 0;
                while (n6 < item.getSpaces() && n6 < n3) {
                    if (object[n6]) {
                        this.bg.drawLine(10 + (n6 - this.ofsX) * 17, 10 + (n5 - 1) * 17, 10 + (n6 - this.ofsX) * 17, 10 + (n5 - 1) * 17 + 17);
                    }
                    ++n6;
                }
                if (item != this.Root) {
                    this.bg.drawLine(10 + (item.getSpaces() - 1 - this.ofsX) * 17, 10 + n5 * 17, 10 + (item.getSpaces() - this.ofsX) * 17, 10 + n5 * 17);
                }
                if ((item = this.Root.nextVisibleItem(n)) == null) break;
                n = this.Root.indexOf(item);
            } while (n5++ < n4);
            item = this.Root.visibleItemAt(this.ofsY);
            n = this.Root.indexOf(item);
            n5 = 0;
            do {
                object = (Image)this.Icons.elementAt(item.isOpen() ? item.getDocumentType() + 1 : item.getDocumentType());
                this.bg.drawImage((Image)object, 10 + (item.getSpaces() - this.ofsX) * 17 - 8, 10 + n5 * 17 - 8, this);
                if (this.Root.isSelectedItem(item) || item == this.Root.getCaretItem()) {
                    this.bg.setColor(Color.blue);
                    this.bg.fillRect(9 + (item.getSpaces() - this.ofsX) * 17 + 17 - 6, 10 + n5 * 17 - 9, this.Root.fm.stringWidth(item.getName()) + 4, 17);
                    if (item == this.Root.getCaretItem() && this.haveFocus) {
                        this.bg.setColor(Color.red);
                        this.bg.drawRect(9 + (item.getSpaces() - this.ofsX) * 17 + 17 - 6, 10 + n5 * 17 - 9, this.Root.fm.stringWidth(item.getName()) + 4, 16);
                    }
                    this.bg.setColor(Color.white);
                    this.bg.setColor(item.isDisabled() ? Color.gray : Color.white);
                } else {
                    this.bg.setColor(item.isDisabled() ? Color.gray : Color.black);
                }
                this.bg.drawString(item.getName(), 10 + (item.getSpaces() - this.ofsX) * 17 + 17 - 5, 10 + n5 * 17 + 5);
                this.bg.setColor(Color.black);
                if (item instanceof Folder && item != this.Root && ((Folder)item).size() > 0) {
                    object = (Image)this.Icons.elementAt(item.isOpen() ? 3 : 2);
                    this.bg.drawImage((Image)object, 10 + (item.getSpaces() - 1 - this.ofsX) * 17 - 4, 10 + n5 * 17 - 4, this);
                }
                if ((item = this.Root.nextVisibleItem(n)) == null) break;
                n = this.Root.indexOf(item);
            } while (n5++ < n4);
        }
        this.bg.dispose();
        graphics.drawImage(this.Background, 0, 0, this);
    }

    public void setScrollbars(int n, int n2) {
        if (n * 17 + 17 < this.dimension.height && this.isAncestorOf(this.Ver)) {
            this.ofsY = 0;
            this.remove(this.Ver);
            this.validate();
        } else if (n * 17 + 17 >= this.dimension.height && !this.isAncestorOf(this.Ver)) {
            this.add("East", this.Ver);
            this.validate();
        }
        if (n2 * 17 + 17 < this.dimension.width && this.isAncestorOf(this.Hor)) {
            this.ofsX = 0;
            this.remove(this.Hor);
            this.validate();
        } else if (n2 * 17 + 17 >= this.dimension.width && !this.isAncestorOf(this.Hor)) {
            this.add("South", this.Hor);
            this.validate();
        }
        this.Ver.setMaximum(n - 1);
        this.Hor.setMaximum(n2 - 1);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Scrollbar scrollbar = (Scrollbar)adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        if (scrollbar == this.Hor) {
            this.ofsX = n;
        } else {
            Item item = this.Root.visibleItemAt(0);
            int n2 = this.Root.indexOf(item);
            int n3 = 0;
            while (n != n3) {
                item = this.Root.nextVisibleItem(n2);
                n2 = this.Root.indexOf(item);
                ++n3;
            }
            this.ofsY = n2;
        }
        this.repaint(500L);
    }

    private synchronized void castTreeViewEvent(Item item, int n) {
        int n2 = item.isOpen() ? (item instanceof Folder ? 1 : 3) : (item instanceof Folder ? 0 : 2);
        TreeViewEventObject treeViewEventObject = new TreeViewEventObject(n2, item, n, this);
        int n3 = 0;
        while (n3 < this.TreeViewListeners.size()) {
            ((TreeViewListener)this.TreeViewListeners.elementAt(n3)).handleTreeViewEvent(treeViewEventObject);
            ++n3;
        }
    }

    public synchronized void addTreeViewListener(TreeViewListener treeViewListener) {
        this.TreeViewListeners.addElement(treeViewListener);
    }

    public synchronized void removeTreeViewListener(TreeViewListener treeViewListener) {
        this.TreeViewListeners.removeElement(treeViewListener);
    }

    public Folder addFolder(String string, Object object, int n) throws TreeViewException {
        return this.Root.addFolder(string, object, n);
    }

    public Folder addFolder(String string, Object object) throws TreeViewException {
        return this.Root.addFolder(string, object);
    }

    public Item addItem(String string, Object object, int n) throws TreeViewException {
        Item item = null;
        item = new Item(this.Root, this.Root, string, object, n);
        this.Root.add(item);
        return item;
    }

    public Item addItem(String string, Object object) throws TreeViewException {
        Item item = null;
        item = new Item(this.Root, this.Root, string, object);
        this.Root.add(item);
        return item;
    }

    public int useIcon(Image image, Image image2) {
        this.Icons.addElement(image);
        this.Icons.addElement(image2);
        return this.Icons.size() - 2;
    }
}

