/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.base;

import com.sfs.base.commitdialog.CommitDialog;
import com.sfs.debug.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class SFSFramedApp
extends Frame {
    Properties properties;
    Properties args;
    PropertyResourceBundle text;
    Hashtable images;
    public Debug debug = new Debug();
    String UserHomePath = "";

    public SFSFramedApp(String[] stringArray) {
        Object object;
        Object object2;
        ((Component)this).setBackground(Color.lightGray);
        this.properties = this.loadProperties(String.valueOf(this.UserHomePath) + this.getClass().getName() + ".properties");
        try {
            this.text = new PropertyResourceBundle(this.getClass().getResourceAsStream("text.properties"));
        }
        catch (Exception exception) {
            exception.printStackTrace(this.debug);
        }
        this.args = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            if (((String)object2).startsWith("-")) {
                if (n + 1 < stringArray.length) {
                    object = stringArray[n + 1];
                    if (!((String)object).startsWith("-")) {
                        ((Hashtable)this.args).put(object2, object);
                        ++n;
                    }
                } else {
                    ((Hashtable)this.args).put(object2, "");
                }
            }
            ++n;
        }
        this.images = new Hashtable();
        try {
            object2 = new PropertyResourceBundle(this.getClass().getResourceAsStream("images.properties"));
            object = new MediaTracker(this);
            Enumeration<String> enumeration = ((PropertyResourceBundle)object2).getKeys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(((ResourceBundle)object2).getString(string)));
                this.images.put(string, image);
                ((MediaTracker)object).addImage(image, n2);
                ++n2;
            }
            ((MediaTracker)object).waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace(this.debug);
        }
        this.enableEvents(64L);
    }

    public boolean saveSettings(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.UserHomePath) + this.getClass().getName() + ".properties");
            this.properties.save(fileOutputStream, string);
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.debug);
            return false;
        }
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public void setProperty(String string, String string2) {
        ((Hashtable)this.properties).put(string, string2);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201 && this.onExit()) {
            this.saveSettings("SFSFramedApp - All rights reserved by SFS-SOFTWARE \u00a91999");
            this.dispose();
            System.exit(0);
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean onExit() {
        return true;
    }

    public Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            this.debug.log("unable to load property file");
        }
        return properties;
    }

    public Properties loadProperties(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            this.debug.log("unable to load property file");
        }
        return properties;
    }

    public boolean saveProperties(String string, Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.save(fileOutputStream, "SFSFramedApp - All rights reserved by SFS-SOFTWARE \u00a91999");
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(this.debug);
            return false;
        }
    }

    public Image getImage(String string) {
        return (Image)this.images.get(string);
    }

    public boolean askForCommit(String string, String string2) {
        CommitDialog commitDialog = new CommitDialog((Frame)this, string, string2);
        return commitDialog.accept();
    }

    public boolean askForCommit(String string, Panel panel) {
        CommitDialog commitDialog = new CommitDialog((Frame)this, string, panel);
        return commitDialog.accept();
    }

    public boolean askForCommit(String string, Panel panel, boolean bl) {
        CommitDialog commitDialog = new CommitDialog((Frame)this, string, panel, bl);
        return commitDialog.accept();
    }

    public String getText(String string) {
        return this.text.getString(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getArgs() {
        return this.args;
    }

    public String getArg(String string) {
        return this.args.getProperty(string);
    }

    public String getArg(String string, String string2) {
        return this.args.getProperty(string, string2);
    }
}

