/*
 * Decompiled with CFR 0.152.
 */
package com.sfs.os;

import java.io.File;
import java.util.Vector;

public class OS {
    static boolean iswindows;
    static boolean ismsvm;
    static boolean isos2;
    static boolean initialized;
    static Vector Drives;

    public static Vector getDrives() {
        OS.initialize();
        if (Drives.size() != 0) {
            return Drives;
        }
        Drives.addElement("A:");
        Drives.addElement("B:");
        char[] c = new char[]{'C', ':'};
        while (c[0] <= 'Z') {
            String drive = new String(c);
            File file = new File(drive + File.separator);
            if (file.isDirectory()) {
                Drives.addElement(drive);
            }
            c[0] = (char)(c[0] + '\u0001');
        }
        return Drives;
    }

    public static boolean isMsVM() {
        OS.initialize();
        return ismsvm;
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        Drives = new Vector(28);
        if (System.getProperty("os.name").startsWith("Windows", 0)) {
            iswindows = true;
        } else {
            iswindows = false;
            isos2 = System.getProperty("os.name").startsWith("OS/2", 0);
        }
        ismsvm = System.getProperty("java.vendor").equals("Microsoft Corp.");
        initialized = true;
    }

    public static boolean isOS2() {
        OS.initialize();
        return isos2;
    }

    public static boolean isWindows() {
        OS.initialize();
        return iswindows;
    }

    public static boolean hasDrives() {
        OS.initialize();
        return isos2 || iswindows;
    }

    public static void main(String[] args) {
        System.out.println("drives: " + OS.getDrives() + System.getProperty("os.name"));
        System.out.println(OS.isWindows() ? "isWindows=true" : "isWindows=false");
        System.getProperties().list(System.out);
    }

    static {
        initialized = false;
        Drives = null;
    }
}

