/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.net.*;
import javax.swing.text.html.*;

public class HelpDialog extends JDialog implements HyperlinkListener
{
   JEditorPane editorPane = new JEditorPane();
   JScrollPane editorScrollPane = new JScrollPane(editorPane);
   JTextField location = new JTextField();
   JLabel status = new JLabel();

   HelpDialog(JFrame frame)
   {
      super(frame,"Help",false);
      editorPane.setEditable(false);
      String s = "file:"
               + System.getProperty("user.dir")
               + System.getProperty("file.separator")
               + "DiskIndexer.html";
      try
      {
         URL helpURL = new URL(s);
         editorPane.setPage(helpURL);
         editorPane.addHyperlinkListener(this);
         editorScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
         editorScrollPane.setPreferredSize(new Dimension(400, 300));
         location.setText(s);

         JPanel locationPane = new JPanel();
         locationPane.setLayout(new BoxLayout(locationPane, BoxLayout.X_AXIS));
         locationPane.add(new JLabel("Location:"));
         locationPane.add(Box.createRigidArea(new Dimension(5,0)));
         locationPane.add(location);

         JPanel dialogPane = new JPanel(new BorderLayout(5,5));
         dialogPane.add(locationPane,"North");
         dialogPane.add(editorScrollPane,"Center");
            dialogPane.add(status,"South");
         dialogPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

         this.getContentPane().add(dialogPane);
         this.pack();
         setLocationRelativeTo(frame);
      }
      catch(IOException e)
      {
         JOptionPane.showMessageDialog(frame,"Could not load " + s,"Error",JOptionPane.ERROR_MESSAGE);
         this.dispose();
      }

   }

   public void hyperlinkUpdate(HyperlinkEvent e)
   {
      if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
      {
         JEditorPane pane = (JEditorPane) e.getSource();
         location.setText(e.getURL().toString());

         if (e instanceof HTMLFrameHyperlinkEvent)
         {
            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            doc.processHTMLFrameHyperlinkEvent(evt);
         }
         else
         {
            try
            {
               pane.setPage(e.getURL());
            }
            catch (Throwable t)
            {
               t.printStackTrace();
            }
         }
      }
   }
}

