/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;
import java.text.*;

public class PropertiesDialog extends JDialog implements ActionListener
{
   JButton ok = new JButton("Ok"), cancel = new JButton("Cancel");
   JPanel buttonPane = new JPanel();
   JCheckBox stickButton = new JCheckBox("Stick with selection");
   JTabbedPane tabbedPane = new JTabbedPane();

// page one
   JPanel dialog1Pane;
   HDataNode aNode;
   TreePath aPath;
   JTextField fileNameField, descField, dateField, lengthField, typeField, pathField;

// page two
   JPanel dialog2Pane;
   JTextField titleField, artistField, albumField, yearField, commentField;
   JComboBox genreList;

// page three
   JPanel dialog3Pane;
   ImageIcon thumbnail;
   JLabel thumbnailLabel;

   HDatabase database;

   JFrame mainFrame;
   HDataNode newNode;

   EventListenerList eventListeners = new EventListenerList();

public PropertiesDialog(JFrame frame, HDataNode aNode, TreePath aPath, HDatabase database)
{
   super(frame,aNode + " - Properties", false);
   mainFrame = frame;
   this.aNode = newNode = aNode;
   this.aPath = aPath;
   this.database = database;

// == page one General

   JPanel col1Pane = new JPanel();
   JPanel col2Pane = new JPanel();
   col1Pane.setLayout(new GridLayout(0,1,5,5));
   col2Pane.setLayout(new GridLayout(0,1,5,5));

   col1Pane.add(new JLabel("Filename"));
   fileNameField = new JTextField();
   col2Pane.add(fileNameField);

   col1Pane.add(new JLabel("Description"));
   descField = new JTextField();
   col2Pane.add(descField);

   col1Pane.add(new JLabel("Last Modified"));
   dateField = new JTextField();
   col2Pane.add(dateField);
   dateField.setEditable(false);

   col1Pane.add(new JLabel("Length"));
   lengthField = new JTextField();
   col2Pane.add(lengthField);
   lengthField.setEditable(false);

   col1Pane.add(new JLabel("Type"));
   typeField = new JTextField();
   col2Pane.add(typeField);
   typeField.setEditable(false);

   col1Pane.add(new JLabel("Path"));
   pathField = new JTextField();
   col2Pane.add(pathField);
   pathField.setEditable(false);

   loadGeneral();

   dialog1Pane = new JPanel();
   dialog1Pane.setLayout(new BorderLayout(10,10));
   dialog1Pane.add(col1Pane,"West");
   dialog1Pane.add(col2Pane,"Center");
   dialog1Pane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
   tabbedPane.addTab("General", dialog1Pane);

// == page two stuff ID3 Tag

   JPanel p2col1Pane = new JPanel();
   JPanel p2col2Pane = new JPanel();
   p2col1Pane.setLayout(new GridLayout(0,1,5,5));
   p2col2Pane.setLayout(new GridLayout(0,1,5,5));

   p2col1Pane.add(new JLabel("Title"));
   titleField = new JTextField();
   p2col2Pane.add(titleField);

   p2col1Pane.add(new JLabel("Artist"));
   artistField = new JTextField();
   p2col2Pane.add(artistField);

   p2col1Pane.add(new JLabel("Album"));
   albumField = new JTextField();
   p2col2Pane.add(albumField);

   p2col1Pane.add(new JLabel("Year"));
   yearField = new JTextField();
   p2col2Pane.add(yearField);

   p2col1Pane.add(new JLabel("Comment"));
   commentField = new JTextField();
   p2col2Pane.add(commentField);

   p2col1Pane.add(new JLabel("Genre"));
   genreList = new JComboBox(aNode.id3tag.GENRES);
   p2col2Pane.add(genreList);
   genreList.setSelectedIndex(aNode.id3tag.GENRES.length-1); // unknown

   loadID3Tag();

   dialog2Pane = new JPanel();
   dialog2Pane.setLayout(new BorderLayout(10,10));
   dialog2Pane.add(p2col1Pane,"West");
   dialog2Pane.add(p2col2Pane,"Center");
   dialog2Pane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
   tabbedPane.addTab("ID3 Tag", dialog2Pane);

// == page three stuff Thumbnail

   dialog3Pane = new JPanel();
   dialog3Pane.setLayout(new FlowLayout(FlowLayout.LEFT));
   thumbnailLabel = new JLabel();
   thumbnailLabel.setVerticalAlignment(JLabel.TOP);
   thumbnailLabel.setHorizontalAlignment(JLabel.LEFT);
   thumbnailLabel.setVerticalTextPosition(JLabel.TOP);
   dialog3Pane.add(thumbnailLabel);
   loadThumbnail();
   tabbedPane.addTab("Thumbnail", dialog3Pane);


// == all page stuff

   addWindowListener(new WindowAdapter()
   {
      public void windowClosing(WindowEvent e)
      {
         fireRemoveStickDialog();
         mainFrame.requestFocus();
      }
      boolean focusSet = false;
      public void windowActivated(WindowEvent e)
      {
         if(!focusSet)
            cancel.requestFocus();
         focusSet = true;
      }
   });

   buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
   buttonPane.add(ok);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(cancel);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(stickButton);
   buttonPane.setAlignmentX(LEFT_ALIGNMENT);
   ok.addActionListener(this);
   cancel.addActionListener(this);
   stickButton.addActionListener(this);
   ok.setMnemonic(KeyEvent.VK_O);
   cancel.setMnemonic(KeyEvent.VK_C);
   stickButton.setMnemonic(KeyEvent.VK_S);

   Container dialogPane = this.getContentPane();
   dialogPane.setLayout(new BorderLayout(5,5));
   dialogPane.add(tabbedPane,"Center");
   dialogPane.add(buttonPane,"South");
   this.pack();
   setLocationRelativeTo(frame);
}

public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

   if(command == "Ok")
   {
      if((aNode.fileName == null && fileNameField.getText().length() != 0) ||
         (aNode.desc == null && descField.getText().length() != 0) ||
         (aNode.fileName != null && !fileNameField.getText().equals(aNode.fileName)) ||
         (aNode.desc != null && !descField.getText().equals(aNode.desc)) )
      {
         if(newNode == aNode)
            newNode = (HDataNode) aNode.clone();
         newNode.fileName = fileNameField.getText();
         newNode.desc = descField.getText();
      }

      if( aNode.id3tag == null &&
          ( titleField.getText().length() != 0 ||
            artistField.getText().length() != 0  ||
            albumField.getText().length() != 0  ||
            yearField.getText().length() != 0  ||
            commentField.getText().length() != 0  ||
            genreList.getSelectedIndex() != aNode.id3tag.GENRES.length-1
          )
        )
      {
         if(newNode == aNode)
            newNode = (HDataNode) aNode.clone();

         newNode.id3tag = new ID3Tag();
         newNode.id3tag.title = titleField.getText();
         newNode.id3tag.artist = artistField.getText();
         newNode.id3tag.album = albumField.getText();
         newNode.id3tag.year = yearField.getText();
         newNode.id3tag.comment = commentField.getText();
         newNode.id3tag.genre = genreList.getSelectedIndex();
      }
      else if( aNode.id3tag != null &&
          ( !titleField.getText().equals(aNode.id3tag.title) ||
            !artistField.getText().equals(aNode.id3tag.artist) ||
            !albumField.getText().equals(aNode.id3tag.album) ||
            !yearField.getText().equals(aNode.id3tag.year) ||
            !commentField.getText().equals(aNode.id3tag.comment) ||
            genreList.getSelectedIndex() != aNode.id3tag.genre
          )
        )
      {
         if(newNode == aNode)
            newNode = (HDataNode) aNode.clone();

         newNode.id3tag.title = titleField.getText();
         newNode.id3tag.artist = artistField.getText();
         newNode.id3tag.album = albumField.getText();
         newNode.id3tag.year = yearField.getText();
         newNode.id3tag.comment = commentField.getText();
         newNode.id3tag.genre = genreList.getSelectedIndex();
      }

      if(newNode != aNode)
         fireNodeChanged();

      this.dispose();
      fireRemoveStickDialog();
      mainFrame.requestFocus();
   }
   else if(command == "Cancel")
   {
      this.dispose();
      fireRemoveStickDialog();
      mainFrame.requestFocus();
   }
   else if(command == "Stick with selection")
   {
      if(stickButton.isSelected())
         fireAddStickDialog();
      else
         fireRemoveStickDialog();
   }
}

protected void fireNodeChanged()
{
   Object[] listeners = eventListeners.getListenerList();
   for (int i = listeners.length-2; i>=0; i-=2)
      if (listeners[i]==PropertiesChangeListener.class)
         ((PropertiesChangeListener) listeners[i+1]).nodeChanged(aNode,newNode,aPath);
}

protected void fireAddStickDialog()
{
   Object[] listeners = eventListeners.getListenerList();
   for (int i = listeners.length-2; i>=0; i-=2)
      if (listeners[i]==PropertiesStickListener.class)
         ((PropertiesStickListener) listeners[i+1]).addStickDialog(this);
}

protected void fireRemoveStickDialog()
{
   Object[] listeners = eventListeners.getListenerList();
   for (int i = listeners.length-2; i>=0; i-=2)
      if (listeners[i]==PropertiesStickListener.class)
         ((PropertiesStickListener) listeners[i+1]).removeStickDialog(this);

}

public void addPropertiesStickListener(PropertiesStickListener aListener)
{
   eventListeners.add(PropertiesStickListener.class,aListener);
}

public void removePropertiesStickListener(PropertiesStickListener aListener)
{
   eventListeners.remove(PropertiesStickListener.class,aListener);
}

public void addPropertiesChangeListener(PropertiesChangeListener aListener)
{
   eventListeners.add(PropertiesChangeListener.class,aListener);
}

public void removePropertiesChangeListener(PropertiesChangeListener aListener)
{
   eventListeners.remove(PropertiesChangeListener.class,aListener);
}


public void loadNode(HDataNode aNode, TreePath aPath)
{
   setTitle(aNode + " - Properties");
   this.aNode = newNode = aNode;
   this.aPath = aPath;
   loadGeneral();
   loadID3Tag();
   loadThumbnail();
}

protected void loadGeneral()
{
   fileNameField.setText(aNode.fileName);
   if(aNode.desc == null)
      descField.setText("");
   else
      descField.setText(aNode.desc);
   dateField.setText(DateFormat.getDateTimeInstance(DateFormat.FULL,DateFormat.FULL).format(new Date(aNode.dateModified)));
   lengthField.setText(NumberFormat.getInstance().format(aNode.length));

   String typeDesc = null;
   switch(aNode.type)
   {
      case aNode.f: typeDesc = "Data File"; break;
      case aNode.d: typeDesc = "Disk Directory"; break;
      case aNode.v: typeDesc = "Disk Volume"; break;
      case aNode.c: typeDesc = "Container"; break;
      case aNode.z: typeDesc = "Zip File"; break;
   }
   typeField.setText(typeDesc);

   String path = "";
   if(aPath == null)
      path = "/";
   else
      for(int i = 0; i < aPath.getPathCount(); i++)
         path += "/" + aPath.getPathComponent(i);
   pathField.setText(path);

}


protected void loadID3Tag()
{
   if(aNode.id3tag != null)
   {
      titleField.setText(aNode.id3tag.title);
      artistField.setText(aNode.id3tag.artist);
      albumField.setText(aNode.id3tag.album);
      yearField.setText(aNode.id3tag.year);
      commentField.setText(aNode.id3tag.comment);
      if(aNode.id3tag.genre >= aNode.id3tag.GENRES.length)
         genreList.setSelectedIndex(aNode.id3tag.GENRES.length-1);
      else
         genreList.setSelectedIndex(aNode.id3tag.genre);
   }
   else
   {
      titleField.setText("");
      artistField.setText("");
      albumField.setText("");
      yearField.setText("");
      commentField.setText("");
      genreList.setSelectedIndex(aNode.id3tag.GENRES.length-1); // unknown
   }
}

protected void loadThumbnail()
{
   try
   {
      if(database.retrieveBlob(aNode))
      {
         thumbnailLabel.setIcon(new ImageIcon(aNode.thumbnail));
         thumbnailLabel.setText(aNode.width + "x" + aNode.height);
      }
      else
      {
         thumbnailLabel.setIcon(null);
         thumbnailLabel.setText("No thumbnail.");
      }
   }
   catch(IOException e)
   {
      thumbnailLabel.setIcon(null);
      thumbnailLabel.setText("No thumbnail. Error reading database.");
   }
}

protected void finalize() throws Throwable
{
   aNode = null;
   aPath = null;

   database = null;
   newNode = null;

   eventListeners = null;

   super.finalize();
}

public static void showDialog(JFrame frame, HDataNode aNode, TreePath aPath, HDatabase database, PropertiesStickListener stickListener, PropertiesChangeListener changeListener)
{
   PropertiesDialog dialog = new PropertiesDialog(frame,aNode,aPath,database);
   dialog.addPropertiesStickListener(stickListener);
   dialog.addPropertiesChangeListener(changeListener);
   dialog.setVisible(true);
}


}

