/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.plugins.Filename.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jmp3renamer.DataManager;
import net.sf.jmp3renamer.DataSet;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.MagicCookieBaker;
import net.sf.jmp3renamer.gui.components.historycombobox.JHistoryComboBox;
import net.sf.jmp3renamer.gui.components.historycombobox.SuggestingJHistoryComboBox;
import net.sf.jmp3renamer.plugins.Filename.Filename;
import net.sf.jmp3renamer.util.MyFile;

public class FilenamePanel
extends JPanel
implements ActionListener,
KeyListener,
ItemListener,
Observer {
    private JPanel explanationPanel = new JPanel();
    private JPanel actionPanel = new JPanel();
    private JLabel lOldname = new JLabel();
    private JLabel lOldnameView = new JLabel();
    private JLabel lNewname = new JLabel();
    private JLabel lNewnameView = new JLabel();
    private JHistoryComboBox tUserRegex;
    private JLabel lExplanation = new JLabel();
    private JLabel lMagicCookies = new JLabel();
    private JButton extractDataButton = new JButton();

    public FilenamePanel() {
        this.initGUI();
        FileManager.getInstance().addObserver((Observer)this);
    }

    private void initGUI() {
        this.tUserRegex = new SuggestingJHistoryComboBox(MagicCookieBaker.getCookies(), Filename.getProperties(), "history");
        this.extractDataButton.setText(I18N.translate((String)"extract_data"));
        this.lOldname.setText(I18N.translate((String)"oldname"));
        this.lNewname.setText(I18N.translate((String)"newname"));
        this.lExplanation.setText(I18N.translate((String)"filename_explanation"));
        this.lMagicCookies.setText(MagicCookieBaker.getCookieText());
        if (Filename.getProperty("userRegex") != null) {
            this.tUserRegex.addItem((Object)Filename.getProperty("userRegex"));
        }
        this.lExplanation.setBounds(10, 20, 250, 180);
        this.lMagicCookies.setBounds(20, 180, 250, 160);
        this.explanationPanel.setLayout(null);
        this.explanationPanel.add(this.lExplanation);
        this.explanationPanel.add(this.lMagicCookies);
        this.explanationPanel.setBorder(BorderFactory.createTitledBorder(I18N.translate((String)"explanation")));
        this.actionPanel.setLayout(new GridBagLayout());
        this.actionPanel.add((Component)this.lOldname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.add((Component)this.lOldnameView, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.add((Component)this.tUserRegex, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.add((Component)this.lNewname, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.add((Component)this.lNewnameView, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.add((Component)this.extractDataButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.actionPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.explanationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.actionPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 20, 0), 0, 0));
        this.tUserRegex.setEnabled(false);
        JTextField jTextField = (JTextField)this.tUserRegex.getEditor().getEditorComponent();
        jTextField.addKeyListener(this);
        jTextField.addActionListener(this);
        this.tUserRegex.addItemListener((ItemListener)this);
        this.extractDataButton.setEnabled(false);
        this.extractDataButton.addActionListener(this);
    }

    public void update(Observable observable, Object object) {
        Vector vector = (Vector)object;
        if (vector.size() > 0) {
            MyFile myFile = (MyFile)vector.elementAt(0);
            this.lOldnameView.setText(myFile.getName());
            this.tUserRegex.setEnabled(true);
            this.extractDataButton.setEnabled(true);
            this.preview();
        }
    }

    private void preview() {
        String string;
        String string2 = (String)this.tUserRegex.getEditor().getItem();
        DataSet dataSet = MagicCookieBaker.evaluateCookie((String)string2, (String)(string = this.lOldnameView.getText()));
        if (dataSet != null) {
            this.lNewnameView.setText(MagicCookieBaker.evaluateDataSet((DataSet)dataSet));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("SUGGEST".equals(actionEvent.getActionCommand())) {
            return;
        }
        String string = (String)this.tUserRegex.getEditor().getItem();
        Vector<DataSet> vector = new Vector<DataSet>();
        Vector vector2 = FileManager.getInstance().getFiles();
        for (int i = 0; i < vector2.size(); ++i) {
            MyFile myFile = (MyFile)vector2.elementAt(i);
            String string2 = myFile.getName();
            DataSet dataSet = MagicCookieBaker.evaluateCookie((String)string, (String)string2);
            if (dataSet == null) continue;
            vector.addElement(dataSet);
        }
        DataManager.getInstance().setDatasets(vector);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.preview();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.preview();
    }
}

