/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats;

import java.util.Enumeration;
import java.util.Hashtable;

public class EncodingInfo {
    public static final String FIELD_BITRATE = "BITRATE";
    public static final String FIELD_CHANNEL = "CHANNB";
    public static final String FIELD_INFOS = "INFOS";
    public static final String FIELD_LENGTH = "LENGTH";
    public static final String FIELD_SAMPLERATE = "SAMPLING";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_VBR = "VBR";
    private Hashtable content = new Hashtable(6);

    public EncodingInfo() {
        this.content.put(FIELD_BITRATE, new Integer(-1));
        this.content.put(FIELD_CHANNEL, new Integer(-1));
        this.content.put(FIELD_TYPE, "");
        this.content.put(FIELD_INFOS, "");
        this.content.put(FIELD_SAMPLERATE, new Integer(-1));
        this.content.put(FIELD_LENGTH, new Float(-1.0f));
        this.content.put(FIELD_VBR, new Boolean(true));
    }

    public int getBitrate() {
        return (Integer)this.content.get(FIELD_BITRATE);
    }

    public int getChannelNumber() {
        return (Integer)this.content.get(FIELD_CHANNEL);
    }

    public String getEncodingType() {
        return (String)this.content.get(FIELD_TYPE);
    }

    public String getExtraEncodingInfos() {
        return (String)this.content.get(FIELD_INFOS);
    }

    public int getLength() {
        return (int)this.getPreciseLength();
    }

    public float getPreciseLength() {
        return ((Float)this.content.get(FIELD_LENGTH)).floatValue();
    }

    public int getSamplingRate() {
        return (Integer)this.content.get(FIELD_SAMPLERATE);
    }

    public boolean isVbr() {
        return (Boolean)this.content.get(FIELD_VBR);
    }

    public void setBitrate(int n) {
        this.content.put(FIELD_BITRATE, new Integer(n));
    }

    public void setChannelNumber(int n) {
        this.content.put(FIELD_CHANNEL, new Integer(n));
    }

    public void setEncodingType(String string) {
        this.content.put(FIELD_TYPE, string);
    }

    public void setExtraEncodingInfos(String string) {
        this.content.put(FIELD_INFOS, string);
    }

    public void setLength(int n) {
        this.content.put(FIELD_LENGTH, new Float(n));
    }

    public void setPreciseLength(float f) {
        this.content.put(FIELD_LENGTH, new Float(f));
    }

    public void setSamplingRate(int n) {
        this.content.put(FIELD_SAMPLERATE, new Integer(n));
    }

    public void setVbr(boolean bl) {
        this.content.put(FIELD_VBR, new Boolean(bl));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("Encoding infos content:\n");
        Enumeration enumeration = this.content.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.content.get(k);
            stringBuffer.append("\t");
            stringBuffer.append(k);
            stringBuffer.append(" : ");
            stringBuffer.append(v);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }
}

