/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.data;

import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.data.StreamChunk;
import entagged.audioformats.asf.util.Utils;
import java.math.BigInteger;

public class AudioStreamChunk
extends StreamChunk {
    public static final String[][] CODEC_DESCRIPTIONS = new String[][]{{"161", " (Windows Media Audio (ver 7,8,9))"}, {"162", " (Windows Media Audio 9 series (Professional))"}, {"163", "(Windows Media Audio 9 series (Lossless))"}, {"7A21", " (GSM-AMR (CBR))"}, {"7A22", " (GSM-AMR (VBR))"}};
    private long averageBytesPerSec;
    private int bitsPerSample;
    private long blockAlignment;
    private long channelCount;
    private byte[] codecData;
    private long compressionFormat;
    private GUID errorConcealment;
    private long samplingRate;

    public AudioStreamChunk(long l, BigInteger bigInteger) {
        super(l, bigInteger);
    }

    public long getAverageBytesPerSec() {
        return this.averageBytesPerSec;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public long getBlockAlignment() {
        return this.blockAlignment;
    }

    public long getChannelCount() {
        return this.channelCount;
    }

    public byte[] getCodecData() {
        return this.codecData;
    }

    public String getCodecDescription() {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(this.getCompressionFormat()));
        String string = " (Unknown)";
        for (int i = 0; i < CODEC_DESCRIPTIONS.length; ++i) {
            if (!CODEC_DESCRIPTIONS[i][0].equalsIgnoreCase(stringBuffer.toString())) continue;
            string = CODEC_DESCRIPTIONS[i][1];
            break;
        }
        if (stringBuffer.length() % 2 != 0) {
            stringBuffer.insert(0, "0x0");
        } else {
            stringBuffer.insert(0, "0x");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public long getCompressionFormat() {
        return this.compressionFormat;
    }

    public GUID getErrorConcealment() {
        return this.errorConcealment;
    }

    public int getKbps() {
        return (int)this.getAverageBytesPerSec() * 8 / 1000;
    }

    public long getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isErrorConcealed() {
        return this.getErrorConcealment().equals(GUID.GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED);
    }

    public String prettyPrint() {
        StringBuffer stringBuffer = new StringBuffer(super.prettyPrint().replaceAll(Utils.LINE_SEPARATOR, Utils.LINE_SEPARATOR + "   "));
        stringBuffer.insert(0, Utils.LINE_SEPARATOR + "AudioStream");
        stringBuffer.append("Audio info:" + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Bitrate : " + this.getKbps() + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Channels : " + this.getChannelCount() + " at " + this.getSamplingRate() + " Hz" + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Bits per Sample: " + this.getBitsPerSample() + Utils.LINE_SEPARATOR);
        stringBuffer.append("      Formatcode: " + this.getCodecDescription() + Utils.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public void setAverageBytesPerSec(long l) {
        this.averageBytesPerSec = l;
    }

    public void setBitsPerSample(int n) {
        this.bitsPerSample = n;
    }

    public void setBlockAlignment(long l) {
        this.blockAlignment = l;
    }

    public void setChannelCount(long l) {
        this.channelCount = l;
    }

    public void setCodecData(byte[] byArray) {
        this.codecData = byArray;
    }

    public void setCompressionFormat(long l) {
        this.compressionFormat = l;
    }

    public void setErrorConcealment(GUID gUID) {
        this.errorConcealment = gUID;
    }

    public void setSamplingRate(long l) {
        this.samplingRate = l;
    }
}

