/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.ContentDescriptor;
import entagged.audioformats.asf.data.ExtendedContentDescription;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class ExtContentDescReader {
    public static ExtendedContentDescription read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new ExtContentDescReader().parseData(randomAccessFile);
        }
        return null;
    }

    protected ExtContentDescReader() {
    }

    private ExtendedContentDescription parseData(RandomAccessFile randomAccessFile) throws IOException {
        ExtendedContentDescription extendedContentDescription = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            long l2 = Utils.readUINT16(randomAccessFile);
            extendedContentDescription = new ExtendedContentDescription(l, bigInteger);
            for (long i = 0L; i < l2; ++i) {
                String string = Utils.readUTF16LEStr(randomAccessFile);
                int n = Utils.readUINT16(randomAccessFile);
                ContentDescriptor contentDescriptor = new ContentDescriptor(string, n);
                switch (n) {
                    case 0: {
                        contentDescriptor.setStringValue(Utils.readUTF16LEStr(randomAccessFile));
                        break;
                    }
                    case 1: {
                        contentDescriptor.setBinaryValue(this.readBinaryData(randomAccessFile));
                        break;
                    }
                    case 2: {
                        contentDescriptor.setBooleanValue(this.readBoolean(randomAccessFile));
                        break;
                    }
                    case 3: {
                        randomAccessFile.skipBytes(2);
                        contentDescriptor.setDWordValue(Utils.readUINT32(randomAccessFile));
                        break;
                    }
                    case 5: {
                        randomAccessFile.skipBytes(2);
                        contentDescriptor.setWordValue(Utils.readUINT16(randomAccessFile));
                        break;
                    }
                    case 4: {
                        randomAccessFile.skipBytes(2);
                        contentDescriptor.setQWordValue(Utils.readUINT64(randomAccessFile));
                        break;
                    }
                    default: {
                        contentDescriptor.setStringValue("Invalid datatype: " + new String(this.readBinaryData(randomAccessFile)));
                    }
                }
                extendedContentDescription.addDescriptor(contentDescriptor);
            }
        }
        return extendedContentDescription;
    }

    private byte[] readBinaryData(RandomAccessFile randomAccessFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = Utils.readUINT16(randomAccessFile);
        for (int i = 0; i < n; ++i) {
            byteArrayOutputStream.write(randomAccessFile.read());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean readBoolean(RandomAccessFile randomAccessFile) throws IOException {
        int n = Utils.readUINT16(randomAccessFile);
        if (n != 4) {
            throw new IllegalStateException("Boolean value do require 4 Bytes. (Size value is: " + n + ")");
        }
        long l = Utils.readUINT32(randomAccessFile);
        boolean bl = l == 1L;
        return bl;
    }
}

