/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.asf.io;

import entagged.audioformats.asf.data.Chunk;
import entagged.audioformats.asf.data.GUID;
import entagged.audioformats.asf.data.StreamBitratePropertiesChunk;
import entagged.audioformats.asf.util.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class StreamBitratePropertiesReader {
    public static StreamBitratePropertiesChunk read(RandomAccessFile randomAccessFile, Chunk chunk) throws IOException {
        if (randomAccessFile == null || chunk == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_STREAM_BITRATE_PROPERTIES.equals(chunk.getGuid())) {
            randomAccessFile.seek(chunk.getPosition());
            return new StreamBitratePropertiesReader().parseData(randomAccessFile);
        }
        return null;
    }

    protected StreamBitratePropertiesReader() {
    }

    private StreamBitratePropertiesChunk parseData(RandomAccessFile randomAccessFile) throws IOException {
        StreamBitratePropertiesChunk streamBitratePropertiesChunk = null;
        long l = randomAccessFile.getFilePointer();
        GUID gUID = Utils.readGUID(randomAccessFile);
        if (GUID.GUID_STREAM_BITRATE_PROPERTIES.equals(gUID)) {
            BigInteger bigInteger = Utils.readBig64(randomAccessFile);
            streamBitratePropertiesChunk = new StreamBitratePropertiesChunk(l, bigInteger);
            long l2 = Utils.readUINT16(randomAccessFile);
            int n = 0;
            while ((long)n < l2) {
                int n2 = Utils.readUINT16(randomAccessFile);
                long l3 = Utils.readUINT32(randomAccessFile);
                streamBitratePropertiesChunk.addBitrateRecord(n2 & 0xFF, l3);
                ++n;
            }
        }
        return streamBitratePropertiesChunk;
    }
}

