/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.flac.util;

public class MetadataBlockDataStreamInfo {
    private int samplingRate;
    private int bitsPerSample;
    private int channelNumber;
    private float length;
    private boolean isValid = true;

    public MetadataBlockDataStreamInfo(byte[] byArray) {
        if (byArray.length < 19) {
            this.isValid = false;
            return;
        }
        this.samplingRate = this.readSamplingRate(byArray[10], byArray[11], byArray[12]);
        this.channelNumber = ((this.u(byArray[12]) & 0xE) >>> 1) + 1;
        this.samplingRate /= this.channelNumber;
        this.bitsPerSample = ((this.u(byArray[12]) & 1) << 4) + ((this.u(byArray[13]) & 0xF0) >>> 4) + 1;
        int n = this.readSampleNumber(byArray[13], byArray[14], byArray[15], byArray[16], byArray[17]);
        this.length = (float)((double)n / (double)this.samplingRate);
    }

    public int getLength() {
        return (int)this.length;
    }

    public float getPreciseLength() {
        return this.length;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public String getEncodingType() {
        return "FLAC " + this.bitsPerSample + " bits";
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int readSamplingRate(byte by, byte by2, byte by3) {
        int n = (this.u(by3) & 0xF0) >>> 3;
        n += this.u(by2) << 5;
        return n += this.u(by) << 13;
    }

    private int readSampleNumber(byte by, byte by2, byte by3, byte by4, byte by5) {
        int n = this.u(by5);
        n += this.u(by4) << 8;
        n += this.u(by3) << 16;
        n += this.u(by2) << 24;
        return n += (this.u(by) & 0xF) << 32;
    }

    private int u(int n) {
        return n & 0xFF;
    }
}

