/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.generic;

import entagged.audioformats.AudioFile;
import entagged.audioformats.exceptions.ModifyVetoException;
import entagged.audioformats.generic.AudioFileModificationListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class ModificationHandler
implements AudioFileModificationListener {
    private Vector listeners = new Vector();

    public void addAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        if (!this.listeners.contains(audioFileModificationListener)) {
            this.listeners.add(audioFileModificationListener);
        }
    }

    public void fileModified(AudioFile audioFile, File file) throws ModifyVetoException {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            AudioFileModificationListener audioFileModificationListener = (AudioFileModificationListener)enumeration.nextElement();
            try {
                audioFileModificationListener.fileModified(audioFile, file);
            }
            catch (ModifyVetoException modifyVetoException) {
                this.vetoThrown(audioFileModificationListener, audioFile, modifyVetoException);
                throw modifyVetoException;
            }
        }
    }

    public void fileOperationFinished(File file) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            AudioFileModificationListener audioFileModificationListener = (AudioFileModificationListener)enumeration.nextElement();
            audioFileModificationListener.fileOperationFinished(file);
        }
    }

    public void fileWillBeModified(AudioFile audioFile, boolean bl) throws ModifyVetoException {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            AudioFileModificationListener audioFileModificationListener = (AudioFileModificationListener)enumeration.nextElement();
            try {
                audioFileModificationListener.fileWillBeModified(audioFile, bl);
            }
            catch (ModifyVetoException modifyVetoException) {
                this.vetoThrown(audioFileModificationListener, audioFile, modifyVetoException);
                throw modifyVetoException;
            }
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener audioFileModificationListener) {
        if (this.listeners.contains(audioFileModificationListener)) {
            this.listeners.remove(audioFileModificationListener);
        }
    }

    public void vetoThrown(AudioFileModificationListener audioFileModificationListener, AudioFile audioFile, ModifyVetoException modifyVetoException) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            AudioFileModificationListener audioFileModificationListener2 = (AudioFileModificationListener)enumeration.nextElement();
            audioFileModificationListener2.vetoThrown(audioFileModificationListener, audioFile, modifyVetoException);
        }
    }
}

