/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.Tag;
import entagged.audioformats.mp3.util.Id3v1TagCreator;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class Id3v1TagWriter {
    private Id3v1TagCreator tc = new Id3v1TagCreator();

    public void delete(RandomAccessFile randomAccessFile) throws IOException {
        if (!this.tagExists(randomAccessFile)) {
            return;
        }
        randomAccessFile.setLength(randomAccessFile.length() - 128L);
    }

    private boolean tagExists(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() <= 128L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        byte[] byArray = new byte[3];
        randomAccessFile.read(byArray);
        return new String(byArray).equals("TAG");
    }

    public void write(Tag tag, RandomAccessFile randomAccessFile) throws IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        ByteBuffer byteBuffer = this.tc.convert(tag);
        if (!this.tagExists(randomAccessFile)) {
            fileChannel.position(fileChannel.size());
            fileChannel.write(byteBuffer);
        } else {
            fileChannel.position(fileChannel.size() - 128L);
            fileChannel.write(byteBuffer);
        }
    }
}

