/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.mp3.Id3v2Tag;
import entagged.audioformats.mp3.util.Id3v24TagReader;
import entagged.audioformats.mp3.util.Id3v2TagSynchronizer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Id3v2TagReader {
    private boolean[] ID3Flags;
    private final Id3v2TagSynchronizer synchronizer = new Id3v2TagSynchronizer();
    private final Id3v24TagReader tagReader = new Id3v24TagReader();

    private boolean[] processID3Flags(byte by) {
        boolean[] blArray;
        if (by != 0) {
            blArray = new boolean[4];
            int n = by & 0x80;
            blArray[0] = n == 128;
            n = by & 0x40;
            blArray[1] = n == 64;
            n = by & 0x20;
            blArray[2] = n == 32;
            n = by & 0x10;
            blArray[3] = n == 16;
        } else {
            blArray = new boolean[]{false, false, false, false};
        }
        return blArray;
    }

    public synchronized Id3v2Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        Id3v2Tag id3v2Tag = null;
        byte[] byArray = new byte[3];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("ID3")) {
            throw new CannotReadException("Not an ID3 tag");
        }
        String string2 = String.valueOf(randomAccessFile.read());
        String string3 = string2 + "." + randomAccessFile.read();
        this.ID3Flags = this.processID3Flags(randomAccessFile.readByte());
        int n = this.readSyncsafeInteger(randomAccessFile);
        byArray = new byte[n + 2];
        randomAccessFile.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (this.ID3Flags[0]) {
            byteBuffer = this.synchronizer.synchronize(byteBuffer);
        }
        if (string2.equals("2")) {
            id3v2Tag = this.tagReader.read(byteBuffer, this.ID3Flags, Id3v2Tag.ID3V22);
        } else if (string2.equals("3")) {
            id3v2Tag = this.tagReader.read(byteBuffer, this.ID3Flags, Id3v2Tag.ID3V23);
        } else if (string2.equals("4")) {
            id3v2Tag = this.tagReader.read(byteBuffer, this.ID3Flags, Id3v2Tag.ID3V24);
        } else {
            throw new CannotReadException("ID3v2 tag version " + string3 + " not supported !");
        }
        return id3v2Tag;
    }

    private int readSyncsafeInteger(RandomAccessFile randomAccessFile) throws IOException {
        int n = 0;
        n += (randomAccessFile.read() & 0xFF) << 21;
        n += (randomAccessFile.read() & 0xFF) << 14;
        n += (randomAccessFile.read() & 0xFF) << 7;
        return n += randomAccessFile.read() & 0xFF;
    }
}

