/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.mp3.util;

import entagged.audioformats.mp3.util.VbrInfoFrame;

public class XingMPEGFrame
implements VbrInfoFrame {
    private int fileSize = 0;
    private int frameCount = 0;
    private boolean isValidXingMPEGFrame = true;
    private int quality;
    private boolean[] vbrFlags = new boolean[4];
    private boolean vbr = false;

    public XingMPEGFrame(byte[] byArray, byte[] byArray2) {
        String string = new String(byArray, 0, 4);
        if (string.equals("Xing") || string.equals("Info")) {
            this.vbr = string.equals("Xing");
            int[] nArray = this.u(byArray);
            int[] nArray2 = this.u(byArray2);
            this.updateVBRFlags(nArray[7]);
            if (this.vbrFlags[0]) {
                this.frameCount = nArray[8] * 0xFFFFFF + nArray[9] * 65535 + nArray[10] * 255 + nArray[11];
            }
            if (this.vbrFlags[1]) {
                this.fileSize = nArray[12] * 0xFFFFFF + nArray[13] * 65535 + nArray[14] * 255 + nArray[15];
            }
            if (this.vbrFlags[3]) {
                this.quality = nArray2[0] * 0xFFFFFF + nArray2[1] * 65535 + nArray2[2] * 255 + nArray2[3];
            }
        } else {
            this.isValidXingMPEGFrame = false;
        }
    }

    private int[] u(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public int getFrameCount() {
        if (this.vbrFlags[0]) {
            return this.frameCount;
        }
        return -1;
    }

    public boolean isValid() {
        return this.isValidXingMPEGFrame;
    }

    public boolean isVbr() {
        return this.vbr;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String toString() {
        String string;
        if (this.isValidXingMPEGFrame) {
            string = "\n----XingMPEGFrame--------------------\n";
            string = string + "Frame count:" + this.vbrFlags[0] + "\tFile Size:" + this.vbrFlags[1] + "\tQuality:" + this.vbrFlags[3] + "\n";
            string = string + "Frame count:" + this.frameCount + "\tFile Size:" + this.fileSize + "\tQuality:" + this.quality + "\n";
            string = string + "--------------------------------\n";
        } else {
            string = "\n!!!No Valid Xing MPEG Frame!!!\n";
        }
        return string;
    }

    private void updateVBRFlags(int n) {
        this.vbrFlags[0] = (n & 1) == 1;
        this.vbrFlags[1] = (n & 2) == 2;
        this.vbrFlags[2] = (n & 4) == 4;
        this.vbrFlags[3] = (n & 8) == 8;
    }
}

