/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

import entagged.audioformats.generic.TagField;
import entagged.audioformats.generic.TagTextField;
import java.io.UnsupportedEncodingException;

public class OggTagField
implements TagTextField {
    private boolean common;
    private String content;
    private String id;

    public OggTagField(byte[] byArray) throws UnsupportedEncodingException {
        String string = new String(byArray, "UTF-8");
        String[] stringArray = string.split("=");
        if (stringArray.length > 1) {
            this.id = stringArray[0].toUpperCase();
            this.content = stringArray[1];
        } else {
            int n = string.indexOf("=");
            if (n != -1) {
                this.id = string.substring(0, n + 1);
                this.content = "";
            } else {
                this.id = "ERRONEOUS";
                this.content = string;
            }
        }
        this.checkCommon();
    }

    public OggTagField(String string, String string2) {
        this.id = string.toUpperCase();
        this.content = string2;
        this.checkCommon();
    }

    private void checkCommon() {
        this.common = this.id.equals("TITLE") || this.id.equals("ALBUM") || this.id.equals("ARTIST") || this.id.equals("GENRE") || this.id.equals("TRACKNUMBER") || this.id.equals("DATE") || this.id.equals("DESCRIPTION") || this.id.equals("COMMENT") || this.id.equals("TRACK");
    }

    protected void copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    public void copyContent(TagField tagField) {
        if (tagField instanceof TagTextField) {
            this.content = ((TagTextField)tagField).getContent();
        }
    }

    protected byte[] getBytes(String string, String string2) throws UnsupportedEncodingException {
        return string.getBytes(string2);
    }

    public String getContent() {
        return this.content;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public String getId() {
        return this.id;
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = this.id.getBytes();
        byte[] byArray3 = this.getBytes(this.content, "UTF-8");
        byte[] byArray4 = new byte[4 + byArray2.length + 1 + byArray3.length];
        int n = byArray2.length + 1 + byArray3.length;
        byArray[3] = (byte)((n & 0xFF000000) >> 24);
        byArray[2] = (byte)((n & 0xFF0000) >> 16);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[0] = (byte)(n & 0xFF);
        int n2 = 0;
        this.copy(byArray, byArray4, n2);
        this.copy(byArray2, byArray4, n2 += 4);
        byArray4[n2 += byArray2.length] = 61;
        this.copy(byArray3, byArray4, ++n2);
        return byArray4;
    }

    public boolean isBinary() {
        return false;
    }

    public void isBinary(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("OggTagFields cannot be changed to binary.\nbinary data should be stored elsewhere according to Vorbis_I_spec.");
        }
    }

    public boolean isCommon() {
        return this.common;
    }

    public boolean isEmpty() {
        return this.content.equals("");
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setEncoding(String string) {
        if (string == null || !string.equalsIgnoreCase("UTF-8")) {
            throw new UnsupportedOperationException("The encoding of OggTagFields cannot be changed.(specified to be UTF-8)");
        }
    }

    public String toString() {
        return this.getContent();
    }
}

