/*
 * Decompiled with CFR 0.152.
 */
package entagged.audioformats.ogg.util;

import entagged.audioformats.Tag;
import entagged.audioformats.exceptions.CannotReadException;
import entagged.audioformats.ogg.OggTag;
import entagged.audioformats.ogg.util.OggPageHeader;
import entagged.audioformats.ogg.util.OggTagReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class VorbisTagReader {
    private OggTagReader oggTagReader = new OggTagReader();

    public Tag read(RandomAccessFile randomAccessFile) throws CannotReadException, IOException {
        long l = 0L;
        randomAccessFile.seek(0L);
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        if (!string.equals("OggS")) {
            throw new CannotReadException("OggS Header could not be found, not an ogg stream");
        }
        randomAccessFile.seek(0L);
        byArray = new byte[4];
        l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(26L);
        int n = randomAccessFile.readByte() & 0xFF;
        randomAccessFile.seek(l);
        byArray = new byte[27 + n];
        randomAccessFile.read(byArray);
        OggPageHeader oggPageHeader = new OggPageHeader(byArray);
        randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)oggPageHeader.getPageLength());
        l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(randomAccessFile.getFilePointer() + 26L);
        n = randomAccessFile.readByte() & 0xFF;
        randomAccessFile.seek(l);
        byArray = new byte[27 + n];
        randomAccessFile.read(byArray);
        oggPageHeader = new OggPageHeader(byArray);
        byArray = new byte[7];
        randomAccessFile.read(byArray);
        String string2 = new String(byArray, 1, 6);
        if (byArray[0] != 3 || !string2.equals("vorbis")) {
            throw new CannotReadException("Cannot find comment block (no vorbis header)");
        }
        OggTag oggTag = this.oggTagReader.read(randomAccessFile);
        byte by = randomAccessFile.readByte();
        if (by == 0) {
            throw new CannotReadException("Error: The OGG Stream isn't valid, could not extract the tag");
        }
        return oggTag;
    }
}

