/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jmp3renamer.DataPlugin;
import net.sf.jmp3renamer.FileManager;
import net.sf.jmp3renamer.FilePlugin;
import net.sf.jmp3renamer.GeneralPlugin;
import net.sf.jmp3renamer.I18N;
import net.sf.jmp3renamer.JarClassLoader;
import net.sf.jmp3renamer.Main;
import net.sf.jmp3renamer.Plugin;
import net.sf.jmp3renamer.util.PluginComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static transient Logger logger = LoggerFactory.getLogger(class$net$sf$jmp3renamer$PluginLoader == null ? (class$net$sf$jmp3renamer$PluginLoader = PluginLoader.class$("net.sf.jmp3renamer.PluginLoader")) : class$net$sf$jmp3renamer$PluginLoader);
    Hashtable loader_hashtable = new Hashtable();
    Vector plugins = new Vector();
    private static PluginLoader instance;
    static /* synthetic */ Class class$net$sf$jmp3renamer$PluginLoader;

    private PluginLoader() {
    }

    public static synchronized PluginLoader getInstance() {
        if (instance == null) {
            instance = new PluginLoader();
        }
        return instance;
    }

    public Plugin loadPlugin(File jarfile) {
        Plugin plugin = null;
        String name = jarfile.getName().substring(0, jarfile.getName().lastIndexOf("."));
        JarClassLoader jcl = null;
        try {
            jcl = new JarClassLoader(jarfile);
            Class<?> c = jcl.loadClass("net.sf.jmp3renamer.plugins." + name + "." + name);
            logger.info("Trying to load PlugIn \"{}\"", (Object)name);
            plugin = (Plugin)c.newInstance();
            plugin.init();
            logger.debug("PlugIn \"{}\" initialized", (Object)name);
            if (plugin != null) {
                this.plugins.addElement(plugin);
                this.loader_hashtable.put(name, jcl);
                logger.info("PlugIn \"{}\" loaded", (Object)name);
                if (plugin.getType() == 0) {
                    Main.getGUI().addPlugin((DataPlugin)plugin);
                } else if (plugin.getType() == 1) {
                    logger.debug("Adding FileFilter");
                    FilePlugin plugIn = (FilePlugin)plugin;
                    FileManager.getInstance().addFilePlugin(plugIn);
                } else if (plugin.getType() == 2) {
                    Main.getGUI().addPlugin((GeneralPlugin)plugin);
                }
                plugin.setFile(jarfile);
            }
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.load_plugin", new Object[]{jarfile}), e);
            try {
                jcl.closeJarFile();
                jarfile.delete();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return plugin;
    }

    public boolean unloadPlugin(String pluginName) {
        logger.debug("Trying to unload plugin: " + pluginName);
        try {
            JarClassLoader jcl = (JarClassLoader)this.loader_hashtable.get(pluginName);
            jcl.closeJarFile();
            Plugin plugin = null;
            Enumeration en = this.plugins.elements();
            while (en.hasMoreElements()) {
                Plugin current = (Plugin)en.nextElement();
                String uniqueName = current.getClass().getName();
                if (!(uniqueName = uniqueName.substring(uniqueName.lastIndexOf(".") + 1, uniqueName.length())).equals(pluginName)) continue;
                plugin = current;
                this.plugins.remove(plugin);
                this.loader_hashtable.remove(pluginName);
            }
            if (plugin != null) {
                if (plugin.getType() == 0) {
                    Main.getGUI().removePlugin((DataPlugin)plugin);
                } else if (plugin.getType() == 1) {
                    FileManager.getInstance().removeFilePlugin((FilePlugin)plugin);
                } else if (plugin.getType() == 2) {
                    Main.getGUI().removePlugin((GeneralPlugin)plugin);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error(I18N.translate("error.unload_plugin", new String[]{pluginName}), e);
            return false;
        }
    }

    public Vector getPlugins() {
        Collections.sort(this.plugins, new PluginComparator());
        return this.plugins;
    }

    public File[] getPluginDirs() {
        File[] pluginDirs;
        Class<?> main = this.getClass();
        URL url = main.getResource("PluginLoader.class");
        String temp = "";
        try {
            temp = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UTF-8 not supported", e);
        }
        if (temp.indexOf("!") > 0) {
            File jarfile = new File(temp.substring(temp.indexOf("/"), temp.indexOf("!")));
            pluginDirs = new File[]{new File(jarfile.getParent() + File.separator + "plugins"), new File(Main.CONFIG_DIR, "plugins")};
        } else {
            pluginDirs = new File[]{new File(new File(System.getProperty("user.dir"), "build"), "plugins"), new File(Main.CONFIG_DIR, "plugins")};
        }
        return pluginDirs;
    }

    public ClassLoader getClassLoader(String pluginName) {
        return (ClassLoader)this.loader_hashtable.get(pluginName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

