/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmp3renamer.gui.components.historycombobox;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import javax.swing.JTextField;
import net.sf.jmp3renamer.gui.components.historycombobox.JHistoryComboBox;

public class SuggestingJHistoryComboBox
extends JHistoryComboBox
implements KeyListener {
    private String[] suggestions;

    public SuggestingJHistoryComboBox(String[] suggestions, Properties properties, String propertyName) {
        super(properties, propertyName);
        this.suggestions = suggestions;
        this.getEditor().getEditorComponent().addKeyListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            JTextField textField = (JTextField)e.getSource();
            if ("SUGGEST".equals(e.getActionCommand())) {
                textField.setSelectionStart(textField.getSelectionEnd());
                textField.setActionCommand("");
            } else {
                super.actionPerformed(e);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.suggest();
        }
    }

    private void suggest() {
        JTextField textField = (JTextField)this.getEditor().getEditorComponent();
        String text = textField.getText();
        int pos = textField.getCaretPosition();
        for (int i = pos - 1; i >= 0; --i) {
            if (text.charAt(i) != '%') continue;
            String possibleCookiePart = text.substring(i, pos);
            for (int j = 0; j < this.suggestions.length; ++j) {
                String suggestion = this.suggestions[j];
                if (!suggestion.startsWith(possibleCookiePart)) continue;
                textField.setActionCommand("SUGGEST");
                String newText = text.substring(0, i) + suggestion + text.substring(pos);
                textField.setText(newText);
                textField.setSelectionStart(pos);
                textField.setSelectionEnd(i + suggestion.length());
                return;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }
}

