/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.recorder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class FrameCompressor {
    private FramePacket frame;

    public FrameCompressor(OutputStream oStream, int frameSize) {
        this.frame = new FramePacket(oStream, frameSize);
    }

    public void pack(int[] newData, long frameTimeStamp, boolean reset) throws IOException {
        this.frame.nextFrame(newData, frameTimeStamp, reset);
        byte[] packed = new byte[newData.length * 4];
        int inCursor = 0;
        int outCursor = 0;
        int blocks = 0;
        boolean inBlock = true;
        int blockSize = 0;
        byte blockRed = 0;
        byte blockGreen = 0;
        byte blockBlue = 0;
        int blankBlocks = 0;
        int uncompressedCursor = -1;
        boolean hasChanges = false;
        boolean lastEntry = false;
        while (inCursor < newData.length) {
            byte blue;
            byte green;
            byte red;
            if (inCursor == newData.length - 1) {
                lastEntry = true;
            }
            if (newData[inCursor] == this.frame.previousData[inCursor]) {
                red = 0;
                green = 0;
                blue = 0;
            } else {
                red = (byte)((newData[inCursor] & 0xFF0000) >>> 16);
                green = (byte)((newData[inCursor] & 0xFF00) >>> 8);
                blue = (byte)(newData[inCursor] & 0xFF);
                if (red == 0 && green == 0 && blue == 0) {
                    blue = 1;
                }
            }
            if (blockRed == red && blockGreen == green && blockBlue == blue) {
                if (!inBlock) {
                    if (uncompressedCursor > -1) {
                        ++blocks;
                        hasChanges = true;
                        packed[uncompressedCursor] = (byte)(blockSize + 128);
                    }
                    inBlock = true;
                    blockSize = 0;
                    blankBlocks = 0;
                } else if (blockSize == 126 || lastEntry) {
                    if (blockRed == 0 && blockGreen == 0 && blockBlue == 0) {
                        if (blankBlocks > 0) {
                            packed[outCursor - 1] = (byte)(++blankBlocks);
                        } else {
                            ++blocks;
                            packed[outCursor] = -1;
                            packed[++outCursor] = (byte)(++blankBlocks);
                            ++outCursor;
                        }
                        if (blankBlocks == 255) {
                            blankBlocks = 0;
                        }
                    } else {
                        ++blocks;
                        hasChanges = true;
                        packed[outCursor] = (byte)blockSize;
                        packed[++outCursor] = blockRed;
                        packed[++outCursor] = blockGreen;
                        packed[++outCursor] = blockBlue;
                        ++outCursor;
                        blankBlocks = 0;
                    }
                    inBlock = true;
                    blockSize = 0;
                }
            } else {
                if (inBlock) {
                    if (blockSize > 0) {
                        ++blocks;
                        hasChanges = true;
                        packed[outCursor] = (byte)blockSize;
                        packed[++outCursor] = blockRed;
                        packed[++outCursor] = blockGreen;
                        packed[++outCursor] = blockBlue;
                        ++outCursor;
                    }
                    uncompressedCursor = -1;
                    inBlock = false;
                    blockSize = 0;
                    blankBlocks = 0;
                } else if (blockSize == 126 || lastEntry) {
                    if (uncompressedCursor > -1) {
                        ++blocks;
                        hasChanges = true;
                        packed[uncompressedCursor] = (byte)(blockSize + 128);
                    }
                    uncompressedCursor = -1;
                    inBlock = false;
                    blockSize = 0;
                    blankBlocks = 0;
                }
                if (uncompressedCursor == -1) {
                    uncompressedCursor = outCursor++;
                }
                packed[outCursor] = red;
                packed[++outCursor] = green;
                packed[++outCursor] = blue;
                ++outCursor;
                blockRed = red;
                blockGreen = green;
                blockBlue = blue;
            }
            ++inCursor;
            ++blockSize;
        }
        this.frame.oStream.write(((int)this.frame.frameTime & 0xFF000000) >>> 24);
        this.frame.oStream.write(((int)this.frame.frameTime & 0xFF0000) >>> 16);
        this.frame.oStream.write(((int)this.frame.frameTime & 0xFF00) >>> 8);
        this.frame.oStream.write((int)this.frame.frameTime & 0xFF);
        if (!hasChanges) {
            this.frame.oStream.write(0);
            this.frame.oStream.flush();
            FramePacket.access$502(this.frame, this.frame.previousData);
            return;
        }
        this.frame.oStream.write(1);
        this.frame.oStream.flush();
        ByteArrayOutputStream bO = new ByteArrayOutputStream();
        byte[] bA = new byte[]{};
        GZIPOutputStream zO = new GZIPOutputStream(bO);
        zO.write(packed, 0, outCursor);
        zO.close();
        bO.close();
        bA = bO.toByteArray();
        this.frame.oStream.write((bA.length & 0xFF000000) >>> 24);
        this.frame.oStream.write((bA.length & 0xFF0000) >>> 16);
        this.frame.oStream.write((bA.length & 0xFF00) >>> 8);
        this.frame.oStream.write(bA.length & 0xFF);
        this.frame.oStream.write(bA);
        this.frame.oStream.flush();
    }

    public class FramePacket {
        private OutputStream oStream;
        private long frameTime;
        private int[] previousData;
        private int[] newData;

        private FramePacket(OutputStream oStream, int frameSize) {
            this.oStream = oStream;
            this.previousData = new int[frameSize];
        }

        private void nextFrame(int[] frameData, long frameTime, boolean reset) {
            this.frameTime = frameTime;
            this.previousData = this.newData;
            this.newData = null;
            if (this.previousData == null) {
                this.previousData = new int[frameData.length];
            }
            this.newData = reset ? new int[frameData.length] : frameData;
        }

        static /* synthetic */ int[] access$502(FramePacket x0, int[] x1) {
            x0.newData = x1;
            return x1;
        }
    }
}

