/*
 * Decompiled with CFR 0.152.
 */
package com.wet.wired.jsr.recorder;

import com.wet.wired.jsr.recorder.DesktopScreenRecorder;
import com.wet.wired.jsr.recorder.FileExtensionFilter;
import com.wet.wired.jsr.recorder.FileHelper;
import com.wet.wired.jsr.recorder.ScreenRecorder;
import com.wet.wired.jsr.recorder.ScreenRecorderListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class JRecorder
extends JFrame
implements ScreenRecorderListener,
ActionListener {
    private ScreenRecorder recorder;
    private File temp;
    private JButton control;
    private JLabel text;
    private boolean shuttingDown = false;
    private int frameCount = 0;

    public JRecorder() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JRecorder.this.shutdown();
            }
        });
        this.control = new JButton("Start Recording");
        this.control.setActionCommand("start");
        this.control.addActionListener(this);
        this.getContentPane().add((Component)this.control, "West");
        this.text = new JLabel("Ready to record");
        this.getContentPane().add((Component)this.text, "South");
        this.pack();
        this.setVisible(true);
    }

    public void startRecording(String fileName) {
        this.setState(1);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (this.recorder != null) {
            return;
        }
        try {
            FileOutputStream oStream = new FileOutputStream(fileName);
            this.temp = new File(fileName);
            this.recorder = new DesktopScreenRecorder(oStream, this);
            this.recorder.startRecording();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("start") && this.recorder == null) {
            try {
                this.temp = File.createTempFile("temp", "rec");
                this.startRecording(this.temp.getAbsolutePath());
                this.control.setActionCommand("stop");
                this.control.setText("Stop Recording");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (ev.getActionCommand().equals("stop") && this.recorder != null) {
            this.text.setText("Stopping");
            this.recorder.stopRecording();
        }
    }

    @Override
    public void frameRecorded(boolean fullFrame) {
        ++this.frameCount;
        if (this.text != null) {
            this.text.setText("Frame: " + this.frameCount);
        }
    }

    @Override
    public void recordingStopped() {
        if (!this.shuttingDown) {
            UIManager.put("FileChooser.readOnly", true);
            JFileChooser fileChooser = new JFileChooser();
            FileExtensionFilter filter = new FileExtensionFilter();
            filter = new FileExtensionFilter();
            filter.addExtension("cap");
            filter.setDescription("Screen Capture File");
            fileChooser.setFileFilter(filter);
            fileChooser.showSaveDialog(this);
            File target = fileChooser.getSelectedFile();
            if (target != null) {
                if (!target.getName().endsWith(".cap")) {
                    target = new File(target + ".cap");
                }
                FileHelper.copy(this.temp, target);
            }
            FileHelper.delete(this.temp);
            this.recorder = null;
            this.frameCount = 0;
            this.control.setActionCommand("start");
            this.control.setText("Start Recording");
            this.text.setText("Ready to record");
        } else {
            FileHelper.delete(this.temp);
        }
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            if (args[0].equals("-white_cursor")) {
                DesktopScreenRecorder.useWhiteCursor = true;
            } else {
                System.out.println("Usage: java -jar screen_recorder.jar [OPTION]...");
                System.out.println("Start the screen recorder.");
                System.out.println("Options:   ");
                System.out.println("   -white_cursor   record with white cursor");
                System.exit(0);
            }
        }
        JRecorder jRecorder = new JRecorder();
    }

    public void shutdown() {
        this.shuttingDown = true;
        if (this.recorder != null) {
            this.recorder.stopRecording();
        }
        this.dispose();
    }
}

