/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DirDisplayPanel
extends JPanel
implements ActionListener {
    Component mParent;
    JPanel leftpanel;
    JPanel rightpanel;
    JCheckBox capitalize;
    JCheckBox convertunderscores;
    JCheckBox addTime;
    JCheckBox addNum;
    JCheckBox addprefix;
    JCheckBox addfoldernum;
    JTextField prefix;
    JComboBox folderstartingnum;
    JRadioButton trackname;
    JRadioButton trackartist;
    JRadioButton artisttrack;
    JRadioButton files;
    JRadioButton id3tag;
    Color enabledBackground;
    Color disabledBackground;

    public DirDisplayPanel(Component component) {
        this(component, null);
    }

    public DirDisplayPanel(Component component, ResourceBundle resourceBundle) {
        this.mParent = component;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(null, "Global Directory Options", 1, 2));
        this.capitalize = new JCheckBox("Capitalize directory names");
        this.add(this.capitalize);
        this.convertunderscores = new JCheckBox("Convert _'s to spaces");
        this.add(this.convertunderscores);
        this.addTime = new JCheckBox(ResourceStrings.get("ADD_TIME_TO_DIRS"));
        this.add(this.addTime);
        this.addNum = new JCheckBox(ResourceStrings.get("ADD_MP3_COUNT_TO_DIRS"));
        this.add(this.addNum);
        this.addprefix = new JCheckBox("Add prefix to every directory:");
        this.addprefix.addActionListener(this);
        this.add(this.addprefix);
        this.prefix = new JTextField(3);
        this.add(this.prefix);
        this.addfoldernum = new JCheckBox("Add CD folder numbers starting with:");
        this.addfoldernum.addActionListener(this);
        this.add(this.addfoldernum);
        Vector<String> vector = new Vector<String>();
        vector.addElement("1");
        vector.addElement("2");
        this.folderstartingnum = new JComboBox(vector);
        this.add(this.folderstartingnum);
        this.capitalize.setSelected(ConfigProperties.getBoolean("CAP_DIR_NAMES"));
        this.convertunderscores.setSelected(ConfigProperties.getBoolean("CONVERT_UNDERSCORE_TO_SPACE"));
        this.addTime.setSelected(ConfigProperties.getBoolean("ADD_TIME_TO_DIRS"));
        this.addNum.setSelected(ConfigProperties.getBoolean("ADD_COUNT_TO_DIRS"));
        this.addprefix.setSelected(ConfigProperties.getBoolean("ADD_PREFIX_TO_DIRS"));
        String string = ConfigProperties.get("DIR_PREFIX");
        if (string == null) {
            string = "";
        }
        this.prefix.setText(string);
        this.addfoldernum.setSelected(ConfigProperties.getBoolean("ADD_FOLDER_NUMBERS"));
        string = ConfigProperties.get("FOLDER_NUMBER_START");
        this.folderstartingnum.setSelectedItem(string);
        this.enabledBackground = this.prefix.getBackground();
        this.disabledBackground = this.getBackground();
        this.enableField(this.addprefix, this.prefix);
        this.enableField(this.addfoldernum, this.folderstartingnum);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addprefix) {
            this.enableField(this.addprefix, this.prefix);
        } else if (actionEvent.getSource() == this.addfoldernum) {
            this.enableField(this.addfoldernum, this.folderstartingnum);
        }
    }

    private void enableField(AbstractButton abstractButton, JComponent jComponent) {
        boolean bl = abstractButton.isSelected();
        jComponent.setEnabled(bl);
        if (bl) {
            jComponent.setBackground(this.enabledBackground);
        } else {
            jComponent.setBackground(this.disabledBackground);
        }
    }

    public void saveValues() {
        ConfigProperties.setBoolean("CAP_DIR_NAMES", this.capitalize.isSelected());
        ConfigProperties.setBoolean("CONVERT_UNDERSCORE_TO_SPACE", this.convertunderscores.isSelected());
        ConfigProperties.setBoolean("ADD_TIME_TO_DIRS", this.addTime.isSelected());
        ConfigProperties.setBoolean("ADD_COUNT_TO_DIRS", this.addNum.isSelected());
        ConfigProperties.setBoolean("ADD_PREFIX_TO_DIRS", this.addprefix.isSelected());
        ConfigProperties.set("DIR_PREFIX", this.prefix.getText());
        ConfigProperties.setBoolean("ADD_FOLDER_NUMBERS", this.addfoldernum.isSelected());
        ConfigProperties.set("FOLDER_NUMBER_START", (String)this.folderstartingnum.getSelectedItem());
    }

    public static void main(String[] stringArray) {
        DirDisplayPanel dirDisplayPanel = new DirDisplayPanel(null);
        JFrame jFrame = new JFrame(dirDisplayPanel.getClass().getName());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)dirDisplayPanel, "Center");
        jFrame.pack();
        jFrame.show();
    }
}

