/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.submin;

import com.alee.extended.label.IStyledLabelPainter;
import com.alee.extended.label.StyleRange;
import com.alee.extended.label.StyledLabelUtils;
import com.alee.extended.label.TextRange;
import com.alee.extended.label.WebStyledLabel;
import com.alee.extended.label.WebStyledLabelUI;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.log.Log;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.FontUtils;
import com.alee.utils.SwingUtils;
import de.sciss.submin.AbstractLabelPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SubminStyledLabelPainter<E extends WebStyledLabel, U extends WebStyledLabelUI, D extends IDecoration<E, D>>
extends AbstractLabelPainter<E, U, D>
implements IStyledLabelPainter<E, U>,
SwingConstants {
    protected int preferredRowCount;
    protected boolean ignoreColorSettings;
    protected float scriptFontRatio;
    protected String truncatedTextSuffix;
    protected final List<TextRange> textRanges = new ArrayList<TextRange>();
    protected boolean retrievingPreferredSize = false;
    protected boolean truncated = false;

    public void updateTextRanges() {
        this.textRanges.clear();
    }

    protected void paintEnabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        this.paintStyledText(label, g2d, textX, textY);
    }

    @Override
    protected void paintDisabledText(E label, Graphics2D g2d, String text, int textX, int textY) {
        this.paintStyledText(label, g2d, textX, textY);
    }

    protected void paintStyledText(E label, Graphics2D g, int textX, int textY) {
        this.truncated = false;
        int labelWidth = this.getLabelWidth(label, label.getInsets());
        int textWidth = this.paintTextR.width;
        int w = Math.min(labelWidth, textWidth);
        this.paintStyledTextImpl(label, g, textX, textY, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLabelWidth(E label, Insets insets) {
        int lw;
        if (this.getActualRotation().isVertical()) {
            lw = label.getHeight();
            if (lw <= 0) {
                lw = Integer.MAX_VALUE;
            }
        } else {
            lw = label.getWidth();
            if (label.isLineWrap()) {
                int oldPreferredWidth = label.getPreferredWidth();
                int oldRows = label.getRows();
                try {
                    label.setRows(0);
                    lw = this.getPreferredSize().width;
                    label.setPreferredWidth(oldPreferredWidth > 0 ? Math.min(label.getWidth(), oldPreferredWidth) : label.getWidth());
                    Dimension sizeOnWidth = this.getPreferredSize();
                    if (sizeOnWidth.width < lw) {
                        lw = sizeOnWidth.width;
                    }
                }
                finally {
                    label.setPreferredWidth(oldPreferredWidth);
                    label.setRows(oldRows);
                }
            }
        }
        if (insets != null) {
            lw -= insets.left + insets.right;
        }
        return lw;
    }

    protected int paintStyledTextImpl(E label, Graphics2D g, int textX, int textY, int w) {
        FontMetrics fm2;
        int horizontalAlignment;
        Insets insets = label.getInsets();
        int labelHeight = this.paintTextR.height;
        int endY = this.paintTextR.y + labelHeight;
        int startX = this.getStartX(label, textX, insets);
        int endX = w + startX;
        int mnemonicIndex = label.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WebLookAndFeel && WebLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        int x = startX;
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        int maxRowHeight = fm.getHeight();
        int minStartY = fm.getAscent();
        switch (label.getHorizontalAlignment()) {
            case 10: {
                horizontalAlignment = this.ltr ? 2 : 4;
                break;
            }
            case 11: {
                horizontalAlignment = this.ltr ? 4 : 2;
                break;
            }
            default: {
                horizontalAlignment = label.getHorizontalAlignment();
            }
        }
        for (TextRange textRange : this.textRanges) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style == null || (style.getStyle() == -1 || font.getStyle() == style.getStyle()) && font.getSize() == size) continue;
            font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
            fm2 = label.getFontMetrics(font);
            maxRowHeight = Math.max(maxRowHeight, fm2.getHeight());
            minStartY = Math.max(minStartY, fm2.getAscent());
        }
        boolean lineWrap = label.isLineWrap();
        if (!lineWrap) {
            for (TextRange textRange : this.textRanges) {
                if (!textRange.text.endsWith("\n")) continue;
                lineWrap = true;
                break;
            }
        }
        if (lineWrap && textY < minStartY) {
            textY = minStartY;
        }
        boolean bl = false;
        int rowCount = 0;
        int rowStartOffset = 0;
        for (int i = 0; i < this.textRanges.size(); ++i) {
            boolean displayMnemonic;
            int n;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            if (mnemonicIndex >= 0 && textRange.text.length() - n > mnemonicIndex - charDisplayed) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            } else {
                displayMnemonic = false;
            }
            charDisplayed += textRange.text.length() - n;
            if (textRange.text.contains("\r") || textRange.text.contains("\n")) {
                boolean lastRow;
                boolean bl2 = lastRow = label.getMaximumRows() > 0 && rowCount >= label.getMaximumRows() - 1 || textY + maxRowHeight + Math.max(0, label.getRowGap()) > endY;
                if (horizontalAlignment != 2 && g != null) {
                    if (lastRow && i != this.textRanges.size() - 1) {
                        x += fm.stringWidth(this.truncatedTextSuffix);
                    }
                    this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStartIndex() + textRange.text.length(), lastRow);
                }
                rowStartOffset = style.getStartIndex();
                n = 0;
                nextFm2 = null;
                if (!lastRow) {
                    rowStartOffset += style.getLength();
                    ++rowCount;
                    x = startX;
                    textY += maxRowHeight + Math.max(0, label.getRowGap());
                    continue;
                }
                if (horizontalAlignment != 2 && g != null) break;
            }
            int y = textY;
            if (nextFm2 == null) {
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                    fm2 = label.getFontMetrics(font);
                } else {
                    fm2 = fm;
                }
            } else {
                fm2 = nextFm2;
            }
            if (g != null) {
                g.setFont(font);
            }
            boolean stop = false;
            String s = textRange.text.substring(Math.min(n, textRange.text.length()));
            if (s.contains("\r") || s.contains("\n")) {
                s = this.truncatedTextSuffix;
                stop = true;
            }
            int strWidth = fm2.stringWidth(s);
            boolean wrapped = false;
            int widthLeft = endX - x;
            if (widthLeft < strWidth && widthLeft >= 0) {
                if (label.isLineWrap() && (label.getMaximumRows() > 0 && rowCount < label.getMaximumRows() - 1 || label.getMaximumRows() <= 0) && y + maxRowHeight + Math.max(0, label.getRowGap()) <= endY) {
                    int nextWordStartIndex;
                    wrapped = true;
                    int availLength = s.length() * widthLeft / strWidth + 1;
                    int nextRowStartIndexInSubString = 0;
                    boolean needBreak = false;
                    boolean needContinue = false;
                    int loopCount = 0;
                    do {
                        String subStringThisRow;
                        String subString;
                        int firstRowWordEndIndex;
                        int n2 = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex((String)(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length())))))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex((String)s, (int)firstRowWordEndIndex);
                        if (firstRowWordEndIndex < 0) {
                            if (x != startX) {
                                boolean lastRow;
                                boolean bl3 = lastRow = label.getMaximumRows() > 0 && rowCount >= label.getMaximumRows() - 1;
                                if (horizontalAlignment != 2 && g != null) {
                                    this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, style.getStartIndex() + Math.min(n, textRange.text.length()), lastRow);
                                }
                                textY += maxRowHeight + Math.max(0, label.getRowGap());
                                x = startX;
                                --i;
                                ++rowCount;
                                rowStartOffset = style.getStartIndex() + Math.min(n, textRange.text.length());
                                if (lastRow) {
                                    needBreak = true;
                                }
                                needContinue = true;
                                break;
                            }
                            firstRowWordEndIndex = 0;
                            nextWordStartIndex = Math.min(s.length(), availLength);
                        }
                        if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                            availLength = subString.length() * widthLeft / strWidth;
                        }
                        if (++loopCount <= 15) continue;
                        Log.error((String)("Styled label paint error: " + textRange));
                        break;
                    } while (strWidth > widthLeft && availLength > 0);
                    if (needBreak) break;
                    if (needContinue) continue;
                    while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                        ++nextRowStartIndexInSubString;
                    }
                    s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                    strWidth = fm2.stringWidth(s);
                    charDisplayed -= textRange.text.length() - n;
                    if (displayMnemonic) {
                        if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                            displayMnemonic = true;
                            mneIndex = mnemonicIndex - charDisplayed;
                        } else {
                            displayMnemonic = false;
                        }
                    }
                    charDisplayed += s.length();
                    n += nextRowStartIndexInSubString;
                } else {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, labelHeight), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
                stop = !lineWrap || y + maxRowHeight + Math.max(0, label.getRowGap()) > endY || label.getMaximumRows() > 0 && rowCount >= label.getMaximumRows() - 1;
            } else if (lineWrap) {
                n = 0;
            } else if (i < this.textRanges.size() - 1) {
                String nextS;
                TextRange nextTextRange = this.textRanges.get(i + 1);
                String nextText = nextTextRange.text;
                StyleRange nextStyle = nextTextRange.styleRange;
                int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (nextStyle != null && (nextStyle.getStyle() != -1 && font.getStyle() != nextStyle.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont((Font)font, (int)(nextStyle.getStyle() == -1 ? font.getStyle() : nextStyle.getStyle()), (int)size);
                    nextFm2 = label.getFontMetrics(font);
                } else {
                    nextFm2 = fm;
                }
                if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, labelHeight), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, labelHeight), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                    stop = true;
                }
            }
            if (rowCount > 0 && x == startX && s.startsWith(" ")) {
                s = s.substring(1);
                strWidth = fm2.stringWidth(s);
            }
            if (horizontalAlignment == 2 && g != null) {
                if (style != null && style.isSuperscript()) {
                    y -= fm.getHeight() - fm2.getHeight();
                }
                if (style != null && style.getBackground() != null) {
                    g.setPaint(style.getBackground());
                    g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
                }
                if (label.isEnabled()) {
                    Color textColor = style != null && !this.ignoreColorSettings && style.getForeground() != null ? style.getForeground() : label.getForeground();
                    g.setPaint(textColor);
                    this.paintStyledTextFragment(g, s, x, y, displayMnemonic, mneIndex, fm2, style, strWidth);
                } else {
                    g.setPaint(this.disabledForeground);
                    this.paintStyledTextFragment(g, s, x, y, displayMnemonic, mneIndex, fm2, style, strWidth);
                }
            }
            if (stop) {
                if (horizontalAlignment != 2 && g != null) {
                    this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, label.getText().length(), true);
                }
                this.truncated = true;
                break;
            }
            if (wrapped) {
                boolean lastRow;
                boolean bl4 = lastRow = label.getMaximumRows() > 0 && rowCount >= label.getMaximumRows() - 1 || textY + maxRowHeight + Math.max(0, label.getRowGap()) > endY;
                if (horizontalAlignment != 2 && g != null) {
                    this.paintRow(label, g, startX, x += strWidth, endX, textY, rowStartOffset, style.getStartIndex() + Math.min(n, textRange.text.length()), lastRow);
                }
                textY += maxRowHeight + Math.max(0, label.getRowGap());
                x = startX;
                --i;
                ++rowCount;
                rowStartOffset = style.getStartIndex() + Math.min(n, textRange.text.length());
                if (lastRow) {
                    break;
                }
            } else {
                x += strWidth;
            }
            if (i != this.textRanges.size() - 1 || horizontalAlignment == 2 || g == null) continue;
            this.paintRow(label, g, startX, x, endX, textY, rowStartOffset, -1, true);
        }
        return (int)Math.ceil((double)textY / (double)maxRowHeight);
    }

    protected void paintStyledTextFragment(Graphics2D g, String s, int x, int y, boolean displayMnemonic, int mneIndex, FontMetrics fm2, StyleRange style, int strWidth) {
        if (((WebStyledLabel)this.component).isEnabled() && this.drawShade) {
            this.paintShadowText(g, s, x, y);
        } else {
            SwingUtils.drawStringUnderlineCharAt((Graphics)g, (String)s, (int)(displayMnemonic ? mneIndex : -1), (int)x, (int)y);
        }
        if (style != null) {
            int lineY;
            if (style.isStrikeThrough()) {
                lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                g.drawLine(x, lineY, x + strWidth - 1, lineY);
            }
            if (style.isDoubleStrikeThrough()) {
                lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
            }
            if (style.isUnderlined()) {
                lineY = y + 1;
                g.drawLine(x, lineY, x + strWidth - 1, lineY);
            }
            if (style.isWaved()) {
                int waveY = y + 1;
                for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                    if (waveX + 2 <= x + strWidth - 1) {
                        g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                    }
                    if (waveX + 4 > x + strWidth - 1) continue;
                    g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                }
            }
        }
    }

    protected int getStartX(E label, int textX, Insets insets) {
        int leftMostX = 0;
        if (insets != null) {
            leftMostX += insets.left;
        }
        if (label.getIcon() != null) {
            int horizontalTextPosition = label.getHorizontalTextPosition();
            if (horizontalTextPosition == 11 && this.ltr || horizontalTextPosition == 10 && !this.ltr) {
                horizontalTextPosition = 4;
            }
            if (horizontalTextPosition == 4) {
                leftMostX += label.getIcon().getIconWidth() + label.getIconTextGap();
            }
        }
        return textX < leftMostX ? leftMostX : textX;
    }

    protected void paintRow(E label, Graphics2D g, int leftAlignmentX, int thisLineEndX, int rightMostX, int textY, int startOffset, int endOffset, boolean lastRow) {
        if (g == null) {
            return;
        }
        int horizontalTextPosition = label.getHorizontalTextPosition();
        int horizontalAlignment = label.getHorizontalAlignment();
        if (horizontalTextPosition == 11 && !this.ltr || horizontalTextPosition == 10 && this.ltr) {
            horizontalTextPosition = 2;
        }
        if (horizontalTextPosition == 10 && !this.ltr || horizontalTextPosition == 11 && this.ltr) {
            horizontalTextPosition = 4;
        }
        if (horizontalAlignment == 11 && !this.ltr || horizontalAlignment == 10 && this.ltr) {
            horizontalAlignment = 2;
        }
        if (horizontalAlignment == 10 && !this.ltr || horizontalAlignment == 11 && this.ltr) {
            horizontalAlignment = 4;
        }
        Insets insets = label.getInsets();
        int textX = leftAlignmentX;
        int paintWidth = thisLineEndX - leftAlignmentX;
        int labelWidth = this.getLabelWidth(label, null);
        if (horizontalAlignment == 4) {
            paintWidth = thisLineEndX - textX;
            textX = labelWidth - paintWidth;
            if (insets != null) {
                textX -= insets.right;
            }
            if (label.getIcon() != null && horizontalTextPosition == 2) {
                textX -= label.getIcon().getIconWidth() + label.getIconTextGap();
            }
        } else if (horizontalAlignment == 0) {
            int leftMostX = 0;
            if (horizontalTextPosition == 4 && label.getIcon() != null) {
                leftMostX += label.getIcon().getIconWidth() + label.getIconTextGap();
            }
            if (insets != null) {
                labelWidth -= insets.right + insets.left;
                leftMostX += insets.left;
            }
            if (label.getIcon() != null && horizontalTextPosition != 0) {
                labelWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
            }
            textX = leftMostX + (labelWidth - paintWidth) / 2;
        }
        paintWidth = Math.min(paintWidth, rightMostX - leftAlignmentX);
        int mnemonicIndex = label.getDisplayedMnemonicIndex();
        int charDisplayed = 0;
        int mneIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        FontMetrics nextFm2 = null;
        int defaultFontSize = font.getSize();
        int x = textX;
        for (int i = 0; i < this.textRanges.size() && (endOffset < 0 || charDisplayed < endOffset); ++i) {
            int strWidth;
            int widthLeft;
            FontMetrics fm2;
            boolean displayMnemonic;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            int length = style.getLength();
            if (length < 0) {
                length = textRange.text.length();
            }
            if (style.getStartIndex() + length <= startOffset) {
                charDisplayed += length;
                continue;
            }
            int nextRowStartIndex = style.getStartIndex() >= startOffset ? 0 : startOffset - style.getStartIndex();
            if (mnemonicIndex >= 0 && textRange.text.length() - nextRowStartIndex > mnemonicIndex - (charDisplayed += nextRowStartIndex)) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            } else {
                displayMnemonic = false;
            }
            int paintLength = textRange.text.length() - nextRowStartIndex;
            if (endOffset >= 0 && charDisplayed + paintLength >= endOffset) {
                paintLength = endOffset - charDisplayed;
            }
            charDisplayed += paintLength;
            int y = textY;
            if (nextFm2 == null) {
                int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                    fm2 = label.getFontMetrics(font);
                } else {
                    fm2 = fm;
                }
            } else {
                fm2 = nextFm2;
            }
            g.setFont(font);
            String s = textRange.text.substring(Math.min(nextRowStartIndex, textRange.text.length()));
            if (startOffset > 0 && x == textX && s.startsWith(" ")) {
                s = s.substring(1);
            }
            if (s.length() > paintLength) {
                s = s.substring(0, paintLength);
            }
            if (s.contains("\r") || s.contains("\n")) {
                if (textRange.styleRange.getStartIndex() + textRange.styleRange.getLength() >= endOffset) break;
                s = this.truncatedTextSuffix;
            }
            if ((widthLeft = paintWidth + textX - x) < (strWidth = fm2.stringWidth(s))) {
                if (strWidth <= 0) {
                    return;
                }
                if (label.isLineWrap() && !lastRow) {
                    int nextRowStartIndexInSubString;
                    int nextWordStartIndex;
                    int availLength = s.length() * widthLeft / strWidth + 1;
                    int loopCount = 0;
                    do {
                        String subStringThisRow;
                        String subString;
                        int firstRowWordEndIndex;
                        int n = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex((String)(subString = s.substring(0, Math.max(0, Math.min(availLength, s.length())))))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex((String)s, (int)firstRowWordEndIndex);
                        if (firstRowWordEndIndex < 0 && x == textX) {
                            firstRowWordEndIndex = 0;
                            nextWordStartIndex = Math.min(s.length(), availLength);
                        }
                        if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                            availLength = subString.length() * widthLeft / strWidth;
                        }
                        if (++loopCount <= 50) continue;
                        Log.error((String)("Styled label paint error: " + textRange));
                        break;
                    } while (strWidth > widthLeft && availLength > 0);
                    while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                        ++nextRowStartIndexInSubString;
                    }
                    s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                    strWidth = fm2.stringWidth(s);
                    charDisplayed -= textRange.text.length() - nextRowStartIndex;
                    if (displayMnemonic) {
                        if (mnemonicIndex >= 0 && s.length() > mnemonicIndex - charDisplayed) {
                            displayMnemonic = true;
                            mneIndex = mnemonicIndex - charDisplayed;
                        } else {
                            displayMnemonic = false;
                        }
                    }
                    charDisplayed += s.length();
                } else {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, label.getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            } else if (!label.isLineWrap() && i < this.textRanges.size() - 1) {
                String nextS;
                TextRange nextTextRange = this.textRanges.get(i + 1);
                String nextText = nextTextRange.text;
                StyleRange nextStyle = nextTextRange.styleRange;
                int size = nextStyle != null && (nextStyle.isSuperscript() || nextStyle.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
                font = StyledLabelUtils.getFont(label);
                if (nextStyle != null && (nextStyle.getStyle() != -1 && font.getStyle() != nextStyle.getStyle() || font.getSize() != size)) {
                    font = FontUtils.getCachedDerivedFont((Font)font, (int)(nextStyle.getStyle() == -1 ? font.getStyle() : nextStyle.getStyle()), (int)size);
                    nextFm2 = label.getFontMetrics(font);
                } else {
                    nextFm2 = fm;
                }
                if (nextFm2.stringWidth(nextText) > widthLeft - strWidth && nextFm2.stringWidth(nextS = SwingUtilities.layoutCompoundLabel(label, nextFm2, nextText, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x + strWidth, y, widthLeft - strWidth, label.getHeight()), new Rectangle(), new Rectangle(), 0)) > widthLeft - strWidth) {
                    s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, strWidth - 1, label.getHeight()), new Rectangle(), new Rectangle(), 0);
                    strWidth = fm2.stringWidth(s);
                }
            }
            if (style != null && style.isSuperscript()) {
                y -= fm.getHeight() - fm2.getHeight();
            }
            if (style != null && style.getBackground() != null) {
                g.setPaint(style.getBackground());
                g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
            }
            if (label.isEnabled()) {
                Color textColor = style != null && !this.ignoreColorSettings && style.getForeground() != null ? style.getForeground() : label.getForeground();
                g.setPaint(textColor);
                this.paintStyledTextFragment(g, s, x, y, displayMnemonic, mneIndex, fm2, style, strWidth);
            } else {
                g.setPaint(this.disabledForeground);
                this.paintStyledTextFragment(g, s, x, y, displayMnemonic, mneIndex, fm2, style, strWidth);
            }
            x += strWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String layoutCL(E label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        Dimension size = null;
        int oldPreferredWidth = label.getPreferredWidth();
        int oldRows = label.getRows();
        try {
            if (label.isLineWrap() && label.getWidth() > 0) {
                label.setPreferredWidth(label.getWidth());
            }
            size = this.getPreferredTextSize();
            if (oldPreferredWidth > 0 && oldPreferredWidth < label.getWidth()) {
                label.setPreferredWidth(oldPreferredWidth);
                size = this.getPreferredTextSize();
            } else if (label.isLineWrap() && label.getMinimumRows() > 0) {
                label.setPreferredWidth(0);
                label.setRows(0);
                Dimension minSize = this.getPreferredTextSize();
                if (minSize.height > size.height) {
                    size = minSize;
                }
            }
        }
        finally {
            label.setPreferredWidth(oldPreferredWidth);
            label.setRows(oldRows);
        }
        textR.width = size.width;
        textR.height = size.height;
        int va = label.getVerticalAlignment();
        int ha = label.getHorizontalAlignment();
        int vtp = label.getVerticalTextPosition();
        int htp = label.getHorizontalTextPosition();
        int gap = label.getIconTextGap();
        return StyledLabelUtils.layoutCompoundLabel(label, (String)text, (Icon)icon, (int)va, (int)ha, (int)vtp, (int)htp, (Rectangle)viewR, (Rectangle)iconR, (Rectangle)textR, (int)gap);
    }

    public Dimension getContentSize() {
        this.retrievingPreferredSize = true;
        Dimension ps = this.getPreferredSizeImpl();
        this.retrievingPreferredSize = false;
        return ps;
    }

    protected Dimension getPreferredSizeImpl() {
        Dimension dimension = this.getPreferredTextSize();
        if (((WebStyledLabel)this.component).getIcon() != null) {
            dimension = new Dimension(dimension.width + ((WebStyledLabel)this.component).getIconTextGap() + ((WebStyledLabel)this.component).getIcon().getIconWidth(), Math.max(dimension.height, ((WebStyledLabel)this.component).getIcon().getIconHeight()));
        }
        return dimension;
    }

    protected Dimension getPreferredTextSize() {
        FontMetrics fm2;
        StyledLabelUtils.buildTextRanges((WebStyledLabel)((WebStyledLabel)this.component), this.textRanges);
        Font font = StyledLabelUtils.getFont((WebStyledLabel)((WebStyledLabel)this.component));
        FontMetrics fm = ((WebStyledLabel)this.component).getFontMetrics(font);
        int defaultFontSize = font.getSize();
        boolean lineWrap = ((WebStyledLabel)this.component).isLineWrap() || ((WebStyledLabel)this.component).getText() != null && (((WebStyledLabel)this.component).getText().contains("\r") || ((WebStyledLabel)this.component).getText().contains("\n"));
        TextRange[] texts = this.textRanges.toArray(new TextRange[this.textRanges.size()]);
        int maxRowHeight = fm.getHeight();
        for (TextRange textRange : texts) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont((WebStyledLabel)((WebStyledLabel)this.component));
            int styleHeight = fm.getHeight();
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                fm2 = ((WebStyledLabel)this.component).getFontMetrics(font);
                styleHeight = fm2.getHeight();
            }
            maxRowHeight = Math.max(maxRowHeight, styleHeight);
        }
        int naturalRowCount = 1;
        boolean nextRowStartIndex = false;
        int width = 0;
        int maxWidth = 0;
        ArrayList<Integer> lineWidths = new ArrayList<Integer>();
        for (TextRange textRange : this.textRanges) {
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont((WebStyledLabel)((WebStyledLabel)this.component));
            String s = textRange.text.substring(0);
            if (s.startsWith("\r") || s.startsWith("\n")) {
                lineWidths.add(width);
                maxWidth = Math.max(width, maxWidth);
                width = 0;
                if (((WebStyledLabel)this.component).getMaximumRows() <= 0 || ++naturalRowCount < ((WebStyledLabel)this.component).getMaximumRows()) continue;
                break;
            }
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                fm2 = ((WebStyledLabel)this.component).getFontMetrics(font);
                width += fm2.stringWidth(s);
                continue;
            }
            width += fm.stringWidth(s);
        }
        lineWidths.add(width);
        int maxLineWidth = maxWidth = Math.max(width, maxWidth);
        this.preferredRowCount = naturalRowCount;
        if (lineWrap && ((WebStyledLabel)this.component).getPreferredWidth() <= 0 && ((WebStyledLabel)this.component).getRows() > 0) {
            maxWidth = this.getMaximumWidth((WebStyledLabel)this.component, maxWidth, naturalRowCount, ((WebStyledLabel)this.component).getRows());
        }
        int preferredWidth = ((WebStyledLabel)this.component).getPreferredWidth();
        Insets insets = ((WebStyledLabel)this.component).getInsets();
        if (preferredWidth > 0 && insets != null) {
            preferredWidth -= insets.left + insets.right;
        }
        if (((WebStyledLabel)this.component).getIcon() != null && ((WebStyledLabel)this.component).getHorizontalTextPosition() != 0) {
            preferredWidth -= ((WebStyledLabel)this.component).getIcon().getIconWidth() + ((WebStyledLabel)this.component).getIconTextGap();
        }
        if (lineWrap && preferredWidth > 0 && maxWidth > preferredWidth) {
            maxWidth = this.getLayoutWidth((WebStyledLabel)this.component, preferredWidth);
        }
        if (lineWrap && ((WebStyledLabel)this.component).getMaximumRows() > 0 && this.preferredRowCount > ((WebStyledLabel)this.component).getMaximumRows()) {
            if (((WebStyledLabel)this.component).getPreferredWidth() <= 0) {
                maxWidth = this.getMaximumWidth((WebStyledLabel)this.component, maxWidth, naturalRowCount, ((WebStyledLabel)this.component).getMaximumRows());
            } else {
                this.preferredRowCount = ((WebStyledLabel)this.component).getMaximumRows();
            }
        }
        if (lineWrap && ((WebStyledLabel)this.component).getPreferredWidth() <= 0 && ((WebStyledLabel)this.component).getMinimumRows() > 0 && this.preferredRowCount < ((WebStyledLabel)this.component).getMinimumRows()) {
            maxWidth = this.getMaximumWidth((WebStyledLabel)this.component, maxWidth, naturalRowCount, ((WebStyledLabel)this.component).getMinimumRows());
        }
        if (this.retrievingPreferredSize && ((WebStyledLabel)this.component).getRows() > 0 && this.preferredRowCount > ((WebStyledLabel)this.component).getRows() && (((WebStyledLabel)this.component).getPreferredWidth() <= 0 || ((WebStyledLabel)this.component).getPreferredWidth() >= maxLineWidth || naturalRowCount > ((WebStyledLabel)this.component).getRows())) {
            this.preferredRowCount = ((WebStyledLabel)this.component).getRows();
            maxLineWidth = 0;
            for (int i = 0; i < lineWidths.size() && i < this.preferredRowCount; ++i) {
                maxLineWidth = Math.max(maxLineWidth, (Integer)lineWidths.get(i));
            }
        }
        int lineGap = Math.max(0, ((WebStyledLabel)this.component).getRowGap());
        return new Dimension(Math.min(maxWidth, maxLineWidth), (maxRowHeight + lineGap) * this.preferredRowCount - lineGap);
    }

    protected int getLayoutWidth(E label, int maxWidth) {
        Font font = StyledLabelUtils.getFont(label);
        int defaultFontSize = font.getSize();
        FontMetrics fm = label.getFontMetrics(font);
        int nextRowStartIndex = 0;
        int x = 0;
        this.preferredRowCount = 1;
        for (int i = 0; i < this.textRanges.size(); ++i) {
            FontMetrics fm2;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            if (textRange.text.contains("\r") || textRange.text.contains("\n")) {
                x = 0;
                ++this.preferredRowCount;
                continue;
            }
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                fm2 = label.getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = textRange.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            boolean wrapped = false;
            int widthLeft = maxWidth - x;
            if (widthLeft < strWidth) {
                int nextWordStartIndex;
                wrapped = true;
                int availLength = s.length() * widthLeft / strWidth + 1;
                int nextRowStartIndexInSubString = 0;
                boolean needBreak = false;
                boolean needContinue = false;
                int loopCount = 0;
                do {
                    String subStringThisRow;
                    String subString;
                    int firstRowWordEndIndex;
                    int n = nextWordStartIndex = (firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex((String)(subString = s.substring(0, Math.min(availLength, s.length()))))) < 0 ? 0 : StyledLabelUtils.findNextWordStartIndex((String)s, (int)firstRowWordEndIndex);
                    if (firstRowWordEndIndex < 0) {
                        if (x != 0) {
                            x = 0;
                            --i;
                            ++this.preferredRowCount;
                            if (label.getMaximumRows() > 0 && this.preferredRowCount >= label.getMaximumRows()) {
                                needBreak = true;
                            }
                            needContinue = true;
                            break;
                        }
                        firstRowWordEndIndex = 0;
                        nextWordStartIndex = Math.min(s.length(), availLength);
                    }
                    if ((strWidth = fm2.stringWidth(subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString = firstRowWordEndIndex + 1, s.length())))) > widthLeft) {
                        availLength = subString.length() * widthLeft / strWidth;
                    }
                    if (++loopCount <= 50) continue;
                    Log.error((String)("Styled label paint error: " + textRange));
                    break;
                } while (strWidth > widthLeft && availLength > 0);
                if (needBreak) break;
                if (needContinue) continue;
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(nextRowStartIndexInSubString))) < widthLeft) {
                    ++nextRowStartIndexInSubString;
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
            } else {
                nextRowStartIndex = 0;
            }
            if (wrapped) {
                ++this.preferredRowCount;
                x = 0;
                --i;
                continue;
            }
            x += strWidth;
        }
        return maxWidth;
    }

    protected int getMaximumWidth(E label, int maxWidth, int natural, int limited) {
        int paintRows;
        int textWidth = label.getWidth() - label.getInsets().left - label.getInsets().right;
        if (label.getIcon() != null) {
            textWidth -= label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        if (natural > 1) {
            int proposedMaxWidthMin = 1;
            int proposedMaxWidthMax = maxWidth;
            this.preferredRowCount = natural;
            while (proposedMaxWidthMin < proposedMaxWidthMax) {
                int middle = (proposedMaxWidthMax + proposedMaxWidthMin) / 2;
                maxWidth = this.getLayoutWidth(label, middle);
                if (this.preferredRowCount > limited) {
                    proposedMaxWidthMin = middle + 1;
                    this.preferredRowCount = natural;
                    continue;
                }
                proposedMaxWidthMax = middle - 1;
            }
            return maxWidth + maxWidth / 20;
        }
        int estimatedWidth = maxWidth / limited + 1;
        int x = 0;
        int nextRowStartIndex = 0;
        Font font = StyledLabelUtils.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        int defaultFontSize = font.getSize();
        for (int i = 0; i < this.textRanges.size(); ++i) {
            FontMetrics fm2;
            TextRange textRange = this.textRanges.get(i);
            StyleRange style = textRange.styleRange;
            int size = style != null && (style.isSuperscript() || style.isSubscript()) ? Math.round((float)defaultFontSize / this.scriptFontRatio) : defaultFontSize;
            font = StyledLabelUtils.getFont(label);
            if (style != null && (style.getStyle() != -1 && font.getStyle() != style.getStyle() || font.getSize() != size)) {
                font = FontUtils.getCachedDerivedFont((Font)font, (int)(style.getStyle() == -1 ? font.getStyle() : style.getStyle()), (int)size);
                fm2 = label.getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            String s = textRange.text.substring(nextRowStartIndex);
            int strWidth = fm2.stringWidth(s);
            int widthLeft = estimatedWidth - x;
            if (widthLeft < strWidth) {
                int availLength = s.length() * widthLeft / strWidth + 1;
                String subString = s.substring(0, Math.min(availLength, s.length()));
                int firstRowWordEndIndex = StyledLabelUtils.findFirstRowWordEndIndex((String)subString);
                int nextWordStartIndex = StyledLabelUtils.findNextWordStartIndex((String)s, (int)firstRowWordEndIndex);
                if (firstRowWordEndIndex < 0) {
                    firstRowWordEndIndex = nextWordStartIndex < s.length() ? StyledLabelUtils.findFirstRowWordEndIndex((String)s.substring(0, nextWordStartIndex)) : nextWordStartIndex;
                }
                int nextRowStartIndexInSubString = firstRowWordEndIndex + 1;
                String subStringThisRow = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(subStringThisRow);
                while (nextRowStartIndexInSubString < nextWordStartIndex && (strWidth += fm2.charWidth(s.charAt(++nextRowStartIndexInSubString))) < widthLeft) {
                }
                s = s.substring(0, Math.min(nextRowStartIndexInSubString, s.length()));
                strWidth = fm2.stringWidth(s);
                nextRowStartIndex += nextRowStartIndexInSubString;
                if (x + strWidth >= maxWidth) {
                    x = Math.max(x, strWidth);
                    break;
                }
                if (x + strWidth >= estimatedWidth) {
                    x += strWidth;
                    break;
                }
                --i;
            }
            x += strWidth;
        }
        int paintWidth = x;
        if (label.getInsets() != null) {
            paintWidth += label.getInsets().left + label.getInsets().right;
        }
        if ((paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth)) != limited) {
            maxWidth = Math.min(maxWidth, textWidth);
            while (paintRows > limited && paintWidth < maxWidth) {
                paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth += 2);
            }
            while (paintRows < limited && paintWidth > 0) {
                paintRows = this.paintStyledTextImpl(label, null, 0, 0, paintWidth -= 2);
            }
            x = paintWidth;
            if (label.getInsets() != null) {
                x -= label.getInsets().left + label.getInsets().right;
            }
        }
        this.preferredRowCount = limited;
        return x;
    }
}

