/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.Application;
import de.sciss.fscape.gui.BasicCellRenderer;
import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ListDlg;
import de.sciss.fscape.proc.ProcessorEvent;
import de.sciss.fscape.proc.ProcessorListener;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.session.Session;
import de.sciss.fscape.util.Util;
import de.sciss.gui.GUIUtil;
import de.sciss.util.Flag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultFormatter;

public class BatchDlg
extends ModulePanel {
    private static final int PR_BATCH = 0;
    private static final int PR_VISIBLE = 0;
    private static final int PR_CONSOLE = 1;
    private static final String PRN_BATCH = "Batch";
    private static final String PRN_VISIBLE = "Visible";
    private static final String PRN_CONSOLE = "Console";
    private static final String[] prText = new String[]{""};
    private static final String[] prTextName = new String[]{"Batch"};
    private static final boolean[] prBool = new boolean[]{false, false};
    private static final String[] prBoolName = new String[]{"Visible", "Console"};
    private static final int GG_BATCH = 2048;
    private static final int GG_CMDCUT = 2049;
    private static final int GG_CMDCOPY = 2050;
    private static final int GG_CMDPASTE = 2051;
    private static final int GG_CMDOPEN = 2052;
    private static final int GG_CMDADD = 2053;
    private static final int GG_PARAMS = 2059;
    private static final int GG_BATCHPANE = 2062;
    private static final int GG_PARAMSPANE = 2063;
    private static final int GG_VISIBLE = 0;
    private static final int GG_CONSOLE = 1;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;
    private static final String ERR_DELETE = "File was not deleted";
    protected static final String[] EXCLUDE_DLG = new String[]{"MainFrame", "PrefsDlg", "ParamSettingsDlg", "FileInfoDlg"};
    protected BatchTableModel batchTM;
    protected ParamTableModel paramTM;
    private BatchCellRenderer batchCR;
    protected JTable batchTable;
    private JTable paramTable;
    protected List<BatchObject> batchVector;
    private TableModelListener tml;
    protected ClipboardOwner cbo;
    private ProcessorListener procL;

    public BatchDlg() {
        super("Batch Processor");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            BatchDlg.static_pr.text = prText;
            BatchDlg.static_pr.textName = prTextName;
            BatchDlg.static_pr.bool = prBool;
            BatchDlg.static_pr.boolName = prBoolName;
        }
        if (static_presets == null) {
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.batchVector = new ArrayList<BatchObject>();
        new BatchObjectArray();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        final BatchDlg batchDlg = this;
        this.cbo = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        };
        this.procL = new ProcessorListener(){

            @Override
            public void processorStarted(ProcessorEvent processorEvent) {
                this.teleAction();
            }

            @Override
            public void processorStopped(ProcessorEvent processorEvent) {
                this.teleAction();
            }

            @Override
            public void processorPaused(ProcessorEvent processorEvent) {
                this.teleAction();
            }

            @Override
            public void processorResumed(ProcessorEvent processorEvent) {
                this.teleAction();
            }

            @Override
            public void processorProgress(ProcessorEvent processorEvent) {
                this.teleAction();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void teleAction() {
                BatchDlg batchDlg2 = batchDlg;
                synchronized (batchDlg2) {
                    batchDlg.notify();
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = BatchDlg.this.gui.getItemID(actionEvent);
                switch (n) {
                    case 2052: {
                        if (BatchDlg.this.batchTable.getSelectedRowCount() != 1) break;
                        BatchObject batchObject = BatchDlg.this.batchVector.get(BatchDlg.this.batchTable.getSelectedRow());
                        if (batchObject.command != 0) break;
                        try {
                            ModulePanel modulePanel = BatchDlg.this.getProcInstance(batchObject, null);
                            modulePanel.fillGUI();
                            modulePanel.setVisible(true);
                        }
                        catch (Exception exception) {
                            GUIUtil.displayError((Component)BatchDlg.this.getComponent(), (Exception)exception, (String)BatchDlg.this.getTitle());
                        }
                        break;
                    }
                    case 2053: {
                        int n2 = BatchDlg.this.batchTable.getSelectedRow() + 1;
                        n2 = n2 == 0 ? BatchDlg.this.batchVector.size() : n2;
                        BatchDlg.this.batchTable.clearSelection();
                        BatchDlg.this.batchVector.add(n2, new BatchObject());
                        BatchDlg.this.batchTM.fireTableRowsInserted(n2, n2);
                        BatchDlg.this.batchTable.setRowSelectionInterval(n2, n2);
                        break;
                    }
                    case 2049: 
                    case 2050: {
                        int n3;
                        int[] nArray = BatchDlg.this.batchTable.getSelectedRows();
                        if (nArray.length <= 0) break;
                        BatchObject[] batchObjectArray = new BatchObject[nArray.length];
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            batchObjectArray[n3] = new BatchObject(BatchDlg.this.batchVector.get(nArray[n3]));
                        }
                        Application.clipboard.setContents(new BatchObjectArray(batchObjectArray), BatchDlg.this.cbo);
                        if (n != 2049) break;
                        boolean bl = false;
                        while (!bl) {
                            int n4 = -1;
                            int n5 = -1;
                            for (n3 = 0; n3 < nArray.length; ++n3) {
                                if (nArray[n3] <= n4) continue;
                                n4 = nArray[n3];
                                n5 = n3;
                            }
                            if (n4 >= 0) {
                                BatchDlg.this.batchVector.remove(n4);
                                nArray[n5] = -1;
                                BatchDlg.this.batchTM.fireTableRowsDeleted(n4, n4);
                                continue;
                            }
                            bl = true;
                        }
                        break;
                    }
                    case 2051: {
                        int n6 = BatchDlg.this.batchTable.getSelectedRow() + 1;
                        n6 = n6 == 0 ? BatchDlg.this.batchVector.size() : n6;
                        try {
                            BatchObject[] batchObjectArray;
                            Transferable transferable = Application.clipboard.getContents(batchDlg);
                            if (transferable == null || !transferable.isDataFlavorSupported(BatchObjectArray.flavor) || (batchObjectArray = (BatchObject[])transferable.getTransferData(BatchObjectArray.flavor)).length <= 0) break;
                            BatchDlg.this.batchTable.clearSelection();
                            int n7 = 0;
                            int n8 = n6;
                            while (n7 < batchObjectArray.length) {
                                BatchDlg.this.batchVector.add(n8, batchObjectArray[n7]);
                                ++n7;
                                ++n8;
                            }
                            BatchDlg.this.batchTM.fireTableRowsInserted(n6, n8 - 1);
                            BatchDlg.this.batchTable.setRowSelectionInterval(n6, n8 - 1);
                            break;
                        }
                        catch (IllegalStateException illegalStateException) {
                            break;
                        }
                        catch (IOException iOException) {
                            break;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.tml = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getSource() == BatchDlg.this.batchTM) {
                    if (tableModelEvent.getType() == -1) {
                        return;
                    }
                    int n = tableModelEvent.getFirstRow();
                    if (n >= 0 && !BatchDlg.this.batchVector.isEmpty()) {
                        BatchObject batchObject = BatchDlg.this.batchVector.get(n);
                        if (batchObject.command == 0 && batchObject.modObj.modClass == null) {
                            int n2;
                            int n3;
                            Application.DocumentHandler documentHandler = Application.documentHandler;
                            Session[] sessionArray = documentHandler.getDocuments();
                            ModulePanel[] modulePanelArray = new ModulePanel[sessionArray.length];
                            for (int i = 0; i < modulePanelArray.length; ++i) {
                                modulePanelArray[i] = sessionArray[i].getFrame();
                            }
                            int n4 = modulePanelArray.length;
                            for (n3 = 0; n3 < n4; ++n3) {
                                String string = modulePanelArray[n3].getClass().getName();
                                string = string.substring(string.lastIndexOf(46) + 1);
                                if (modulePanelArray[n3] != batchDlg && !Util.isValueInArray(string, EXCLUDE_DLG)) continue;
                                --n4;
                                for (n2 = n3; n2 < n4; ++n2) {
                                    modulePanelArray[n2] = modulePanelArray[n2 + 1];
                                }
                                --n3;
                            }
                            String[] stringArray = new String[n4];
                            for (n3 = 0; n3 < n4; ++n3) {
                                stringArray[n3] = modulePanelArray[n3].getModuleName();
                            }
                            if (n4 > 1) {
                                ListDlg listDlg = new ListDlg(BatchDlg.this.getComponent(), "Choose Module", stringArray);
                                n3 = listDlg.getList();
                            } else {
                                n3 = n4 - 1;
                            }
                            if (n3 < 0) {
                                return;
                            }
                            batchObject.modObj.name = stringArray[n3];
                            modulePanelArray[n3].fillPropertyArray();
                            PropertyArray propertyArray = modulePanelArray[n3].getPropertyArray();
                            batchObject.modObj.prParam = propertyArray.toProperties(true);
                            batchObject.modObj.modClass = modulePanelArray[n3].getClass().getName();
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            for (n2 = 0; n2 < propertyArray.text.length; ++n2) {
                                if (!propertyArray.textName[n2].contains("File")) continue;
                                arrayList.add(new Integer(n2));
                            }
                            batchObject.modObj.modParam = new String[arrayList.size()][2];
                            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                                batchObject.modObj.modParam[n2][0] = propertyArray.textName[n2];
                                batchObject.modObj.modParam[n2][1] = propertyArray.text[n2];
                            }
                            BatchDlg.this.batchTM.fireTableRowsUpdated(n, n);
                            BatchDlg.this.updateParamTable();
                        }
                    }
                } else if (tableModelEvent.getSource() == BatchDlg.this.paramTM) {
                    // empty if block
                }
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Batch List", 1, 0));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.initBatchTable();
        this.gui.registerGadget(this.batchTable, 2048);
        JScrollPane jScrollPane = new JScrollPane(this.batchTable);
        this.gui.addGadget(jScrollPane, 2062);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.05;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton(" Add ");
        this.gui.registerGadget(jButton, 2053);
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton(" Cut ");
        this.gui.registerGadget(jButton, 2049);
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton(" Copy ");
        this.gui.registerGadget(jButton, 2050);
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton(" Paste ");
        this.gui.registerGadget(jButton, 2051);
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton(" Open ");
        this.gui.registerGadget(jButton, 2052);
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        gridBagConstraints.gridwidth = 0;
        this.gui.addGadget(jPanel, 2714);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Module Parameter Settings", 1, 0));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.initParamTable();
        this.gui.registerGadget(this.paramTable, 2059);
        JScrollPane jScrollPane2 = new JScrollPane(this.paramTable);
        this.gui.addGadget(jScrollPane2, 2063);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Control Settings", 1, 0));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        JCheckBox jCheckBox = new JCheckBox("Visible modules");
        this.gui.addCheckbox(jCheckBox, 0, null);
        gridBagConstraints.gridwidth = 0;
        JCheckBox jCheckBox2 = new JCheckBox("Console output");
        this.gui.addCheckbox(jCheckBox2, 1, null);
        this.setPreferredSize(new Dimension(500, 600));
        this.initGUI(this, 38, this.gui);
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
        Properties properties = Presets.valueToProperties(this.getPropertyArray().text[0]);
        int n = properties == null ? 0 : properties.size();
        this.batchVector.clear();
        for (int i = 0; i < n; ++i) {
            BatchObject batchObject = BatchObject.valueOf((String)properties.get(String.valueOf(i)));
            this.batchVector.add(batchObject);
        }
        this.batchTM.fireTableDataChanged();
    }

    @Override
    public void fillPropertyArray() {
        Properties properties = new Properties();
        int n = this.batchVector.size();
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
        for (int i = 0; i < n; ++i) {
            properties.put(String.valueOf(i), this.batchVector.get(i).toString());
        }
        this.getPropertyArray().text[0] = Presets.propertiesToValue(properties);
    }

    private void initBatchTable() {
        int n;
        this.batchTM = new BatchTableModel(this.batchVector);
        this.batchTable = new JTable(this.batchTM);
        this.batchCR = new BatchCellRenderer();
        int[] nArray = new int[]{60, 112, 256, 96, 118};
        for (n = 0; n < nArray.length; ++n) {
            TableColumn tableColumn = this.batchTable.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(nArray[n]);
            tableColumn.setCellRenderer(this.batchCR);
        }
        this.batchTable.getTableHeader().setReorderingAllowed(false);
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (n = 0; n < BatchCellRenderer.CMD_NAMES.length; ++n) {
            jComboBox.addItem(BatchCellRenderer.CMD_NAMES[n]);
        }
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        for (n = 0; n < BatchCellRenderer.ERR_NAMES.length; ++n) {
            jComboBox2.addItem(BatchCellRenderer.ERR_NAMES[n]);
        }
        BatchCellEditor batchCellEditor = new BatchCellEditor();
        this.batchTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        this.batchTable.getColumnModel().getColumn(2).setCellEditor(batchCellEditor);
        this.batchTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(jComboBox2));
        this.batchTable.getColumnModel().getColumn(4).setCellEditor(batchCellEditor);
        this.batchTable.setShowHorizontalLines(true);
        this.batchTable.setShowVerticalLines(true);
        this.batchTable.setIntercellSpacing(new Dimension(1, 1));
        this.batchTM.addTableModelListener(this.tml);
        this.batchTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BatchDlg.this.updateParamTable();
            }
        });
    }

    protected void initParamTable() {
        BasicCellRenderer basicCellRenderer = new BasicCellRenderer();
        this.paramTM = new ParamTableModel();
        this.paramTM.addTableModelListener(this.tml);
        this.paramTable = new JTable(this.paramTM);
        this.paramTable.getTableHeader().setReorderingAllowed(false);
        int[] nArray = new int[]{108, 324};
        for (int i = 0; i < nArray.length; ++i) {
            TableColumn tableColumn = this.paramTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(nArray[i]);
            tableColumn.setCellRenderer(basicCellRenderer);
        }
        this.paramTable.setShowHorizontalLines(true);
        this.paramTable.setShowVerticalLines(true);
        this.paramTable.setIntercellSpacing(new Dimension(1, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        ArrayList<BatchObject> arrayList = new ArrayList<BatchObject>();
        int n = this.batchVector.size();
        int n2 = 0;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        boolean bl = false;
        try {
            StringBuffer stringBuffer;
            int n3 = 0;
            block25: while (this.threadRunning && n3 < n) {
                BatchObject batchObject = this.batchVector.get(n3);
                this.batchTable.clearSelection();
                this.batchTable.setRowSelectionInterval(n3, n3);
                this.batchTable.scrollRectToVisible(this.batchTable.getCellRect(n3, 0, true));
                Exception exception = null;
                if (this.pr.bool[1]) {
                    stringBuffer = new StringBuffer();
                    String string = String.valueOf(n3 + 1);
                    stringBuffer.append("     ".substring(string.length()));
                    stringBuffer.append(string);
                    stringBuffer.append("  ");
                    Component component = this.batchCR.getTableCellRendererComponent(this.batchTable, batchObject, false, false, n3, 1);
                    if (component instanceof JLabel) {
                        stringBuffer.append(((JLabel)component).getText());
                    }
                    stringBuffer.append(": ");
                    component = this.batchCR.getTableCellRendererComponent(this.batchTable, batchObject, false, false, n3, 2);
                    if (component instanceof JLabel) {
                        stringBuffer.append(this.replaceLoopVars(((JLabel)component).getText(), arrayList));
                    }
                    stringBuffer.append("  ");
                    this.consoleLine(stringBuffer.toString(), dateFormat);
                }
                block7 : switch (batchObject.command) {
                    case 0: {
                        batchObject.process = 0.001f;
                        this.batchTM.fireTableCellUpdated(n3, 2);
                        try {
                            ModulePanel modulePanel = this.getProcInstance(batchObject, arrayList);
                            modulePanel.fillGUI();
                            if (this.pr.bool[0]) {
                                modulePanel.setVisible(true);
                            }
                            try {
                                bl = true;
                                modulePanel.addProcessorListener(this.procL);
                                modulePanel.start();
                                int n4 = 1;
                                do {
                                    try {
                                        BatchDlg batchDlg = this;
                                        synchronized (batchDlg) {
                                            this.wait(3000L);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    batchObject.process = modulePanel.getProgression();
                                    this.batchTM.fireTableCellUpdated(n3, 2);
                                    int n5 = (int)(batchObject.process * 10.0f);
                                    if (n5 >= n4) {
                                        if (this.pr.bool[1]) {
                                            System.out.print(n5 * 10 + "%  ");
                                        }
                                        n4 = n5 + 1;
                                    }
                                    this.setProgression(0.5f);
                                    if (modulePanel.isThreadRunning()) continue;
                                    bl = false;
                                } while (this.threadRunning && bl);
                                if (modulePanel.getError() != null) {
                                    throw modulePanel.getError();
                                }
                                bl = false;
                                modulePanel.removeProcessorListener(this.procL);
                                modulePanel.stop();
                                if (this.pr.bool[0]) {
                                    modulePanel.setVisible(false);
                                }
                                modulePanel.dispose();
                            }
                            catch (Exception exception2) {
                                bl = false;
                                modulePanel.removeProcessorListener(this.procL);
                                modulePanel.stop();
                                if (this.pr.bool[0]) {
                                    modulePanel.setVisible(false);
                                }
                                modulePanel.dispose();
                                throw exception2;
                            }
                        }
                        catch (Exception exception3) {
                            exception = exception3;
                        }
                        this.setProgression(0.5f);
                        batchObject.process = 0.0f;
                        this.batchTM.fireTableCellUpdated(n3, 2);
                        break;
                    }
                    case 2: {
                        batchObject.loopObj.processIdx = batchObject.loopObj.startIdx;
                        arrayList.add(batchObject);
                        break;
                    }
                    case 3: {
                        for (int i = arrayList.size() - 1; i >= 0; --i) {
                            BatchObject batchObject2 = (BatchObject)arrayList.get(i);
                            if (batchObject.loopObj.variable != batchObject2.loopObj.variable) continue;
                            if (++batchObject2.loopObj.processIdx <= batchObject2.loopObj.stopIdx) {
                                n3 = this.batchVector.indexOf(batchObject2);
                                if (!this.pr.bool[1]) break block7;
                                System.out.print(" = " + batchObject2.loopObj.processIdx);
                                break block7;
                            }
                            arrayList.remove(i);
                            break block7;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            if (!new File(this.replaceLoopVars(batchObject.fileObj, arrayList)).delete()) {
                                throw new IOException(ERR_DELETE);
                            }
                        }
                        catch (Exception exception4) {
                            exception = exception4;
                        }
                        break;
                    }
                    case 4: {
                        n3 = this.findLabelLine(batchObject.labelObj) - 1;
                    }
                }
                if (exception == null) {
                    ++n3;
                } else {
                    this.setError(exception);
                    ++n2;
                    if (this.pr.bool[1]) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\n");
                        stringBuffer.append(this.getError().getClass().getName());
                        stringBuffer.append(": ");
                        stringBuffer.append(this.getError().getLocalizedMessage());
                        System.out.println(stringBuffer.toString());
                    }
                    switch (batchObject.errorCmd) {
                        case 0: {
                            break block25;
                        }
                        case 2: {
                            n3 = this.findLabelLine(batchObject.labelObj);
                            break;
                        }
                        case 1: {
                            ++n3;
                            break;
                        }
                        default: {
                            assert (false) : batchObject.errorCmd;
                            break;
                        }
                    }
                }
                if (!this.pr.bool[1]) continue;
                System.out.println();
            }
            if (this.threadRunning) {
                this.setProgression(1.0f);
                if (this.pr.bool[1]) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("  Done. There ");
                    stringBuffer.append(n2 == 1 ? "was " : "were ");
                    stringBuffer.append(String.valueOf(n2));
                    stringBuffer.append(n2 == 1 ? " error.\n" : " errors.\n");
                    this.consoleLine(stringBuffer.toString(), dateFormat);
                }
                if (n2 > 0) {
                    this.setError(new Exception(this.getError().getClass().getName() + ": \n" + this.getError().getLocalizedMessage() + "\n(last out of " + n2 + " errors)"));
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.setError(illegalStateException);
        }
        bl = false;
    }

    private int findLabelLine(String string) {
        int n;
        for (n = 0; n < this.batchVector.size(); ++n) {
            BatchObject batchObject = this.batchVector.get(n);
            if (batchObject.command == 5 && batchObject.labelObj.equals(string)) break;
        }
        return n;
    }

    private void consoleLine(String string, DateFormat dateFormat) {
        System.out.print(dateFormat.format(new Date()) + string);
    }

    protected void updateParamTable() {
        String[][] stringArray = null;
        if (this.batchTable.getSelectedRowCount() == 1) {
            BatchObject batchObject = this.batchVector.get(this.batchTable.getSelectedRow());
            if (batchObject.command == 0) {
                stringArray = batchObject.modObj.modParam;
            }
        }
        this.paramTM.setParam(stringArray);
    }

    protected ModulePanel getProcInstance(BatchObject batchObject, List list) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ModulePanel modulePanel = (ModulePanel)Class.forName(batchObject.modObj.modClass).newInstance();
        PropertyArray propertyArray = modulePanel.getPropertyArray();
        propertyArray.fromProperties(true, batchObject.modObj.prParam);
        block0: for (int i = 0; i < batchObject.modObj.modParam.length; ++i) {
            for (int j = 0; j < propertyArray.textName.length; ++j) {
                if (!batchObject.modObj.modParam[i][0].equals(propertyArray.textName[j])) continue;
                propertyArray.text[j] = this.replaceLoopVars(batchObject.modObj.modParam[i][1], list);
                continue block0;
            }
        }
        return modulePanel;
    }

    private String replaceLoopVars(String string, List list) {
        if (list == null || list.isEmpty() || !string.contains("$")) {
            return string;
        }
        return this.replaceLoopVars(string, list, list.size() - 1, new Flag(false));
    }

    private String replaceLoopVars(String string, List list, int n, Flag flag) {
        LoopObject loopObject = ((BatchObject)list.get((int)n)).loopObj;
        String string2 = "$" + loopObject.variable;
        String string3 = null;
        for (int i = 0; i < 2; ++i) {
            int n2;
            boolean bl;
            StringBuffer stringBuffer = new StringBuffer(string);
            boolean bl2 = bl = i == 1;
            while ((n2 = stringBuffer.indexOf(string2)) >= 0) {
                String string4 = String.valueOf(loopObject.processIdx);
                int n3 = String.valueOf(loopObject.stopIdx).length() - string4.length();
                String string5 = bl ? "000000".substring(0, n3) + string4 : string4;
                stringBuffer.replace(n2, n2 + 2, string5);
            }
            string3 = stringBuffer.toString();
            if (n > 0) {
                string3 = this.replaceLoopVars(string3, list, n - 1, flag);
            } else {
                flag.set(new File(string3).exists());
            }
            if (!flag.isSet()) continue;
            return string3;
        }
        return string3;
    }

    protected static class ParamTableModel
    extends AbstractTableModel {
        private static final String[] columnNames = new String[]{"Parameter", "Value"};
        private String[][] emptyData = new String[0][2];
        private String[][] paramData = this.emptyData;

        protected ParamTableModel() {
        }

        protected void setParam(String[][] stringArray) {
            if (stringArray != null) {
                this.paramData = stringArray;
                this.fireTableDataChanged();
            } else {
                boolean bl = this.paramData.length == 0;
                this.paramData = this.emptyData;
                if (!bl) {
                    this.fireTableDataChanged();
                }
            }
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.paramData.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.paramData[n][n2];
        }

        public Class getColumnClass(int n) {
            if (this.paramData.length == 0) {
                return null;
            }
            return this.paramData[0][n].getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.paramData[n][n2] = (String)object;
            this.fireTableRowsUpdated(n, n);
        }
    }

    protected static class ModuleObject {
        protected String name = "module";
        protected String modClass = null;
        protected Properties prParam = new Properties();
        protected String[][] modParam = new String[0][2];

        protected ModuleObject() {
        }

        protected ModuleObject(ModuleObject moduleObject) {
            this.name = moduleObject.name;
            this.modClass = moduleObject.modClass;
            this.prParam = moduleObject.prParam;
            this.modParam = new String[moduleObject.modParam.length][2];
            for (int i = 0; i < this.modParam.length; ++i) {
                this.modParam[i][0] = moduleObject.modParam[i][0];
                this.modParam[i][1] = moduleObject.modParam[i][1];
            }
        }
    }

    protected static class LoopObject {
        protected char variable = (char)65;
        protected int startIdx = 1;
        protected int stopIdx = 9;
        protected int processIdx;

        protected LoopObject() {
        }

        protected LoopObject(LoopObject loopObject) {
            this.variable = loopObject.variable;
            this.startIdx = loopObject.startIdx;
            this.stopIdx = loopObject.stopIdx;
        }
    }

    protected static class BatchObject {
        protected static final int CMD_MODULE = 0;
        protected static final int CMD_DELFILE = 1;
        protected static final int CMD_BEGLOOP = 2;
        protected static final int CMD_ENDLOOP = 3;
        protected static final int CMD_SKIP = 4;
        protected static final int CMD_LABEL = 5;
        protected static final boolean[] CMD_CANERROR = new boolean[]{true, true, false, false, false, false};
        private static final int ERR_STOP = 0;
        private static final int ERR_CONTINUE = 1;
        private static final int ERR_SKIP = 2;
        protected int command = 5;
        protected int errorCmd = 0;
        protected ModuleObject modObj = new ModuleObject();
        protected LoopObject loopObj = new LoopObject();
        protected String fileObj = "file";
        protected String labelObj = "label";
        protected float process = 0.0f;
        private static final String PR_CMD = "comd";
        private static final String PR_ERRCMD = "ecmd";
        private static final String PR_FILE = "file";
        private static final String PR_LABEL = "labl";
        private static final String PR_MODNAME = "mnam";
        private static final String PR_MODCLASS = "mcls";
        private static final String PR_MODPAR = "mpar";
        private static final String PR_MODMOD = "mmod";
        private static final String PR_LOOPVAR = "lvar";
        private static final String PR_LPSTART = "lbeg";
        private static final String PR_LPSTOP = "lend";

        protected BatchObject() {
        }

        protected BatchObject(BatchObject batchObject) {
            this.command = batchObject.command;
            this.errorCmd = batchObject.errorCmd;
            this.modObj = new ModuleObject(batchObject.modObj);
            this.loopObj = new LoopObject(batchObject.loopObj);
            this.fileObj = batchObject.fileObj;
            this.labelObj = batchObject.labelObj;
        }

        public static BatchObject valueOf(String string) {
            String string2;
            Properties properties = Presets.valueToProperties(string);
            BatchObject batchObject = new BatchObject();
            try {
                batchObject.fileObj = (String)properties.get(PR_FILE);
                batchObject.labelObj = (String)properties.get(PR_LABEL);
                batchObject.modObj.name = (String)properties.get(PR_MODNAME);
                batchObject.modObj.modClass = (String)properties.get(PR_MODCLASS);
                batchObject.command = Integer.parseInt((String)properties.get(PR_CMD));
                batchObject.errorCmd = Integer.parseInt((String)properties.get(PR_ERRCMD));
                string2 = (String)properties.get(PR_LOOPVAR);
                if (string2.length() > 0) {
                    batchObject.loopObj.variable = string2.charAt(0);
                }
                batchObject.loopObj.startIdx = Integer.parseInt((String)properties.get(PR_LPSTART));
                batchObject.loopObj.stopIdx = Integer.parseInt((String)properties.get(PR_LPSTOP));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            string2 = (String)properties.get(PR_MODPAR);
            if (string2 != null) {
                batchObject.modObj.prParam = Presets.valueToProperties(string2);
            }
            if ((string2 = (String)properties.get(PR_MODMOD)) != null) {
                Properties properties2 = Presets.valueToProperties(string2);
                batchObject.modObj.modParam = new String[properties2.size()][2];
                Enumeration<?> enumeration = properties2.propertyNames();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    batchObject.modObj.modParam[n][0] = string2 = (String)enumeration.nextElement();
                    batchObject.modObj.modParam[n][1] = properties2.getProperty(string2);
                    ++n;
                }
            }
            return batchObject;
        }

        public String toString() {
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            properties.put(PR_FILE, this.fileObj);
            properties.put(PR_LABEL, this.labelObj);
            properties.put(PR_MODNAME, this.modObj.name);
            if (this.modObj.modClass != null) {
                properties.put(PR_MODCLASS, this.modObj.modClass);
            }
            properties.put(PR_CMD, String.valueOf(this.command));
            properties.put(PR_ERRCMD, String.valueOf(this.errorCmd));
            properties.put(PR_LOOPVAR, String.valueOf(this.loopObj.variable));
            properties.put(PR_LPSTART, String.valueOf(this.loopObj.startIdx));
            properties.put(PR_LPSTOP, String.valueOf(this.loopObj.stopIdx));
            if (this.modObj.prParam != null) {
                properties.put(PR_MODPAR, Presets.propertiesToValue(this.modObj.prParam));
            }
            if (this.modObj.modParam != null) {
                for (int i = 0; i < this.modObj.modParam.length; ++i) {
                    properties2.setProperty(this.modObj.modParam[i][0], this.modObj.modParam[i][1]);
                }
                properties.put(PR_MODMOD, Presets.propertiesToValue(properties2));
            }
            return Presets.propertiesToValue(properties);
        }
    }

    protected static class BatchObjectArray
    implements Transferable {
        protected static DataFlavor flavor;
        private static DataFlavor[] flavors;
        private BatchObject[] obj;

        protected BatchObjectArray() {
            if (flavor == null) {
                flavor = new DataFlavor(this.getClass(), "Batch Object Array");
                flavors = new DataFlavor[1];
                BatchObjectArray.flavors[0] = flavor;
            }
        }

        protected BatchObjectArray(BatchObject[] batchObjectArray) {
            this.obj = batchObjectArray;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!dataFlavor.match(flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            for (int i = 0; i < flavors.length; ++i) {
                if (!dataFlavor.match(flavors[i])) continue;
                BatchObject[] batchObjectArray = new BatchObject[this.obj.length];
                for (int j = 0; j < batchObjectArray.length; ++j) {
                    batchObjectArray[j] = new BatchObject(this.obj[j]);
                }
                return batchObjectArray;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    protected class LoopCellEditor
    extends DefaultFormatter {
        private BatchObject obj = null;

        protected LoopCellEditor() {
        }

        @Override
        public String valueToString(Object object) {
            this.obj = (BatchObject)object;
            if (this.obj != null) {
                if (this.obj.command == 2) {
                    return String.valueOf(this.obj.loopObj.variable) + " = " + String.valueOf(this.obj.loopObj.startIdx) + " TO " + String.valueOf(this.obj.loopObj.stopIdx);
                }
                return String.valueOf(this.obj.loopObj.variable);
            }
            return "";
        }

        @Override
        public Object stringToValue(String string) {
            if (this.obj != null) {
                String string2 = string.toUpperCase();
                int n = string2.indexOf("=");
                int n2 = string2.indexOf("TO", n + 1);
                if (string2.length() > 0 && Character.isLetter(string2.charAt(0))) {
                    this.obj.loopObj.variable = string2.charAt(0);
                }
                if (n > 0 && n2 > n + 1 && n2 + 2 < string2.length()) {
                    try {
                        int n3;
                        this.obj.loopObj.startIdx = n3 = Math.max(0, Integer.parseInt(string2.substring(n + 1, n2).trim()));
                        this.obj.loopObj.stopIdx = n3 = Math.max(n3, Integer.parseInt(string2.substring(n2 + 2).trim()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return this.obj;
        }
    }

    protected class FileCellEditor
    extends DefaultFormatter {
        private BatchObject obj = new BatchObject();

        protected FileCellEditor() {
        }

        @Override
        public String valueToString(Object object) {
            this.obj = (BatchObject)object;
            if (this.obj != null) {
                return this.obj.fileObj;
            }
            return "";
        }

        @Override
        public Object stringToValue(String string) {
            this.obj.fileObj = string;
            return this.obj;
        }
    }

    protected class LabelCellEditor
    extends DefaultFormatter {
        private BatchObject obj = new BatchObject();

        protected LabelCellEditor() {
        }

        @Override
        public String valueToString(Object object) {
            this.obj = (BatchObject)object;
            if (this.obj != null) {
                return this.obj.labelObj;
            }
            return "";
        }

        @Override
        public Object stringToValue(String string) {
            this.obj.labelObj = string;
            return this.obj;
        }
    }

    protected class ModuleCellEditor
    extends DefaultFormatter {
        private BatchObject obj = null;

        protected ModuleCellEditor() {
        }

        @Override
        public String valueToString(Object object) {
            this.obj = (BatchObject)object;
            if (this.obj != null) {
                return this.obj.modObj.name;
            }
            return "";
        }

        @Override
        public Object stringToValue(String string) {
            if (this.obj != null) {
                this.obj.modObj.name = string;
            }
            return this.obj;
        }
    }

    protected class BatchCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ModuleCellEditor modCE;
        private JFormattedTextField modFTF;
        private LabelCellEditor labCE;
        private JFormattedTextField labFTF;
        private FileCellEditor fileCE;
        private JFormattedTextField fileFTF;
        private LoopCellEditor loopCE;
        private JFormattedTextField loopFTF;
        private BatchObject obj;

        protected BatchCellEditor() {
            this.modCE = new ModuleCellEditor();
            this.modFTF = new JFormattedTextField(this.modCE);
            this.labCE = new LabelCellEditor();
            this.labFTF = new JFormattedTextField(this.labCE);
            this.fileCE = new FileCellEditor();
            this.fileFTF = new JFormattedTextField(this.fileCE);
            this.loopCE = new LoopCellEditor();
            this.loopFTF = new JFormattedTextField(this.loopCE);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (!(object instanceof BatchObject)) {
                return null;
            }
            this.obj = (BatchObject)object;
            switch (n2) {
                case 2: {
                    switch (this.obj.command) {
                        case 0: {
                            this.modFTF.setValue(this.obj);
                            return this.modFTF;
                        }
                        case 4: 
                        case 5: {
                            this.labFTF.setValue(this.obj);
                            return this.labFTF;
                        }
                        case 1: {
                            this.fileFTF.setValue(this.obj);
                            return this.fileFTF;
                        }
                        case 2: 
                        case 3: {
                            this.loopFTF.setValue(this.obj);
                            return this.loopFTF;
                        }
                    }
                    break;
                }
                case 4: {
                    this.labFTF.setValue(this.obj);
                    return this.labFTF;
                }
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.obj;
        }
    }

    protected static class BatchCellRenderer
    extends BasicCellRenderer {
        protected static final String[] CMD_NAMES = new String[]{"Module", "Delete File", "Begin Loop", "End Loop", "Skip To", "Label"};
        protected static final String[] ERR_NAMES = new String[]{"Stop", "Continue", "Skip To"};
        private JProgressBar progBar = new JProgressBar(0, 100);

        protected BatchCellRenderer() {
            this.progBar.setStringPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.tr.setText("");
            block0 : switch (n2) {
                case 0: {
                    if (!(object instanceof Integer)) break;
                    this.tr.setText(object.toString());
                    this.tr.setHorizontalAlignment(4);
                    break;
                }
                case 1: {
                    if (!(object instanceof BatchObject)) break;
                    BatchObject batchObject = (BatchObject)object;
                    this.tr.setText(CMD_NAMES[batchObject.command]);
                    break;
                }
                case 2: {
                    if (!(object instanceof BatchObject)) break;
                    BatchObject batchObject = (BatchObject)object;
                    switch (batchObject.command) {
                        case 0: {
                            if (batchObject.process == 0.0f) {
                                this.tr.setFont(this.boldFont);
                                this.tr.setText(batchObject.modObj.name);
                                break block0;
                            }
                            this.progBar.setString(batchObject.modObj.name);
                            this.progBar.setValue((int)(batchObject.process * 100.0f));
                            return this.progBar;
                        }
                        case 1: {
                            this.tr.setText(batchObject.fileObj);
                            break block0;
                        }
                        case 2: {
                            this.tr.setFont(this.monoFont);
                            this.tr.setText(batchObject.loopObj.variable + " = " + batchObject.loopObj.startIdx + " TO " + batchObject.loopObj.stopIdx);
                            break block0;
                        }
                        case 3: {
                            this.tr.setFont(this.monoFont);
                            this.tr.setText(String.valueOf(batchObject.loopObj.variable));
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            this.tr.setFont(this.italicFont);
                            this.tr.setText(batchObject.labelObj);
                            break block0;
                        }
                    }
                    this.tr.setText("");
                    break;
                }
                case 3: {
                    if (!(object instanceof BatchObject)) break;
                    BatchObject batchObject = (BatchObject)object;
                    if (!BatchObject.CMD_CANERROR[batchObject.command]) break;
                    this.tr.setText(ERR_NAMES[batchObject.errorCmd]);
                    break;
                }
                case 4: {
                    if (!(object instanceof BatchObject)) break;
                    BatchObject batchObject = (BatchObject)object;
                    if (batchObject.errorCmd != 2 || !BatchObject.CMD_CANERROR[batchObject.command]) break;
                    this.tr.setFont(this.italicFont);
                    this.tr.setText(batchObject.labelObj);
                    break;
                }
                default: {
                    this.tr.setText(object.toString());
                }
            }
            return this.tr;
        }
    }

    protected static class BatchTableModel
    extends AbstractTableModel {
        private static final String[] columnNames = new String[]{"Line", "Command", "Object", "On Error", "Error Label"};
        private List<BatchObject> batchVector;
        private static Class integerClass = Integer.class;
        private static Class batchObjectClass = BatchObject.class;

        protected BatchTableModel(List<BatchObject> list) {
            this.batchVector = list;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.batchVector.size();
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
            }
            return this.batchVector.get(n);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return integerClass;
                }
            }
            return batchObjectClass;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            block0 : switch (n2) {
                case 1: {
                    if (!(object instanceof String)) break;
                    for (int i = 0; i < BatchCellRenderer.CMD_NAMES.length; ++i) {
                        if (!object.equals(BatchCellRenderer.CMD_NAMES[i])) continue;
                        this.batchVector.get((int)n).command = i;
                        break block0;
                    }
                    break;
                }
                case 2: {
                    this.batchVector.set(n, (BatchObject)object);
                    break;
                }
                case 3: {
                    if (!(object instanceof String)) break;
                    for (int i = 0; i < BatchCellRenderer.ERR_NAMES.length; ++i) {
                        if (!object.equals(BatchCellRenderer.ERR_NAMES[i])) continue;
                        this.batchVector.get((int)n).errorCmd = i;
                        break block0;
                    }
                    break;
                }
            }
            this.fireTableRowsUpdated(n, n);
        }
    }
}

