/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.gui;

import de.sciss.fscape.gui.GUISupport;
import de.sciss.fscape.gui.GroupLabel;
import de.sciss.fscape.gui.ParamField;
import de.sciss.fscape.gui.PathField;
import de.sciss.fscape.io.GenericFile;
import de.sciss.fscape.prop.Presets;
import de.sciss.fscape.prop.PropertyArray;
import de.sciss.fscape.session.ModulePanel;
import de.sciss.fscape.util.Constants;
import de.sciss.fscape.util.Filter;
import de.sciss.fscape.util.Param;
import de.sciss.fscape.util.ParamSpace;
import de.sciss.fscape.util.Util;
import de.sciss.io.AudioFile;
import de.sciss.io.AudioFileDescr;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BeltramiDecompositionDlg
extends ModulePanel {
    private static final int PR_INIMGFILE = 0;
    private static final int PR_OUTPUTFILE = 1;
    private static final int PR_OUTPUTTYPE = 0;
    private static final int PR_OUTPUTRES = 1;
    private static final int PR_OUTPUTRATE = 2;
    private static final int PR_GAINTYPE = 3;
    private static final int PR_SCANDIR = 4;
    private static final int PR_CLPSEDIR = 5;
    private static final int PR_GAIN = 0;
    private static final int PR_CHUNKSIZE = 1;
    private static final int PR_SPACEOVERLAP = 2;
    private static final int PR_TIMEOVERLAP = 3;
    private static final int PR_TIMEJITTER = 4;
    private static final int PR_HIGHPASS = 0;
    private static final String PRN_INIMGFILE = "InImgFile";
    private static final String PRN_OUTPUTFILE = "OutputFile";
    private static final String PRN_OUTPUTTYPE = "OutputType";
    private static final String PRN_OUTPUTRES = "OutputReso";
    private static final String PRN_OUTPUTRATE = "OutputRate";
    private static final String PRN_SCANDIR = "ScanDir";
    private static final String PRN_CLPSEDIR = "CollapseDir";
    private static final String PRN_CHUNKSIZE = "ChunkSize";
    private static final String PRN_SPACEOVERLAP = "SpaceOverlap";
    private static final String PRN_TIMEOVERLAP = "TimeOverlap";
    private static final String PRN_TIMEJITTER = "TimeJitter";
    private static final String PRN_HIGHPASS = "HighPass";
    private static final int DIR_VERT = 0;
    private static final int DIR_HORIZ = 1;
    private static final String[] prText = new String[]{"", ""};
    private static final String[] prTextName = new String[]{"InImgFile", "OutputFile"};
    private static final int[] prIntg = new int[]{0, 0, 0, 0, 0, 0};
    private static final String[] prIntgName = new String[]{"OutputType", "OutputReso", "OutputRate", "GainType", "ScanDir", "CollapseDir"};
    private static final Param[] prPara = new Param[]{null, null, null, null, null};
    private static final String[] prParaName = new String[]{"Gain", "ChunkSize", "SpaceOverlap", "TimeOverlap", "TimeJitter"};
    private static final boolean[] prBool = new boolean[]{false};
    private static final String[] prBoolName = new String[]{"HighPass"};
    private static final int GG_INIMGFILE = 1024;
    private static final int GG_OUTPUTFILE = 1025;
    private static final int GG_OUTPUTTYPE = 256;
    private static final int GG_OUTPUTRES = 257;
    private static final int GG_OUTPUTRATE = 258;
    private static final int GG_GAINTYPE = 259;
    private static final int GG_SCANDIR = 260;
    private static final int GG_CLPSEDIR = 261;
    private static final int GG_HIGHPASS = 0;
    private static final int GG_GAIN = 512;
    private static final int GG_CHUNKSIZE = 513;
    private static final int GG_SPACEOVERLAP = 514;
    private static final int GG_TIMEOVERLAP = 515;
    private static final int GG_TIMEJITTER = 516;
    private static PropertyArray static_pr = null;
    private static Presets static_presets = null;

    public BeltramiDecompositionDlg() {
        super("Beltrami Decomposition");
        this.init2();
    }

    @Override
    protected void buildGUI() {
        if (static_pr == null) {
            static_pr = new PropertyArray();
            BeltramiDecompositionDlg.static_pr.text = prText;
            BeltramiDecompositionDlg.static_pr.textName = prTextName;
            BeltramiDecompositionDlg.static_pr.intg = prIntg;
            BeltramiDecompositionDlg.static_pr.intgName = prIntgName;
            BeltramiDecompositionDlg.static_pr.bool = prBool;
            BeltramiDecompositionDlg.static_pr.boolName = prBoolName;
            BeltramiDecompositionDlg.static_pr.para = prPara;
            BeltramiDecompositionDlg.static_pr.para[1] = new Param(128.0, 0);
            BeltramiDecompositionDlg.static_pr.para[2] = new Param(50.0, 18);
            BeltramiDecompositionDlg.static_pr.para[3] = new Param(12.5, 18);
            BeltramiDecompositionDlg.static_pr.para[4] = new Param(0.0, 18);
            BeltramiDecompositionDlg.static_pr.paraName = prParaName;
            this.fillDefaultAudioDescr(BeltramiDecompositionDlg.static_pr.intg, 0, 1, 2);
            this.fillDefaultGain(BeltramiDecompositionDlg.static_pr.para, 0);
            static_presets = new Presets(this.getClass(), static_pr.toProperties(true));
        }
        this.presets = static_presets;
        this.pr = (PropertyArray)static_pr.clone();
        this.gui = new GUISupport();
        GridBagConstraints gridBagConstraints = this.gui.getGridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
            }
        };
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.gui.addLabel(new GroupLabel("Waveform I/O", 1, 0));
        PathField pathField = new PathField(0, "Select input image file");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Image input", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField, 1024, null);
        PathField pathField2 = new PathField(113, "Select output file");
        pathField2.handleTypes(GenericFile.TYPES_SOUND);
        PathField[] pathFieldArray = new PathField[]{pathField};
        pathField2.deriveFrom(pathFieldArray, "$D0$F0Svd$E");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Waveform Output", 4));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.9;
        this.gui.addPathField(pathField2, 1025, null);
        this.gui.registerGadget(pathField2.getTypeGadget(), 256);
        this.gui.registerGadget(pathField2.getResGadget(), 257);
        this.gui.registerGadget(pathField2.getRateGadget(), 258);
        Component[] componentArray = this.createGadgets(0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Gain", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField((ParamField)componentArray[0], 512, null);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.gui.addChoice((JComboBox)componentArray[1], 259, itemListener);
        this.gui.addLabel(new GroupLabel("Settings", 1, 0));
        ParamSpace paramSpace = new ParamSpace(1.0, 2.147483647E9, 1.0, 0);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Vertical");
        jComboBox.addItem("Horizontal");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Scan Dir", 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox, 260, itemListener);
        ParamField paramField = new ParamField(Constants.spaces[11]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Space Overlap", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField, 514, null);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        jComboBox2.addItem("Vertical");
        jComboBox2.addItem("Horizontal");
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Collapse Dir", 4));
        gridBagConstraints.weightx = 0.2;
        this.gui.addChoice(jComboBox2, 261, itemListener);
        ParamField paramField2 = new ParamField(Constants.spaces[11]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Time Overlap", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField2, 515, null);
        ParamField paramField3 = new ParamField(paramSpace);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("Chunk Size", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addParamField(paramField3, 513, null);
        ParamField paramField4 = new ParamField(Constants.spaces[11]);
        gridBagConstraints.weightx = 0.1;
        this.gui.addLabel(new JLabel("Time Jitter", 4));
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.gridwidth = 0;
        this.gui.addParamField(paramField4, 516, null);
        JCheckBox jCheckBox = new JCheckBox();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridwidth = 1;
        this.gui.addLabel(new JLabel("High Pass ", 4));
        gridBagConstraints.weightx = 0.4;
        this.gui.addCheckbox(jCheckBox, 0, null);
        this.initGUI(this, 6, this.gui);
    }

    protected void printVector(float[] fArray, String string) {
        int n;
        DecimalFormat decimalFormat = BeltramiDecompositionDlg.getDecimalFormat();
        System.out.println("Vector '" + string + "':");
        System.out.print("   ");
        for (n = 0; n < fArray.length; ++n) {
            System.out.print("          [," + n + "]");
        }
        System.out.println();
        System.out.print(" [1]");
        for (n = 0; n < fArray.length; ++n) {
            System.out.print(" " + decimalFormat.format(fArray[n]));
        }
        System.out.println("\n");
    }

    private static DecimalFormat getDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000000E00;-0.000000E00", decimalFormatSymbols);
        return decimalFormat;
    }

    protected void printMatrix(float[][] fArray, String string) {
        DecimalFormat decimalFormat = BeltramiDecompositionDlg.getDecimalFormat();
        System.out.println("Matrix '" + string + "':");
        for (int i = 0; i < fArray.length; ++i) {
            int n;
            if (i == 0) {
                System.out.print("     ");
                for (n = 0; n < fArray[i].length; ++n) {
                    System.out.print("          [," + n + "]");
                }
                System.out.println();
            }
            System.out.print(" [" + (i + 1) + ",]");
            for (n = 0; n < fArray[i].length; ++n) {
                System.out.print(" " + decimalFormat.format(fArray[i][n]));
            }
            System.out.println();
        }
        System.out.println("\n");
    }

    @Override
    public void fillGUI() {
        super.fillGUI();
        super.fillGUI(this.gui);
    }

    @Override
    public void fillPropertyArray() {
        super.fillPropertyArray();
        super.fillPropertyArray(this.gui);
    }

    @Override
    protected void process() {
        AudioFile audioFile;
        block36: {
            BufferedImage bufferedImage = null;
            audioFile = null;
            AudioFile audioFile2 = null;
            Param param = new Param(1.0, 1);
            float f = 1.0f;
            float f2 = 0.0f;
            int n = this.pr.intg[4];
            int n2 = this.pr.intg[5];
            int n3 = (int)this.pr.para[1].value;
            double d = this.pr.para[2].value / 100.0;
            double d2 = this.pr.para[3].value / 100.0;
            double d3 = 100.0 / this.pr.para[4].value;
            boolean bl = this.pr.bool[0];
            float[] fArray = new float[3];
            double d4 = 0.0;
            double d5 = 0.0;
            try {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                bufferedImage = ImageIO.read(new File(this.pr.text[0]));
                if (bufferedImage == null) {
                    throw new IOException("No matching image decoder found");
                }
                if (!this.threadRunning) break block36;
                PathField pathField = (PathField)this.gui.getItemObj(1025);
                if (pathField == null) {
                    throw new IOException("Bug! Missing property!");
                }
                AudioFileDescr audioFileDescr = new AudioFileDescr();
                audioFileDescr.channels = 1;
                pathField.fillStream(audioFileDescr);
                audioFile = AudioFile.openAsWrite((AudioFileDescr)audioFileDescr);
                if (!this.threadRunning) break block36;
                int n12 = bufferedImage.getWidth() - (bl ? 1 : 0);
                int n13 = bufferedImage.getHeight() - (bl ? 1 : 0);
                switch (n) {
                    case 0: {
                        n11 = n12;
                        n10 = Math.min(n13, n3);
                        n9 = 0;
                        n8 = Math.max(1, (int)((double)n10 * (1.0 - d) + 0.5));
                        n7 = (n13 - n10) / n8 + 1;
                        break;
                    }
                    case 1: {
                        n11 = Math.min(n12, n3);
                        n10 = n13;
                        n9 = Math.max(1, (int)((double)n11 * (1.0 - d) + 0.5));
                        n8 = 0;
                        n7 = (n12 - n11) / n9 + 1;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(n));
                    }
                }
                switch (n2) {
                    case 0: {
                        n6 = n11;
                        n5 = n10;
                        break;
                    }
                    case 1: {
                        n6 = n10;
                        n5 = n11;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(n2));
                    }
                }
                int n14 = Math.min(n6 - 1, (int)((double)n6 * d2 + 0.5));
                int n15 = n6 - n14;
                int n16 = Math.min(n6 >> 1, n14) & 0xFFFFFFFE;
                int n17 = n16 << 1;
                float[] fArray2 = Filter.createFullWindow(n17, 7);
                int n18 = -Math.min(n15 - 1, (int)((double)n15 * d3 + 0.5));
                int n19 = Math.min(n14 - 1, (int)((double)n14 * d3 + 0.5));
                int n20 = n19 - n18 + 1;
                Random random = new Random();
                float[] fArray3 = new float[n6];
                if (this.pr.intg[3] == 0) {
                    audioFile2 = this.createTempFile(audioFileDescr);
                    n4 = n7 + 1;
                } else {
                    f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)param, null).value;
                    n4 = n7;
                }
                if (!this.threadRunning) break block36;
                float[][] fArray4 = new float[n6][n5];
                int n21 = Math.min(n6 + 1, n5);
                float[] fArray5 = new float[n21];
                float[][] fArray6 = new float[n6][Math.min(n6, n5)];
                int n22 = 0;
                int n23 = 0;
                float[][] fArray7 = new float[1][Math.max(8192, n6)];
                float[] fArray8 = fArray7[0];
                for (int i = 0; i < n7; ++i) {
                    int n24;
                    switch (n2) {
                        case 0: {
                            int n25;
                            int n26;
                            int n27;
                            int n28 = n22;
                            for (n24 = 0; n24 < n6; ++n24) {
                                n27 = n23;
                                for (n26 = 0; n26 < n5; ++n26) {
                                    n25 = bufferedImage.getRGB(n28, n27);
                                    Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                    fArray4[n24][n26] = fArray[2];
                                    if (bl) {
                                        n25 = bufferedImage.getRGB(n28 + 1, n27);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray9 = fArray4[n24];
                                        int n29 = n26;
                                        fArray9[n29] = fArray9[n29] - fArray[2];
                                        n25 = bufferedImage.getRGB(n28, n27 + 1);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray10 = fArray4[n24];
                                        int n30 = n26;
                                        fArray10[n30] = fArray10[n30] - fArray[2];
                                        n25 = bufferedImage.getRGB(n28 + 1, n27 + 1);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray11 = fArray4[n24];
                                        int n31 = n26;
                                        fArray11[n31] = fArray11[n31] + fArray[2];
                                    }
                                    ++n27;
                                }
                                ++n28;
                            }
                            break;
                        }
                        case 1: {
                            int n25;
                            int n26;
                            int n27;
                            int n28 = n22;
                            for (n24 = 0; n24 < n5; ++n24) {
                                n27 = n23;
                                for (n26 = 0; n26 < n6; ++n26) {
                                    n25 = bufferedImage.getRGB(n28, n27);
                                    Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                    fArray4[n26][n24] = fArray[2];
                                    if (bl) {
                                        n25 = bufferedImage.getRGB(n28 + 1, n27);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray12 = fArray4[n26];
                                        int n32 = n24;
                                        fArray12[n32] = fArray12[n32] - fArray[2];
                                        n25 = bufferedImage.getRGB(n28, n27 + 1);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray13 = fArray4[n26];
                                        int n33 = n24;
                                        fArray13[n33] = fArray13[n33] - fArray[2];
                                        n25 = bufferedImage.getRGB(n28 + 1, n27 + 1);
                                        Color.RGBtoHSB(n25 >> 16 & 0xFF, n25 >> 8 & 0xFF, n25 & 0xFF, fArray);
                                        float[] fArray14 = fArray4[n26];
                                        int n34 = n24;
                                        fArray14[n34] = fArray14[n34] + fArray[2];
                                    }
                                    ++n27;
                                }
                                ++n28;
                            }
                            break;
                        }
                        default: {
                            assert (false) : n2;
                            break;
                        }
                    }
                    Util.clear(fArray5);
                    for (n24 = 0; n24 < fArray6.length; ++n24) {
                        Util.clear(fArray6[n24]);
                    }
                    this.svd(fArray4, fArray5, fArray6, null, (float)(i + 1) / (float)n4, false);
                    if (this.threadRunning) {
                        int n35;
                        float f3 = f * fArray5[0];
                        d4 = fArray6[0][0] * f3;
                        for (n24 = 0; n24 < n6; ++n24) {
                            double d6 = fArray6[n24][0] * f3;
                            double d7 = d6 - d4 + 0.99 * d5;
                            fArray8[n24] = (float)d7;
                            d4 = d6;
                            d5 = d7;
                        }
                        Util.mult(fArray2, 0, fArray8, 0, n16);
                        Util.mult(fArray2, n16, fArray8, n6 - n16, n16);
                        Util.add(fArray3, 0, fArray8, 0, n6);
                        int n36 = d3 > 0.0 ? n15 + random.nextInt(n20) + n18 : n15;
                        System.arraycopy(fArray8, n36, fArray3, 0, n6 - n36);
                        Util.clear(fArray3, n6 - n36, n36);
                        int n37 = n35 = i < n7 - 1 ? n36 : n6;
                        if (audioFile2 == null) {
                            audioFile.writeFrames(fArray7, 0, n35);
                        } else {
                            audioFile2.writeFrames(fArray7, 0, n35);
                        }
                        f2 = Math.max(f2, Util.maxAbs(fArray8, 0, n6));
                        n22 += n9;
                        n23 += n8;
                        continue;
                    }
                    break block36;
                }
                if (this.threadRunning) {
                    if (this.pr.intg[3] == 0) {
                        f = (float)Param.transform((Param)this.pr.para[0], (int)1, (Param)new Param((double)(1.0 / (double)f2), (int)1), null).value;
                        this.normalizeAudioFile(audioFile2, audioFile, fArray7, f, 1.0f);
                        f2 *= f;
                    }
                    if (this.threadRunning) {
                        audioFile.close();
                        audioFile = null;
                        this.handleClipping(f2);
                    }
                }
            }
            catch (IOException iOException) {
                this.setError(iOException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(new Exception("FScape ran out of memory"));
            }
        }
        if (audioFile != null) {
            audioFile.cleanUp();
        }
    }

    private void svd(float[][] fArray, float[] fArray2, float[][] fArray3, float[][] fArray4, float f, boolean bl) {
        int n;
        int n2;
        int n3;
        boolean bl2;
        int n4 = fArray.length;
        int n5 = fArray[0].length;
        int n6 = Math.min(n4, n5);
        int n7 = Math.min(n4 + 1, n5);
        boolean bl3 = fArray3 != null;
        boolean bl4 = bl2 = fArray4 != null;
        if (fArray2.length != n7 || bl3 && (fArray3.length != n4 || fArray3[0].length != n6) || bl2 && (fArray4.length != n5 || fArray4[0].length != n5)) {
            throw new IllegalArgumentException();
        }
        float[] fArray5 = new float[n5];
        float[] fArray6 = new float[n4];
        float f2 = (float)Math.pow(2.0, -48.0);
        float f3 = (float)Math.pow(2.0, -120.0);
        int n8 = Math.min(n4 - 1, n5);
        int n9 = Math.max(0, Math.min(n5 - 2, n4));
        int n10 = Math.max(n8, n9);
        int n11 = Math.min(n5, n4 + 1);
        float f4 = this.getProgression();
        float f5 = (f - f4) / (float)((long)n10 * (long)(n10 + 1) / 2L + (long)n11 * (long)(n11 + 1) / 2L + (bl3 ? (long)n8 * (long)(n8 + 1) / 2L : 0L) + (long)(bl2 ? n5 : 0));
        long l = 0L;
        for (n3 = 0; n3 < n10 && (bl || this.threadRunning); ++n3) {
            int n12;
            if (n3 < n8) {
                fArray2[n3] = 0.0f;
                for (n2 = n3; n2 < n4; ++n2) {
                    fArray2[n3] = BeltramiDecompositionDlg.hypot(fArray2[n3], fArray[n2][n3]);
                }
                if (fArray2[n3] != 0.0f) {
                    if (fArray[n3][n3] < 0.0f) {
                        fArray2[n3] = -fArray2[n3];
                    }
                    for (n2 = n3; n2 < n4; ++n2) {
                        float[] fArray7 = fArray[n2];
                        int n13 = n3;
                        fArray7[n13] = fArray7[n13] / fArray2[n3];
                    }
                    float[] fArray8 = fArray[n3];
                    int n14 = n3;
                    fArray8[n14] = fArray8[n14] + 1.0f;
                }
                fArray2[n3] = -fArray2[n3];
            }
            for (n2 = n3 + 1; n2 < n5; ++n2) {
                if (n3 < n8 && fArray2[n3] != 0.0f) {
                    float f6 = 0.0f;
                    for (n12 = n3; n12 < n4; ++n12) {
                        f6 += fArray[n12][n3] * fArray[n12][n2];
                    }
                    f6 = -f6 / fArray[n3][n3];
                    for (n12 = n3; n12 < n4; ++n12) {
                        float[] fArray9 = fArray[n12];
                        int n15 = n2;
                        fArray9[n15] = fArray9[n15] + f6 * fArray[n12][n3];
                    }
                }
                fArray5[n2] = fArray[n3][n2];
            }
            if (bl3 && n3 < n8) {
                for (n2 = n3; n2 < n4; ++n2) {
                    fArray3[n2][n3] = fArray[n2][n3];
                }
            }
            if (n3 < n9) {
                fArray5[n3] = 0.0f;
                for (n2 = n3 + 1; n2 < n5; ++n2) {
                    fArray5[n3] = BeltramiDecompositionDlg.hypot(fArray5[n3], fArray5[n2]);
                }
                if (fArray5[n3] != 0.0f) {
                    if (fArray5[n3 + 1] < 0.0f) {
                        fArray5[n3] = -fArray5[n3];
                    }
                    n2 = n3 + 1;
                    while (n2 < n5) {
                        int n16 = n2++;
                        fArray5[n16] = fArray5[n16] / fArray5[n3];
                    }
                    int n17 = n3 + 1;
                    fArray5[n17] = fArray5[n17] + 1.0f;
                }
                fArray5[n3] = -fArray5[n3];
                if (n3 + 1 < n4 && fArray5[n3] != 0.0f) {
                    for (n2 = n3 + 1; n2 < n4; ++n2) {
                        fArray6[n2] = 0.0f;
                    }
                    for (n2 = n3 + 1; n2 < n5; ++n2) {
                        for (int i = n3 + 1; i < n4; ++i) {
                            int n18 = i;
                            fArray6[n18] = fArray6[n18] + fArray5[n2] * fArray[i][n2];
                        }
                    }
                    for (n2 = n3 + 1; n2 < n5; ++n2) {
                        float f7 = -fArray5[n2] / fArray5[n3 + 1];
                        for (n12 = n3 + 1; n12 < n4; ++n12) {
                            float[] fArray10 = fArray[n12];
                            int n19 = n2;
                            fArray10[n19] = fArray10[n19] + f7 * fArray6[n12];
                        }
                    }
                }
                if (bl2) {
                    for (n2 = n3 + 1; n2 < n5; ++n2) {
                        fArray4[n2][n3] = fArray5[n2];
                    }
                }
            }
            this.setProgression((float)(l += (long)(n10 - n3)) * f5 + f4);
        }
        if (!bl && !this.threadRunning) {
            return;
        }
        n3 = n11;
        if (n8 < n5) {
            fArray2[n8] = fArray[n8][n8];
        }
        if (n4 < n3) {
            fArray2[n3 - 1] = 0.0f;
        }
        if (n9 + 1 < n3) {
            fArray5[n9] = fArray[n9][n3 - 1];
        }
        fArray5[n3 - 1] = 0.0f;
        if (bl3) {
            for (n2 = n8; n2 < n6; ++n2) {
                for (int i = 0; i < n4; ++i) {
                    fArray3[i][n2] = 0.0f;
                }
                fArray3[n2][n2] = 1.0f;
            }
            for (n2 = n8 - 1; n2 >= 0; --n2) {
                int n20;
                if (fArray2[n2] != 0.0f) {
                    for (n20 = n2 + 1; n20 < n6; ++n20) {
                        float f8 = 0.0f;
                        for (n = n2; n < n4; ++n) {
                            f8 += fArray3[n][n2] * fArray3[n][n20];
                        }
                        f8 = -f8 / fArray3[n2][n2];
                        for (n = n2; n < n4; ++n) {
                            float[] fArray11 = fArray3[n];
                            int n21 = n20;
                            fArray11[n21] = fArray11[n21] + f8 * fArray3[n][n2];
                        }
                    }
                    for (n20 = n2; n20 < n4; ++n20) {
                        fArray3[n20][n2] = -fArray3[n20][n2];
                    }
                    fArray3[n2][n2] = 1.0f + fArray3[n2][n2];
                    for (n20 = 0; n20 < n2 - 1; ++n20) {
                        fArray3[n20][n2] = 0.0f;
                    }
                } else {
                    for (n20 = 0; n20 < n4; ++n20) {
                        fArray3[n20][n2] = 0.0f;
                    }
                    fArray3[n2][n2] = 1.0f;
                }
                this.setProgression((float)(l += (long)(n8 - n2)) * f5 + f4);
            }
        }
        if (bl2) {
            for (n2 = n5 - 1; n2 >= 0; --n2) {
                int n22;
                if (n2 < n9 && fArray5[n2] != 0.0f) {
                    for (n22 = n2 + 1; n22 < n6; ++n22) {
                        float f9 = 0.0f;
                        for (n = n2 + 1; n < n5; ++n) {
                            f9 += fArray4[n][n2] * fArray4[n][n22];
                        }
                        f9 = -f9 / fArray4[n2 + 1][n2];
                        for (n = n2 + 1; n < n5; ++n) {
                            float[] fArray12 = fArray4[n];
                            int n23 = n22;
                            fArray12[n23] = fArray12[n23] + f9 * fArray4[n][n2];
                        }
                    }
                }
                for (n22 = 0; n22 < n5; ++n22) {
                    fArray4[n22][n2] = 0.0f;
                }
                fArray4[n2][n2] = 1.0f;
                this.setProgression((float)(++l) * f5 + f4);
            }
        }
        n2 = n3 - 1;
        int n24 = 0;
        block35: while (n3 > 0 && (bl || this.threadRunning)) {
            float f10;
            int n25;
            int n26;
            for (n26 = n3 - 2; n26 >= -1 && n26 != -1; --n26) {
                if (!(Math.abs(fArray5[n26]) <= f3 + f2 * (Math.abs(fArray2[n26]) + Math.abs(fArray2[n26 + 1])))) continue;
                fArray5[n26] = 0.0f;
                break;
            }
            if (n26 == n3 - 2) {
                n = 4;
            } else {
                for (n25 = n3 - 1; n25 >= n26 && n25 != n26; --n25) {
                    f10 = (n25 != n3 ? Math.abs(fArray5[n25]) : 0.0f) + (n25 != n26 + 1 ? Math.abs(fArray5[n25 - 1]) : 0.0f);
                    if (!(Math.abs(fArray2[n25]) <= f3 + f2 * f10)) continue;
                    fArray2[n25] = 0.0f;
                    break;
                }
                if (n25 == n26) {
                    n = 3;
                } else if (n25 == n3 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n26 = n25;
                }
            }
            ++n26;
            switch (n) {
                case 1: {
                    float f11;
                    float f12;
                    float f13;
                    float f14;
                    float f15 = fArray5[n3 - 2];
                    fArray5[n3 - 2] = 0.0f;
                    for (int i = n3 - 2; i >= n26; --i) {
                        f14 = BeltramiDecompositionDlg.hypot(fArray2[i], f15);
                        f13 = fArray2[i] / f14;
                        f12 = f15 / f14;
                        fArray2[i] = f14;
                        if (i != n26) {
                            f15 = -f12 * fArray5[i - 1];
                            fArray5[i - 1] = f13 * fArray5[i - 1];
                        }
                        if (!bl2) continue;
                        for (int j = 0; j < n5; ++j) {
                            f11 = f13 * fArray4[j][i] + f12 * fArray4[j][n3 - 1];
                            fArray4[j][n3 - 1] = -f12 * fArray4[j][i] + f13 * fArray4[j][n3 - 1];
                            fArray4[j][i] = f11;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    float f11;
                    float f12;
                    float f13;
                    float f14;
                    float f16 = fArray5[n26 - 1];
                    fArray5[n26 - 1] = 0.0f;
                    for (int i = n26; i < n3; ++i) {
                        f14 = BeltramiDecompositionDlg.hypot(fArray2[i], f16);
                        f13 = fArray2[i] / f14;
                        f12 = f16 / f14;
                        fArray2[i] = f14;
                        f16 = -f12 * fArray5[i];
                        fArray5[i] = f13 * fArray5[i];
                        if (!bl3) continue;
                        for (int j = 0; j < n4; ++j) {
                            f11 = f13 * fArray3[j][i] + f12 * fArray3[j][n26 - 1];
                            fArray3[j][n26 - 1] = -f12 * fArray3[j][i] + f13 * fArray3[j][n26 - 1];
                            fArray3[j][i] = f11;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    float f17;
                    float f18;
                    float f19 = Math.max(Math.max(Math.max(Math.max(Math.abs(fArray2[n3 - 1]), Math.abs(fArray2[n3 - 2])), Math.abs(fArray5[n3 - 2])), Math.abs(fArray2[n26])), Math.abs(fArray5[n26]));
                    f10 = fArray2[n3 - 1] / f19;
                    float f14 = fArray2[n3 - 2] / f19;
                    float f13 = fArray5[n3 - 2] / f19;
                    float f12 = fArray2[n26] / f19;
                    float f20 = fArray5[n26] / f19;
                    float f11 = ((f14 + f10) * (f14 - f10) + f13 * f13) / 2.0f;
                    float f21 = f10 * f13 * (f10 * f13);
                    if (f11 != 0.0f || f21 != 0.0f) {
                        f18 = f11 >= 0.0f ? (float)Math.sqrt(f11 * f11 + f21) : (float)(-Math.sqrt(f11 * f11 + f21));
                        f17 = f21 / (f11 + f18);
                    } else {
                        f17 = 0.0f;
                    }
                    f18 = (f12 + f10) * (f12 - f10) + f17;
                    float f22 = f12 * f20;
                    for (int i = n26; i < n3 - 1; ++i) {
                        float f23;
                        int n27;
                        float f24 = BeltramiDecompositionDlg.hypot(f18, f22);
                        float f25 = f18 / f24;
                        float f26 = f22 / f24;
                        if (i != n26) {
                            fArray5[i - 1] = f24;
                        }
                        f18 = f25 * fArray2[i] + f26 * fArray5[i];
                        fArray5[i] = f25 * fArray5[i] - f26 * fArray2[i];
                        f22 = f26 * fArray2[i + 1];
                        fArray2[i + 1] = f25 * fArray2[i + 1];
                        if (bl2) {
                            for (n27 = 0; n27 < n5; ++n27) {
                                f23 = f25 * fArray4[n27][i] + f26 * fArray4[n27][i + 1];
                                fArray4[n27][i + 1] = -f26 * fArray4[n27][i] + f25 * fArray4[n27][i + 1];
                                fArray4[n27][i] = f23;
                            }
                        }
                        f24 = BeltramiDecompositionDlg.hypot(f18, f22);
                        f25 = f18 / f24;
                        f26 = f22 / f24;
                        fArray2[i] = f24;
                        f18 = f25 * fArray5[i] + f26 * fArray2[i + 1];
                        fArray2[i + 1] = -f26 * fArray5[i] + f25 * fArray2[i + 1];
                        f22 = f26 * fArray5[i + 1];
                        fArray5[i + 1] = f25 * fArray5[i + 1];
                        if (!bl3 || i >= n4 - 1) continue;
                        for (n27 = 0; n27 < n4; ++n27) {
                            f23 = f25 * fArray3[n27][i] + f26 * fArray3[n27][i + 1];
                            fArray3[n27][i + 1] = -f26 * fArray3[n27][i] + f25 * fArray3[n27][i + 1];
                            fArray3[n27][i] = f23;
                        }
                    }
                    fArray5[n3 - 2] = f18;
                    ++n24;
                    break;
                }
                case 4: {
                    if (fArray2[n26] <= 0.0f) {
                        float f27 = fArray2[n26] = fArray2[n26] < 0.0f ? -fArray2[n26] : 0.0f;
                        if (bl2) {
                            for (n25 = 0; n25 <= n2; ++n25) {
                                fArray4[n25][n26] = -fArray4[n25][n26];
                            }
                        }
                    }
                    while (n26 < n2 && !(fArray2[n26] >= fArray2[n26 + 1])) {
                        float f28 = fArray2[n26];
                        fArray2[n26] = fArray2[n26 + 1];
                        fArray2[n26 + 1] = f28;
                        if (bl2 && n26 < n5 - 1) {
                            for (int i = 0; i < n5; ++i) {
                                f28 = fArray4[i][n26 + 1];
                                fArray4[i][n26 + 1] = fArray4[i][n26];
                                fArray4[i][n26] = f28;
                            }
                        }
                        if (bl3 && n26 < n4 - 1) {
                            for (int i = 0; i < n4; ++i) {
                                f28 = fArray3[i][n26 + 1];
                                fArray3[i][n26 + 1] = fArray3[i][n26];
                                fArray3[i][n26] = f28;
                            }
                        }
                        ++n26;
                    }
                    n24 = 0;
                    this.setProgression((float)(l += (long)(--n3)) * f5 + f4);
                }
            }
        }
    }

    private static float hypot(float f, float f2) {
        if (Math.abs(f) > Math.abs(f2)) {
            float f3 = f2 / f;
            return (float)((double)Math.abs(f) * Math.sqrt(1.0f + f3 * f3));
        }
        if (f2 != 0.0f) {
            float f4 = f / f2;
            return (float)((double)Math.abs(f2) * Math.sqrt(1.0f + f4 * f4));
        }
        return 0.0f;
    }
}

